/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SendActionStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstanceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstanceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.batch.BusinessSituationServiceBatch;

/**
 * <p>
 *
 * This API is based on the OData protocol. It provides the situation instance and context data in the payload’s
 * response. This includes the situation instance ID, situation creation time, situation status, situation type ID,
 * situation template ID, situation anchor and trigger object key, anchor object, data context ID, data context, data
 * context creation time, situation activity ID, and situation activity. The payload data can then be consumed, for
 * example, by advanced analytics or automation. It also updates the situation action status for automation. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e3/1831d5c0934e34a982039cfd389211/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUSINESS_SITUATION_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUSINESS_SITUATION_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Situation Integration(SAP_COM_0345)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/31N'>Situation Handling(31N)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Situation</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessSituationService extends BatchService<BusinessSituationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUSINESS_SITUATION_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessSituationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext
     * SitnDataContext} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext
     *         SitnDataContext} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SitnDataContextFluentHelper getAllSitnDataContext();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext
     * SitnDataContext} entity using key fields.
     *
     * @param sitnDataContextID
     *            Data Context ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContext
     *         SitnDataContext} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnDataContextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SitnDataContextByKeyFluentHelper getSitnDataContextByKey( final String sitnDataContextID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance
     * SitnInstance} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance SitnInstance}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstanceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SitnInstanceFluentHelper getAllSitnInstance();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance
     * SitnInstance} entity using key fields.
     *
     * @param sitnInstanceID
     *            Instance ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstance SitnInstance}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SitnInstanceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SitnInstanceByKeyFluentHelper getSitnInstanceByKey( final String sitnInstanceID );

    /**
     * <p>
     * Creates a fluent helper for the <b>SendActionStatus</b> OData function import.
     * </p>
     *
     * @param sitnActionStatus
     *            Action status: SUCCESS or FAILURE
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SitnActionStatus</b>
     *            </p>
     * @param sitnActionInstanceID
     *            Unique action instance ID generated by the service client
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 36
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SitnActionInstanceID</b>
     *            </p>
     * @param sitnInstanceID
     *            Situation instance ID for which the action was performed
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SitnInstanceID</b>
     *            </p>
     * @param sitnActionID
     *            ActionID defined by situation template, NO_ACTION or UNKNOWN
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SitnActionID</b>
     *            </p>
     * @param sitnInstceTargetStatus
     *            Target instance status: OP(Open) RE(Resolved) UN(Unchanged)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SitnInstceTargetStatus</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SendActionStatus</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituation.SendActionStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SendActionStatusFluentHelper sendActionStatus(
        @Nonnull final String sitnActionInstanceID,
        @Nonnull final String sitnActionID,
        @Nonnull final String sitnActionStatus,
        @Nonnull final String sitnInstanceID,
        @Nonnull final String sitnInstceTargetStatus );

}
