/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchemaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchemaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.batch.BusinessSituationTypeServiceBatch;

/**
 * <p>
 *
 * This API is based on the OData protocol. It provides the situation instance and context data in the payload’s
 * response. This includes the situation instance ID, situation creation time, situation status, situation type ID,
 * situation template ID, situation anchor and trigger object key, anchor object, data context ID, data context, data
 * context creation time, situation activity ID, and situation activity. The payload data can then be consumed, for
 * example, by advanced analytics or automation. It also updates the situation action status for automation.
 *
 * Only use the version 2 of this API. Do not use version 1 as this version is deprecated..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/25/1bcc094bb64219adc396d13332ff23/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUS_SITN_MSTRDATA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUS_SITN_MSTRDATA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Situation Master Data Integration(SAP_COM_0376)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/31N'>Situation Handling(31N)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Situation Type</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessSituationTypeService extends BatchService<BusinessSituationTypeServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUS_SITN_MSTRDATA_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessSituationTypeService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationAction
     * SituationAction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationAction
     *         SituationAction} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationActionFluentHelper getAllSituationAction();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationAction
     * SituationAction} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param sitnActionID
     *            Action ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationAction
     *         SituationAction} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationActionByKeyFluentHelper
        getSituationActionByKey( final String sitnDefTemplateID, final String sitnActionID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText
     * SituationActionText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText
     *         SituationActionText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationActionTextFluentHelper getAllSituationActionText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText
     * SituationActionText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sitnActionID
     *            Action ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionText
     *         SituationActionText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationActionTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationActionTextByKeyFluentHelper
        getSituationActionTextByKey( final String sitnActionID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText
     * SituationTemplateText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText
     *         SituationTemplateText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTemplateTextFluentHelper getAllSituationTemplateText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText
     * SituationTemplateText} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateText
     *         SituationTemplateText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTemplateTextByKeyFluentHelper
        getSituationTemplateTextByKey( final String sitnDefTemplateID, final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationType
     * SituationType} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationType
     *         SituationType} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTypeFluentHelper getAllSituationType();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationType
     * SituationType} entity using key fields.
     *
     * @param sitnDefinitionID
     *            Situation Type ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationType
     *         SituationType} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTypeByKeyFluentHelper getSituationTypeByKey( final String sitnDefinitionID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText
     * SituationTypeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText
     *         SituationTypeText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTypeTextFluentHelper getAllSituationTypeText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText
     * SituationTypeText} entity using key fields.
     *
     * @param sitnDefinitionID
     *            Situation Type ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeText
     *         SituationTypeText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTypeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTypeTextByKeyFluentHelper
        getSituationTypeTextByKey( final String sitnDefinitionID, final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate
     * SituationTemplate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate
     *         SituationTemplate} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTemplateFluentHelper getAllSituationTemplate();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate
     * SituationTemplate} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplate
     *         SituationTemplate} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationTemplateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTemplateByKeyFluentHelper getSituationTemplateByKey( final String sitnDefTemplateID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchema
     * SituationContextDefSchema} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchema
     *         SituationContextDefSchema} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchemaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationContextDefSchemaFluentHelper getAllSituationContextDefSchema();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchema
     * SituationContextDefSchema} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param sitnDataCntxtFormatVersion
     *            Context Format Version
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param sitnDataCntxtSchemaVersion
     *            Schema Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchema
     *         SituationContextDefSchema} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefSchemaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationContextDefSchemaByKeyFluentHelper getSituationContextDefSchemaByKey(
        final String sitnDefTemplateID,
        final Integer sitnDataCntxtFormatVersion,
        final Integer sitnDataCntxtSchemaVersion );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefText
     * SituationContextDefText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefText
     *         SituationContextDefText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationContextDefTextFluentHelper getAllSituationContextDefText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefText
     * SituationContextDefText} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sitnDataCntxtFormatVersion
     *            Context Format Version
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param sitnDataCntxtSchemaVersion
     *            Schema Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefText
     *         SituationContextDefText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtype.SituationContextDefTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationContextDefTextByKeyFluentHelper getSituationContextDefTextByKey(
        final String sitnDefTemplateID,
        final Integer sitnDataCntxtFormatVersion,
        final Integer sitnDataCntxtSchemaVersion,
        final String language );

}
