/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchemaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchemaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.batch.BusinessSituationTypeV2ServiceBatch;

/**
 * <p>
 *
 * This API is based on the OData protocol. It provides the situation instance and context data in the payload’s
 * response. This includes the situation instance ID, situation creation time, situation status, situation type ID,
 * situation template ID, situation anchor and trigger object key, anchor object, data context ID, data context, data
 * context creation time, situation activity ID, and situation activity. The payload data can then be consumed, for
 * example, by advanced analytics or automation. It also updates the situation action status for automation.
 *
 * The version 2 of this API also provides a version property in the entities Schema for Data Context Definition and
 * Schema for Data Context Definition - Text to reflect different versions of the data context definition..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/0f/db312b9c6148d485f0098f053bbd76/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_BUS_SITN_MSTRDATA_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_BUS_SITN_MSTRDATA_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Situation Master Data Integration(SAP_COM_0376)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/31N'>Situation Handling(31N)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Situation Type</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessSituationTypeV2Service extends BatchService<BusinessSituationTypeV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUS_SITN_MSTRDATA_SRV;v=0002";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessSituationTypeV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction
     * SituationAction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction
     *         SituationAction} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationActionFluentHelper getAllSituationAction();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction
     * SituationAction} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param sitnActionID
     *            Action ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationAction
     *         SituationAction} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationActionByKeyFluentHelper
        getSituationActionByKey( final String sitnDefTemplateID, final String sitnActionID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionText
     * SituationActionText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionText
     *         SituationActionText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationActionTextFluentHelper getAllSituationActionText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionText
     * SituationActionText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sitnActionID
     *            Action ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionText
     *         SituationActionText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationActionTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationActionTextByKeyFluentHelper
        getSituationActionTextByKey( final String sitnActionID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateText
     * SituationTemplateText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateText
     *         SituationTemplateText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTemplateTextFluentHelper getAllSituationTemplateText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateText
     * SituationTemplateText} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateText
     *         SituationTemplateText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTemplateTextByKeyFluentHelper
        getSituationTemplateTextByKey( final String sitnDefTemplateID, final String language );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType
     * SituationType} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType
     *         SituationType} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTypeFluentHelper getAllSituationType();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType
     * SituationType} entity using key fields.
     *
     * @param sitnDefinitionID
     *            Situation Type ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationType
     *         SituationType} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTypeByKeyFluentHelper getSituationTypeByKey( final String sitnDefinitionID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeText
     * SituationTypeText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeText
     *         SituationTypeText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTypeTextFluentHelper getAllSituationTypeText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeText
     * SituationTypeText} entity using key fields.
     *
     * @param sitnDefinitionID
     *            Situation Type ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeText
     *         SituationTypeText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTypeTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTypeTextByKeyFluentHelper
        getSituationTypeTextByKey( final String sitnDefinitionID, final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplate
     * SituationTemplate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplate
     *         SituationTemplate} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTemplateFluentHelper getAllSituationTemplate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplate
     * SituationTemplate} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplate
     *         SituationTemplate} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationTemplateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationTemplateByKeyFluentHelper getSituationTemplateByKey( final String sitnDefTemplateID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema
     * SituationContextDefSchema} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema
     *         SituationContextDefSchema} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchemaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationContextDefSchemaFluentHelper getAllSituationContextDefSchema();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema
     * SituationContextDefSchema} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param sitnDataCntxtVersion
     *            Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param sitnDataCntxtFormatVersion
     *            Context Format Version
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param sitnDataCntxtSchemaVersion
     *            Schema Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchema
     *         SituationContextDefSchema} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefSchemaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationContextDefSchemaByKeyFluentHelper getSituationContextDefSchemaByKey(
        final String sitnDefTemplateID,
        final Integer sitnDataCntxtVersion,
        final Integer sitnDataCntxtFormatVersion,
        final Integer sitnDataCntxtSchemaVersion );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefText
     * SituationContextDefText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefText
     *         SituationContextDefText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationContextDefTextFluentHelper getAllSituationContextDefText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefText
     * SituationContextDefText} entity using key fields.
     *
     * @param sitnDefTemplateID
     *            Situation Standard Template ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @param sitnDataCntxtVersion
     *            Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sitnDataCntxtFormatVersion
     *            Context Format Version
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param sitnDataCntxtSchemaVersion
     *            Schema Version of Data Context Definition
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefText
     *         SituationContextDefText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssituationtypev2.SituationContextDefTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SituationContextDefTextByKeyFluentHelper getSituationContextDefTextByKey(
        final String sitnDefTemplateID,
        final Integer sitnDataCntxtVersion,
        final Integer sitnDataCntxtFormatVersion,
        final Integer sitnDataCntxtSchemaVersion,
        final String language );

}
