/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.LinkProjectItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.ReDistributeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.RejectItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.UnlinkProjectItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.batch.BusinessSolutionOrderServiceBatch;

/**
 * <p>
 *
 * You can use this service to integrate external applications with Business Solution Order processing in Service in SAP
 * S/4HANA Cloud. In each API call, you can use the following operations: - Retrieve Business Solution Order. - Create
 * Business Solution Order. Note: You must use “deep insert” requests (a header plus the following entities: Header
 * details, Header text, Sales Items, Service Items and Service Contract Items). - Create new items for existing
 * Business Solution Order. - Create an item reference object, item object list, item pricing element, and an item text
 * for existing Business Solution Order items. - Update the header, header text, item, item pricing element, and item
 * text of existing Business Solution Orders. - Delete the item, item reference object, item object list, item pricing
 * element, and item text of existing Business Solution Orders.
 *
 * # .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fb/d802bd29b1477082675f2eefe1e45b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUS_SOLUTION_ORDER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUS_SOLUTION_ORDER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business Solution Order Integration(SAP_COM_0706)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4GT'>Solution Order Management(4GT)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business Solution Order</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessSolutionOrderService extends BatchService<BusinessSolutionOrderServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_BUS_SOLUTION_ORDER_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessSolutionOrderService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm
     * BSOrdSrvcContrItmBillgReqItm} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm
     *         BSOrdSrvcContrItmBillgReqItm} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItmFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BSOrdSrvcContrItmBillgReqItmFluentHelper getAllBSOrdSrvcContrItmBillgReqItm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm
     * BSOrdSrvcContrItmBillgReqItm} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param billingRequestItem
     *            Billing Request Item No
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm
     *         BSOrdSrvcContrItmBillgReqItm} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItmByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BSOrdSrvcContrItmBillgReqItmByKeyFluentHelper getBSOrdSrvcContrItmBillgReqItmByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String billingRequestItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     * BusinessSolutionOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     *         BusinessSolutionOrder} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderFluentHelper getAllBusinessSolutionOrder();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     * BusinessSolutionOrder} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     *         BusinessSolutionOrder} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderByKeyFluentHelper getBusinessSolutionOrderByKey( final String businessSolutionOrder );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     * BusinessSolutionOrder} entity and save it to the S/4HANA system.
     *
     * @param businessSolutionOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     *            BusinessSolutionOrder} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     *         BusinessSolutionOrder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderCreateFluentHelper
        createBusinessSolutionOrder( @Nonnull final BusinessSolutionOrder businessSolutionOrder );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     * BusinessSolutionOrder} entity and save it to the S/4HANA system.
     *
     * @param businessSolutionOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     *            BusinessSolutionOrder} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     *         BusinessSolutionOrder} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderUpdateFluentHelper
        updateBusinessSolutionOrder( @Nonnull final BusinessSolutionOrder businessSolutionOrder );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *         BusinessSolutionOrderText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderTextFluentHelper getAllBusinessSolutionOrderText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *         BusinessSolutionOrderText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderTextByKeyFluentHelper getBusinessSolutionOrderTextByKey(
        final String businessSolutionOrder,
        final String language,
        final String textObjectType );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entity and save it to the S/4HANA system.
     *
     * @param businessSolutionOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *            BusinessSolutionOrderText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *         BusinessSolutionOrderText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderTextCreateFluentHelper
        createBusinessSolutionOrderText( @Nonnull final BusinessSolutionOrderText businessSolutionOrderText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entity and save it to the S/4HANA system.
     *
     * @param businessSolutionOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *            BusinessSolutionOrderText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *         BusinessSolutionOrderText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderTextUpdateFluentHelper
        updateBusinessSolutionOrderText( @Nonnull final BusinessSolutionOrderText businessSolutionOrderText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entity in the S/4HANA system.
     *
     * @param businessSolutionOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *            BusinessSolutionOrderText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *         BusinessSolutionOrderText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderTextDeleteFluentHelper
        deleteBusinessSolutionOrderText( @Nonnull final BusinessSolutionOrderText businessSolutionOrderText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElm
     * BusSolnOrdBillgReqItmPrcElm} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElm
     *         BusSolnOrdBillgReqItmPrcElm} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElmFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdBillgReqItmPrcElmFluentHelper getAllBusSolnOrdBillgReqItmPrcElm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElm
     * BusSolnOrdBillgReqItmPrcElm} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param billingRequestItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElm
     *         BusSolnOrdBillgReqItmPrcElm} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdBillgReqItmPrcElmByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdBillgReqItmPrcElmByKeyFluentHelper getBusSolnOrdBillgReqItmPrcElmByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String billingRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     * BusSolnOrdEntProjectItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *         BusSolnOrdEntProjectItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdEntProjectItemFluentHelper getAllBusSolnOrdEntProjectItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     * BusSolnOrdEntProjectItem} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *         BusSolnOrdEntProjectItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdEntProjectItemByKeyFluentHelper
        getBusSolnOrdEntProjectItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     * BusSolnOrdEntProjectItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdEntProjectItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *            BusSolnOrdEntProjectItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *         BusSolnOrdEntProjectItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdEntProjectItemCreateFluentHelper
        createBusSolnOrdEntProjectItem( @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     * BusSolnOrdEntProjectItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdEntProjectItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *            BusSolnOrdEntProjectItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *         BusSolnOrdEntProjectItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdEntProjectItemUpdateFluentHelper
        updateBusSolnOrdEntProjectItem( @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     * BusSolnOrdEntProjectItem} entity in the S/4HANA system.
     *
     * @param busSolnOrdEntProjectItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *            BusSolnOrdEntProjectItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *         BusSolnOrdEntProjectItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdEntProjectItemDeleteFluentHelper
        deleteBusSolnOrdEntProjectItem( @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     * BusSolnOrderExpenseItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *         BusSolnOrderExpenseItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderExpenseItemFluentHelper getAllBusSolnOrderExpenseItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     * BusSolnOrderExpenseItem} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *         BusSolnOrderExpenseItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderExpenseItemByKeyFluentHelper
        getBusSolnOrderExpenseItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     * BusSolnOrderExpenseItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderExpenseItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *            BusSolnOrderExpenseItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *         BusSolnOrderExpenseItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderExpenseItemCreateFluentHelper
        createBusSolnOrderExpenseItem( @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     * BusSolnOrderExpenseItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderExpenseItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *            BusSolnOrderExpenseItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *         BusSolnOrderExpenseItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderExpenseItemUpdateFluentHelper
        updateBusSolnOrderExpenseItem( @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     * BusSolnOrderExpenseItem} entity in the S/4HANA system.
     *
     * @param busSolnOrderExpenseItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *            BusSolnOrderExpenseItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *         BusSolnOrderExpenseItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderExpenseItemDeleteFluentHelper
        deleteBusSolnOrderExpenseItem( @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrder
     * BusSolnOrderFUPSalesOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrder
     *         BusSolnOrderFUPSalesOrder} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderFUPSalesOrderFluentHelper getAllBusSolnOrderFUPSalesOrder();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrder
     * BusSolnOrderFUPSalesOrder} entity using key fields.
     *
     * @param serviceDocumentRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocRltnSequenceNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrder
     *         BusSolnOrderFUPSalesOrder} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderFUPSalesOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderFUPSalesOrderByKeyFluentHelper getBusSolnOrderFUPSalesOrderByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     * BusSolnOrderItemObjectList} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     *         BusSolnOrderItemObjectList} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemObjectListFluentHelper getAllBusSolnOrderItemObjectList();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     * BusSolnOrderItemObjectList} entity using key fields.
     *
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     *         BusSolnOrderItemObjectList} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemObjectListByKeyFluentHelper getBusSolnOrderItemObjectListByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String product,
        final String equipment,
        final String serviceRefFunctionalLocation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     * BusSolnOrderItemObjectList} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemObjectList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     *            BusSolnOrderItemObjectList} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     *         BusSolnOrderItemObjectList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemObjectListCreateFluentHelper
        createBusSolnOrderItemObjectList( @Nonnull final BusSolnOrderItemObjectList busSolnOrderItemObjectList );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     * BusSolnOrderItemObjectList} entity in the S/4HANA system.
     *
     * @param busSolnOrderItemObjectList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     *            BusSolnOrderItemObjectList} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     *         BusSolnOrderItemObjectList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectListDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemObjectListDeleteFluentHelper
        deleteBusSolnOrderItemObjectList( @Nonnull final BusSolnOrderItemObjectList busSolnOrderItemObjectList );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     * BusSolnOrderItemPriceElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *         BusSolnOrderItemPriceElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemPriceElementFluentHelper getAllBusSolnOrderItemPriceElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     * BusSolnOrderItemPriceElement} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param businessSolutionOrderItem
     *            Condition item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *         BusSolnOrderItemPriceElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemPriceElementByKeyFluentHelper getBusSolnOrderItemPriceElementByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     * BusSolnOrderItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *            BusSolnOrderItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *         BusSolnOrderItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemPriceElementCreateFluentHelper
        createBusSolnOrderItemPriceElement( @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     * BusSolnOrderItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *            BusSolnOrderItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *         BusSolnOrderItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemPriceElementUpdateFluentHelper
        updateBusSolnOrderItemPriceElement( @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     * BusSolnOrderItemPriceElement} entity in the S/4HANA system.
     *
     * @param busSolnOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *            BusSolnOrderItemPriceElement} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *         BusSolnOrderItemPriceElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElementDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemPriceElementDeleteFluentHelper
        deleteBusSolnOrderItemPriceElement( @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     * BusSolnOrderItemProductList} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *         BusSolnOrderItemProductList} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemProductListFluentHelper getAllBusSolnOrderItemProductList();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     * BusSolnOrderItemProductList} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcProductListProduct
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *         BusSolnOrderItemProductList} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemProductListByKeyFluentHelper getBusSolnOrderItemProductListByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String srvcProductListProduct );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     * BusSolnOrderItemProductList} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemProductList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *            BusSolnOrderItemProductList} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *         BusSolnOrderItemProductList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemProductListCreateFluentHelper
        createBusSolnOrderItemProductList( @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     * BusSolnOrderItemProductList} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemProductList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *            BusSolnOrderItemProductList} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *         BusSolnOrderItemProductList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemProductListUpdateFluentHelper
        updateBusSolnOrderItemProductList( @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     * BusSolnOrderItemProductList} entity in the S/4HANA system.
     *
     * @param busSolnOrderItemProductList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *            BusSolnOrderItemProductList} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *         BusSolnOrderItemProductList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductListDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemProductListDeleteFluentHelper
        deleteBusSolnOrderItemProductList( @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLine
     * BusSolnOrderItemScheduleLine} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLine
     *         BusSolnOrderItemScheduleLine} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLineFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemScheduleLineFluentHelper getAllBusSolnOrderItemScheduleLine();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLine
     * BusSolnOrderItemScheduleLine} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param scheduleLine
     *            Schedule Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLine
     *         BusSolnOrderItemScheduleLine} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemScheduleLineByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderItemScheduleLineByKeyFluentHelper getBusSolnOrderItemScheduleLineByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String scheduleLine );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *         BusSolnOrderSalesItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderSalesItemFluentHelper getAllBusSolnOrderSalesItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *         BusSolnOrderSalesItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderSalesItemByKeyFluentHelper
        getBusSolnOrderSalesItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderSalesItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *            BusSolnOrderSalesItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *         BusSolnOrderSalesItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderSalesItemCreateFluentHelper
        createBusSolnOrderSalesItem( @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderSalesItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *            BusSolnOrderSalesItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *         BusSolnOrderSalesItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderSalesItemUpdateFluentHelper
        updateBusSolnOrderSalesItem( @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entity in the S/4HANA system.
     *
     * @param busSolnOrderSalesItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *            BusSolnOrderSalesItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *         BusSolnOrderSalesItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderSalesItemDeleteFluentHelper
        deleteBusSolnOrderSalesItem( @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     * BusSolnOrderServiceItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *         BusSolnOrderServiceItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderServiceItemFluentHelper getAllBusSolnOrderServiceItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     * BusSolnOrderServiceItem} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *         BusSolnOrderServiceItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderServiceItemByKeyFluentHelper
        getBusSolnOrderServiceItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     * BusSolnOrderServiceItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderServiceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *            BusSolnOrderServiceItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *         BusSolnOrderServiceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderServiceItemCreateFluentHelper
        createBusSolnOrderServiceItem( @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     * BusSolnOrderServiceItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderServiceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *            BusSolnOrderServiceItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *         BusSolnOrderServiceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderServiceItemUpdateFluentHelper
        updateBusSolnOrderServiceItem( @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     * BusSolnOrderServiceItem} entity in the S/4HANA system.
     *
     * @param busSolnOrderServiceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *            BusSolnOrderServiceItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *         BusSolnOrderServiceItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrderServiceItemDeleteFluentHelper
        deleteBusSolnOrderServiceItem( @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProject
     * BusSolnOrdFUPEntProject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProject
     *         BusSolnOrdFUPEntProject} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdFUPEntProjectFluentHelper getAllBusSolnOrdFUPEntProject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProject
     * BusSolnOrdFUPEntProject} entity using key fields.
     *
     * @param serviceDocumentRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocRltnSequenceNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProject
     *         BusSolnOrdFUPEntProject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdFUPEntProjectByKeyFluentHelper getBusSolnOrdFUPEntProjectByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContract
     * BusSolnOrdFUPServiceContract} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContract
     *         BusSolnOrdFUPServiceContract} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContractFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdFUPServiceContractFluentHelper getAllBusSolnOrdFUPServiceContract();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContract
     * BusSolnOrdFUPServiceContract} entity using key fields.
     *
     * @param serviceDocumentRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocRltnSequenceNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContract
     *         BusSolnOrdFUPServiceContract} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceContractByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdFUPServiceContractByKeyFluentHelper getBusSolnOrdFUPServiceContractByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder
     * BusSolnOrdFUPServiceOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder
     *         BusSolnOrdFUPServiceOrder} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdFUPServiceOrderFluentHelper getAllBusSolnOrdFUPServiceOrder();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder
     * BusSolnOrdFUPServiceOrder} entity using key fields.
     *
     * @param serviceDocumentRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocRltnSequenceNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder
     *         BusSolnOrdFUPServiceOrder} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdFUPServiceOrderByKeyFluentHelper getBusSolnOrdFUPServiceOrderByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn
     * BusSolnOrdFUPSubscrpn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn
     *         BusSolnOrdFUPSubscrpn} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdFUPSubscrpnFluentHelper getAllBusSolnOrdFUPSubscrpn();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn
     * BusSolnOrdFUPSubscrpn} entity using key fields.
     *
     * @param serviceDocumentRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocRltnSequenceNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn
     *         BusSolnOrdFUPSubscrpn} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdFUPSubscrpnByKeyFluentHelper getBusSolnOrdFUPSubscrpnByKey(
        final UUID serviceDocumentRelationUUID,
        final String serviceDocRltnSequenceNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     * BusSolnOrdItemRelationships} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     *         BusSolnOrdItemRelationships} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItemRelationshipsFluentHelper getAllBusSolnOrdItemRelationships();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     * BusSolnOrdItemRelationships} entity using key fields.
     *
     * @param srvcItemRelshpToItemNumber
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param srvcItemRelshpFromItemNumber
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcItemRelshpType
     *            Item Relationship Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     *         BusSolnOrdItemRelationships} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItemRelationshipsByKeyFluentHelper getBusSolnOrdItemRelationshipsByKey(
        final String businessSolutionOrder,
        final String srvcItemRelshpFromItemNumber,
        final String srvcItemRelshpType,
        final String srvcItemRelshpToItemNumber );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     * BusSolnOrdItemRelationships} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItemRelationships
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     *            BusSolnOrdItemRelationships} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     *         BusSolnOrdItemRelationships} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItemRelationshipsCreateFluentHelper
        createBusSolnOrdItemRelationships( @Nonnull final BusSolnOrdItemRelationships busSolnOrdItemRelationships );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     * BusSolnOrdItemRelationships} entity in the S/4HANA system.
     *
     * @param busSolnOrdItemRelationships
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     *            BusSolnOrdItemRelationships} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     *         BusSolnOrdItemRelationships} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationshipsDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItemRelationshipsDeleteFluentHelper
        deleteBusSolnOrdItemRelationships( @Nonnull final BusSolnOrdItemRelationships busSolnOrdItemRelationships );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     * BusSolnOrdItmConfiguration} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     *         BusSolnOrdItmConfiguration} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmConfigurationFluentHelper getAllBusSolnOrdItmConfiguration();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     * BusSolnOrdItmConfiguration} entity using key fields.
     *
     * @param charcValue
     *            Characteristic Value
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     * @param varConfignInstceBusObjectKey
     *            IB: Key of a Referencing Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param charcFromNumericValue
     *            Internal floating point from
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param variantConfigurationInstance
     *            IB: Component (instance)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param charcToNumericValue
     *            Internal floating point value to
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param varConfignInstceBusObjectType
     *            IB: External Type of a (Referencing) Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     *         BusSolnOrdItmConfiguration} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmConfigurationByKeyFluentHelper getBusSolnOrdItmConfigurationByKey(
        final String varConfignInstceBusObjectKey,
        final String varConfignInstceBusObjectType,
        final String variantConfigurationInstance,
        final String charcInternalID,
        final String charcValue,
        final Double charcFromNumericValue,
        final Double charcToNumericValue );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     * BusSolnOrdItmConfiguration} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmConfiguration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     *            BusSolnOrdItmConfiguration} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     *         BusSolnOrdItmConfiguration} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfigurationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmConfigurationCreateFluentHelper
        createBusSolnOrdItmConfiguration( @Nonnull final BusSolnOrdItmConfiguration busSolnOrdItmConfiguration );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProject
     * BusSolnOrdItmFUPEntProject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProject
     *         BusSolnOrdItmFUPEntProject} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPEntProjectFluentHelper getAllBusSolnOrdItmFUPEntProject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProject
     * BusSolnOrdItmFUPEntProject} entity using key fields.
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProject
     *         BusSolnOrdItmFUPEntProject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPEntProjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPEntProjectByKeyFluentHelper getBusSolnOrdItmFUPEntProjectByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder
     * BusSolnOrdItmFUPSalesOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder
     *         BusSolnOrdItmFUPSalesOrder} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPSalesOrderFluentHelper getAllBusSolnOrdItmFUPSalesOrder();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder
     * BusSolnOrdItmFUPSalesOrder} entity using key fields.
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder
     *         BusSolnOrdItmFUPSalesOrder} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPSalesOrderByKeyFluentHelper getBusSolnOrdItmFUPSalesOrderByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder
     * BusSolnOrdItmFUPServiceOrder} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder
     *         BusSolnOrdItmFUPServiceOrder} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPServiceOrderFluentHelper getAllBusSolnOrdItmFUPServiceOrder();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder
     * BusSolnOrdItmFUPServiceOrder} entity using key fields.
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder
     *         BusSolnOrdItmFUPServiceOrder} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPServiceOrderByKeyFluentHelper getBusSolnOrdItmFUPServiceOrderByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr
     * BusSolnOrdItmFUPSrvcContr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr
     *         BusSolnOrdItmFUPSrvcContr} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPSrvcContrFluentHelper getAllBusSolnOrdItmFUPSrvcContr();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr
     * BusSolnOrdItmFUPSrvcContr} entity using key fields.
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr
     *         BusSolnOrdItmFUPSrvcContr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPSrvcContrByKeyFluentHelper getBusSolnOrdItmFUPSrvcContrByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn
     * BusSolnOrdItmFUPSubscrpn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn
     *         BusSolnOrdItmFUPSubscrpn} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPSubscrpnFluentHelper getAllBusSolnOrdItmFUPSubscrpn();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn
     * BusSolnOrdItmFUPSubscrpn} entity using key fields.
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn
     *         BusSolnOrdItmFUPSubscrpn} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmFUPSubscrpnByKeyFluentHelper getBusSolnOrdItmFUPSubscrpnByKey(
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement
     * BusSolnOrdItmRateElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement
     *         BusSolnOrdItmRateElement} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmRateElementFluentHelper getAllBusSolnOrdItmRateElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement
     * BusSolnOrdItmRateElement} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subscriptionRateElementType
     *            Rate Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param subscriptionRateElement
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement
     *         BusSolnOrdItmRateElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmRateElementByKeyFluentHelper getBusSolnOrdItmRateElementByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionRateElement,
        final String subscriptionRateElementType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElm
     * BusSolnOrdItmRateElmntPrcElm} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElm
     *         BusSolnOrdItmRateElmntPrcElm} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElmFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmRateElmntPrcElmFluentHelper getAllBusSolnOrdItmRateElmntPrcElm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElm
     * BusSolnOrdItmRateElmntPrcElm} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param subscriptionRateElement
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElm
     *         BusSolnOrdItmRateElmntPrcElm} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElmntPrcElmByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmRateElmntPrcElmByKeyFluentHelper getBusSolnOrdItmRateElmntPrcElmByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionRateElement,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *         BusSolnOrdItmReferenceObject} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmReferenceObjectFluentHelper getAllBusSolnOrdItmReferenceObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param referenceProduct
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *         BusSolnOrdItmReferenceObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmReferenceObjectByKeyFluentHelper getBusSolnOrdItmReferenceObjectByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String referenceProduct,
        final String serviceRefFunctionalLocation,
        final String serviceReferenceEquipment );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmReferenceObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *            BusSolnOrdItmReferenceObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *         BusSolnOrdItmReferenceObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmReferenceObjectCreateFluentHelper
        createBusSolnOrdItmReferenceObject( @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmReferenceObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *            BusSolnOrdItmReferenceObject} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *         BusSolnOrdItmReferenceObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmReferenceObjectUpdateFluentHelper
        updateBusSolnOrdItmReferenceObject( @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmReferenceObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *            BusSolnOrdItmReferenceObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *         BusSolnOrdItmReferenceObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmReferenceObjectDeleteFluentHelper
        deleteBusSolnOrdItmReferenceObject( @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     * BusSolnOrdItmSubscrpnParam} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *         BusSolnOrdItmSubscrpnParam} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnParamFluentHelper getAllBusSolnOrdItmSubscrpnParam();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     * BusSolnOrdItmSubscrpnParam} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subscriptionParameter
     *            Subscription Billing Parameter ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 64
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *         BusSolnOrdItmSubscrpnParam} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnParamByKeyFluentHelper getBusSolnOrdItmSubscrpnParamByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionParameter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     * BusSolnOrdItmSubscrpnParam} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *            BusSolnOrdItmSubscrpnParam} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *         BusSolnOrdItmSubscrpnParam} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnParamCreateFluentHelper
        createBusSolnOrdItmSubscrpnParam( @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     * BusSolnOrdItmSubscrpnParam} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *            BusSolnOrdItmSubscrpnParam} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *         BusSolnOrdItmSubscrpnParam} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnParamUpdateFluentHelper
        updateBusSolnOrdItmSubscrpnParam( @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     * BusSolnOrdItmSubscrpnParam} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *            BusSolnOrdItmSubscrpnParam} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *         BusSolnOrdItmSubscrpnParam} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParamDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnParamDeleteFluentHelper
        deleteBusSolnOrdItmSubscrpnParam( @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *         BusSolnOrdItmSubscrpnPrAgrmt} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrAgrmtFluentHelper getAllBusSolnOrdItmSubscrpnPrAgrmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subscrpnBillgPricingField
     *            Pricing Field ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param subscriptionRateSubElement
     *            Rate Subelement ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param subscrpnBillgPrcElmntSpec
     *            Code of Price Element Specification
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param subscriptionRateElement
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param subscrpnBillgPrcAgreementLine
     *            Condition item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *         BusSolnOrdItmSubscrpnPrAgrmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper getBusSolnOrdItmSubscrpnPrAgrmtByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionRateElement,
        final String subscriptionRateSubElement,
        final String subscrpnBillgPrcElmntSpec,
        final String subscrpnBillgPricingField,
        final String subscrpnBillgPrcAgreementLine );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *            BusSolnOrdItmSubscrpnPrAgrmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *         BusSolnOrdItmSubscrpnPrAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrAgrmtCreateFluentHelper
        createBusSolnOrdItmSubscrpnPrAgrmt( @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *            BusSolnOrdItmSubscrpnPrAgrmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *         BusSolnOrdItmSubscrpnPrAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrAgrmtUpdateFluentHelper
        updateBusSolnOrdItmSubscrpnPrAgrmt( @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *            BusSolnOrdItmSubscrpnPrAgrmt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *         BusSolnOrdItmSubscrpnPrAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmtDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrAgrmtDeleteFluentHelper
        deleteBusSolnOrdItmSubscrpnPrAgrmt( @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *         BusSolnOrdItmSubscrpnPrParam} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrParamFluentHelper getAllBusSolnOrdItmSubscrpnPrParam();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param subscrpnPrcgParameter
     *            Subscription Billing Parameter ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 64
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *         BusSolnOrdItmSubscrpnPrParam} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrParamByKeyFluentHelper getBusSolnOrdItmSubscrpnPrParamByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscrpnPrcgParameter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *            BusSolnOrdItmSubscrpnPrParam} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *         BusSolnOrdItmSubscrpnPrParam} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrParamCreateFluentHelper
        createBusSolnOrdItmSubscrpnPrParam( @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *            BusSolnOrdItmSubscrpnPrParam} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *         BusSolnOrdItmSubscrpnPrParam} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper
        updateBusSolnOrdItmSubscrpnPrParam( @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *            BusSolnOrdItmSubscrpnPrParam} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *         BusSolnOrdItmSubscrpnPrParam} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParamDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmSubscrpnPrParamDeleteFluentHelper
        deleteBusSolnOrdItmSubscrpnPrParam( @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     * BusSolnOrdItmUserStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *         BusSolnOrdItmUserStatus} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmUserStatusFluentHelper getAllBusSolnOrdItmUserStatus();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     * BusSolnOrdItmUserStatus} entity using key fields.
     *
     * @param userStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *         BusSolnOrdItmUserStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmUserStatusByKeyFluentHelper getBusSolnOrdItmUserStatusByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String userStatus );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     * BusSolnOrdItmUserStatus} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *            BusSolnOrdItmUserStatus} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *         BusSolnOrdItmUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmUserStatusCreateFluentHelper
        createBusSolnOrdItmUserStatus( @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     * BusSolnOrdItmUserStatus} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *            BusSolnOrdItmUserStatus} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *         BusSolnOrdItmUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmUserStatusUpdateFluentHelper
        updateBusSolnOrdItmUserStatus( @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     * BusSolnOrdItmUserStatus} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *            BusSolnOrdItmUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *         BusSolnOrdItmUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatusDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdItmUserStatusDeleteFluentHelper
        deleteBusSolnOrdItmUserStatus( @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     * BusSolnOrdSrvcContractItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *         BusSolnOrdSrvcContractItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcContractItemFluentHelper getAllBusSolnOrdSrvcContractItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     * BusSolnOrdSrvcContractItem} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *         BusSolnOrdSrvcContractItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcContractItemByKeyFluentHelper getBusSolnOrdSrvcContractItemByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     * BusSolnOrdSrvcContractItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSrvcContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *            BusSolnOrdSrvcContractItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *         BusSolnOrdSrvcContractItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcContractItemCreateFluentHelper
        createBusSolnOrdSrvcContractItem( @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     * BusSolnOrdSrvcContractItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSrvcContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *            BusSolnOrdSrvcContractItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *         BusSolnOrdSrvcContractItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcContractItemUpdateFluentHelper
        updateBusSolnOrdSrvcContractItem( @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     * BusSolnOrdSrvcContractItem} entity in the S/4HANA system.
     *
     * @param busSolnOrdSrvcContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *            BusSolnOrdSrvcContractItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *         BusSolnOrdSrvcContractItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcContractItemDeleteFluentHelper
        deleteBusSolnOrdSrvcContractItem( @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     * BusSolnOrdSrvcPrtItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *         BusSolnOrdSrvcPrtItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcPrtItemFluentHelper getAllBusSolnOrdSrvcPrtItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     * BusSolnOrdSrvcPrtItem} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *         BusSolnOrdSrvcPrtItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcPrtItemByKeyFluentHelper
        getBusSolnOrdSrvcPrtItemByKey( final String businessSolutionOrder, final String businessSolutionOrderItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     * BusSolnOrdSrvcPrtItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSrvcPrtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *            BusSolnOrdSrvcPrtItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *         BusSolnOrdSrvcPrtItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcPrtItemCreateFluentHelper
        createBusSolnOrdSrvcPrtItem( @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     * BusSolnOrdSrvcPrtItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSrvcPrtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *            BusSolnOrdSrvcPrtItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *         BusSolnOrdSrvcPrtItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcPrtItemUpdateFluentHelper
        updateBusSolnOrdSrvcPrtItem( @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     * BusSolnOrdSrvcPrtItem} entity in the S/4HANA system.
     *
     * @param busSolnOrdSrvcPrtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *            BusSolnOrdSrvcPrtItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *         BusSolnOrdSrvcPrtItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSrvcPrtItemDeleteFluentHelper
        deleteBusSolnOrdSrvcPrtItem( @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     * BusSolnOrdSubscrpnBillgItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *         BusSolnOrdSubscrpnBillgItem} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSubscrpnBillgItemFluentHelper getAllBusSolnOrdSubscrpnBillgItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     * BusSolnOrdSubscrpnBillgItem} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *         BusSolnOrdSubscrpnBillgItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSubscrpnBillgItemByKeyFluentHelper getBusSolnOrdSubscrpnBillgItemByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     * BusSolnOrdSubscrpnBillgItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSubscrpnBillgItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *            BusSolnOrdSubscrpnBillgItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *         BusSolnOrdSubscrpnBillgItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSubscrpnBillgItemCreateFluentHelper
        createBusSolnOrdSubscrpnBillgItem( @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     * BusSolnOrdSubscrpnBillgItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSubscrpnBillgItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *            BusSolnOrdSubscrpnBillgItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *         BusSolnOrdSubscrpnBillgItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSubscrpnBillgItemUpdateFluentHelper
        updateBusSolnOrdSubscrpnBillgItem( @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     * BusSolnOrdSubscrpnBillgItem} entity in the S/4HANA system.
     *
     * @param busSolnOrdSubscrpnBillgItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *            BusSolnOrdSubscrpnBillgItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *         BusSolnOrdSubscrpnBillgItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdSubscrpnBillgItemDeleteFluentHelper
        deleteBusSolnOrdSubscrpnBillgItem( @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *         BusSolnOrdUserStatus} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdUserStatusFluentHelper getAllBusSolnOrdUserStatus();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entity using key fields.
     *
     * @param userStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *         BusSolnOrdUserStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdUserStatusByKeyFluentHelper
        getBusSolnOrdUserStatusByKey( final String businessSolutionOrder, final String userStatus );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *            BusSolnOrdUserStatus} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *         BusSolnOrdUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdUserStatusCreateFluentHelper
        createBusSolnOrdUserStatus( @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *            BusSolnOrdUserStatus} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *         BusSolnOrdUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdUserStatusUpdateFluentHelper
        updateBusSolnOrdUserStatus( @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entity in the S/4HANA system.
     *
     * @param busSolnOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *            BusSolnOrdUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *         BusSolnOrdUserStatus} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatusDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolnOrdUserStatusDeleteFluentHelper
        deleteBusSolnOrdUserStatus( @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     * BusSolutionOrderItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *         BusSolutionOrderItemText} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolutionOrderItemTextFluentHelper getAllBusSolutionOrderItemText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     * BusSolutionOrderItemText} entity using key fields.
     *
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *         BusSolutionOrderItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolutionOrderItemTextByKeyFluentHelper getBusSolutionOrderItemTextByKey(
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String language,
        final String textObjectType );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     * BusSolutionOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param busSolutionOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *            BusSolutionOrderItemText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *         BusSolutionOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolutionOrderItemTextCreateFluentHelper
        createBusSolutionOrderItemText( @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     * BusSolutionOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param busSolutionOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *            BusSolutionOrderItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *         BusSolutionOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolutionOrderItemTextUpdateFluentHelper
        updateBusSolutionOrderItemText( @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     * BusSolutionOrderItemText} entity in the S/4HANA system.
     *
     * @param busSolutionOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *            BusSolutionOrderItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *         BusSolutionOrderItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusSolutionOrderItemTextDeleteFluentHelper
        deleteBusSolutionOrderItemText( @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText );

    /**
     * <p>
     * Creates a fluent helper for the <b>LinkProjectItem</b> OData function import.
     * </p>
     *
     * @param businessSolutionOrder
     *            Object ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessSolutionOrder</b>
     *            </p>
     * @param linkedProject
     *            Project
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedProject</b>
     *            </p>
     * @param businessSolutionOrderItem
     *            Item Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>LinkProjectItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.LinkProjectItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    LinkProjectItemFluentHelper linkProjectItem(
        @Nonnull final String linkedProject,
        @Nonnull final String businessSolutionOrderItem,
        @Nonnull final String businessSolutionOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>UnlinkProjectItem</b> OData function import.
     * </p>
     *
     * @param businessSolutionOrder
     *            Object ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessSolutionOrder</b>
     *            </p>
     * @param linkedProject
     *            Project
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LinkedProject</b>
     *            </p>
     * @param businessSolutionOrderItem
     *            Item Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>UnlinkProjectItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.UnlinkProjectItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UnlinkProjectItemFluentHelper unlinkProjectItem(
        @Nonnull final String linkedProject,
        @Nonnull final String businessSolutionOrderItem,
        @Nonnull final String businessSolutionOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>RejectItem</b> OData function import.
     * </p>
     *
     * @param busSolnOrdItmRjcnReason
     *            Rejection Reason
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusSolnOrdItmRjcnReason</b>
     *            </p>
     * @param businessSolutionOrder
     *            Object ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessSolutionOrder</b>
     *            </p>
     * @param businessSolutionOrderItem
     *            Item Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>RejectItem</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.RejectItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RejectItemFluentHelper rejectItem(
        @Nonnull final String busSolnOrdItmRjcnReason,
        @Nonnull final String businessSolutionOrderItem,
        @Nonnull final String businessSolutionOrder );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReDistribute</b> OData function import.
     * </p>
     *
     * @param businessSolutionOrder
     *            Object ID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessSolutionOrder</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReDistribute</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.ReDistributeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReDistributeFluentHelper reDistribute( @Nonnull final String businessSolutionOrder );

}
