/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.ZonedDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChangesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChangesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.batch.BusinessUserChangeServiceBatch;

/**
 * <p>
 *
 * The service provides a list of change documents for business users. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/1c/042caa1d7142da8de5260bee663864/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_APS_IAM_API_BUSER_CDOC_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_APS_IAM_API_BUSER_CDOC_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Business User Change Document Integration(SAP_COM_0327)</td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Business User</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface BusinessUserChangeService extends BatchService<BusinessUserChangeServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/APS_IAM_API_BUSER_CDOC";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    BusinessUserChangeService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges
     * BusinessUserChanges} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges
     *         BusinessUserChanges} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChangesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessUserChangesFluentHelper getAllBusinessUserChanges();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges
     * BusinessUserChanges} entity using key fields.
     *
     * @param businessUserID
     *            Business User ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param changeCategory
     *            Change Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param attribute
     *            Attribute
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param valueChangedFrom
     *            Value Changed From
     *            <p>
     *            Constraints: Not nullable, Maximum length: 254
     *            </p>
     * @param changedOn
     *            Changed On
     *            <p>
     *            Constraints: Not nullable, Precision: 7
     *            </p>
     * @param valueChangedTo
     *            Value Changed To
     *            <p>
     *            Constraints: Not nullable, Maximum length: 254
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges
     *         BusinessUserChanges} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChangesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessUserChangesByKeyFluentHelper getBusinessUserChangesByKey(
        final String businessUserID,
        final ZonedDateTime changedOn,
        final String changeCategory,
        final String attribute,
        final String valueChangedFrom,
        final String valueChangedTo );

}
