/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.AssignLegalTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CancelContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrmsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrmsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessagesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessagesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistributionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistributionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScalesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScalesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdtyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdtyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistributionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistributionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTransByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTransFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotesByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContractByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContractFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.UnAssignLegalTransactionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.WithdrawFromApprovalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.batch.CentralPurchaseContractServiceBatch;

/**
 * <p>
 *
 * With this inbound service, you can create and maintain central purchase contracts and central purchase contract
 * hierarchies. This service is based on the OData protocol and can be consumed by external systems and other
 * interfaces. This service contains entities, such as header, header distribution, header partner, header notes,
 * subordinate central contract, item, item distribution, item partner, item notes, item condition validity, item
 * condition amount, item condition scales, distribution message, legal transaction, and version history. This service
 * allows purchasers from various parts of the company at different locations to take advantage of the negotiated global
 * agreement with suppliers. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/49/95aa55d3b4428f882d512356aa5307/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CENTRAL_PURCHASECONTRACT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CENTRAL_PURCHASECONTRACT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP S/4HANA Procurement Hub - Central Contract Management Integration(SAP_COM_0243)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2ME'>Central Purchase Contracts(2ME)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4RD'>Direct Material Sourcing(4RD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Central Purchase Contract</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CentralPurchaseContractService extends BatchService<CentralPurchaseContractServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CENTRAL_PURCHASECONTRACT_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CentralPurchaseContractService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     * CentralPurchaseContract} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     *         CentralPurchaseContract} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CentralPurchaseContractFluentHelper getAllCentralPurchaseContract();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     * CentralPurchaseContract} entity using key fields.
     *
     * @param centralPurchaseContract
     *            Active Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     *         CentralPurchaseContract} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CentralPurchaseContractByKeyFluentHelper getCentralPurchaseContractByKey( final String centralPurchaseContract );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     * CentralPurchaseContract} entity and save it to the S/4HANA system.
     *
     * @param centralPurchaseContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     *            CentralPurchaseContract} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContract
     *         CentralPurchaseContract} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CentralPurchaseContractCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CentralPurchaseContractCreateFluentHelper
        createCentralPurchaseContract( @Nonnull final CentralPurchaseContract centralPurchaseContract );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms
     * CePuCoDistrdContrPaytTrms} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms
     *         CePuCoDistrdContrPaytTrms} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrmsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CePuCoDistrdContrPaytTrmsFluentHelper getAllCePuCoDistrdContrPaytTrms();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms
     * CePuCoDistrdContrPaytTrms} entity using key fields.
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param procurementHubSourceSystem
     *            Logical System
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param extContractForPurg
     *            Contract of External System
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrms
     *         CePuCoDistrdContrPaytTrms} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdContrPaytTrmsByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CePuCoDistrdContrPaytTrmsByKeyFluentHelper getCePuCoDistrdContrPaytTrmsByKey(
        final String centralPurchaseContract,
        final String extContractForPurg,
        final String procurementHubSourceSystem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt
     * CePuCoDistrdOutlineAgrmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt
     *         CePuCoDistrdOutlineAgrmt} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CePuCoDistrdOutlineAgrmtFluentHelper getAllCePuCoDistrdOutlineAgrmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt
     * CePuCoDistrdOutlineAgrmt} entity using key fields.
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param procurementHubSourceSystem
     *            Logical System
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param extContractForPurg
     *            Contract of External System
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt
     *         CePuCoDistrdOutlineAgrmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CePuCoDistrdOutlineAgrmtByKeyFluentHelper getCePuCoDistrdOutlineAgrmtByKey(
        final String centralPurchaseContract,
        final String extContractForPurg,
        final String procurementHubSourceSystem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem
     * CntrlPurchaseContractItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem
     *         CntrlPurchaseContractItem} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurchaseContractItemFluentHelper getAllCntrlPurchaseContractItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem
     * CntrlPurchaseContractItem} entity using key fields.
     *
     * @param centralPurchaseContract
     *            Central Purchase Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Central Purchase Contract Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItem
     *         CntrlPurchaseContractItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurchaseContractItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurchaseContractItemByKeyFluentHelper getCntrlPurchaseContractItemByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotes
     * CntrlPurContractHeaderNotes} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotes
     *         CntrlPurContractHeaderNotes} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContractHeaderNotesFluentHelper getAllCntrlPurContractHeaderNotes();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotes
     * CntrlPurContractHeaderNotes} entity using key fields.
     *
     * @param purchasingDocumentNoteLanguage
     *            Language
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param purchasingDocumentNoteObjectID
     *            Application Object ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param purchasingDocumentNoteType
     *            Name of Note Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotes
     *         CntrlPurContractHeaderNotes} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractHeaderNotesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContractHeaderNotesByKeyFluentHelper getCntrlPurContractHeaderNotesByKey(
        final String purchasingDocumentNoteObjectID,
        final String purchasingDocumentNoteType,
        final String purchasingDocumentNoteLanguage );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes
     * CntrlPurContractItemNotes} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes
     *         CntrlPurContractItemNotes} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContractItemNotesFluentHelper getAllCntrlPurContractItemNotes();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes
     * CntrlPurContractItemNotes} entity using key fields.
     *
     * @param purchasingDocumentNoteLanguage
     *            Language
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param purchasingDocumentNoteObjectID
     *            Application Object ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param purchasingDocumentNoteType
     *            Name of Note Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotes
     *         CntrlPurContractItemNotes} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContractItemNotesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContractItemNotesByKeyFluentHelper getCntrlPurContractItemNotesByKey(
        final String purchasingDocumentNoteObjectID,
        final String purchasingDocumentNoteType,
        final String purchasingDocumentNoteLanguage );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages
     * CntrlPurContrDistrMessages} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages
     *         CntrlPurContrDistrMessages} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessagesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrDistrMessagesFluentHelper getAllCntrlPurContrDistrMessages();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages
     * CntrlPurContrDistrMessages} entity using key fields.
     *
     * @param sequenceNumber
     *            Sequence No. of Message during Contract Distribution
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param distrResponseMessageUUID
     *            Generic Data Element for GUID Fields (X16)
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages
     *         CntrlPurContrDistrMessages} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessagesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrDistrMessagesByKeyFluentHelper
        getCntrlPurContrDistrMessagesByKey( final String sequenceNumber, final UUID distrResponseMessageUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmount
     * CntrlPurContrHdrCndnAmount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmount
     *         CntrlPurContrHdrCndnAmount} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHdrCndnAmountFluentHelper getAllCntrlPurContrHdrCndnAmount();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmount
     * CntrlPurContrHdrCndnAmount} entity using key fields.
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmount
     *         CntrlPurContrHdrCndnAmount} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnAmountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHdrCndnAmountByKeyFluentHelper getCntrlPurContrHdrCndnAmountByKey(
        final String centralPurchaseContract,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate,
        final String conditionSequentialNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScales
     * CntrlPurContrHdrCndnScales} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScales
     *         CntrlPurContrHdrCndnScales} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScalesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHdrCndnScalesFluentHelper getAllCntrlPurContrHdrCndnScales();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScales
     * CntrlPurContrHdrCndnScales} entity using key fields.
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param conditionScaleLine
     *            Current number of the line scale
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScales
     *         CntrlPurContrHdrCndnScales} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnScalesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHdrCndnScalesByKeyFluentHelper getCntrlPurContrHdrCndnScalesByKey(
        final String centralPurchaseContract,
        final String conditionRecord,
        final String conditionSequentialNumber,
        final LocalDateTime conditionValidityEndDate,
        final String conditionScaleLine );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdty
     * CntrlPurContrHdrCndnValdty} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdty
     *         CntrlPurContrHdrCndnValdty} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdtyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHdrCndnValdtyFluentHelper getAllCntrlPurContrHdrCndnValdty();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdty
     * CntrlPurContrHdrCndnValdty} entity using key fields.
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdty
     *         CntrlPurContrHdrCndnValdty} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrCndnValdtyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHdrCndnValdtyByKeyFluentHelper getCntrlPurContrHdrCndnValdtyByKey(
        final String centralPurchaseContract,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution
     * CntrlPurContrHdrDistribution} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution
     *         CntrlPurContrHdrDistribution} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistributionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHdrDistributionFluentHelper getAllCntrlPurContrHdrDistribution();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution
     * CntrlPurContrHdrDistribution} entity using key fields.
     *
     * @param distributionKey
     *            Distribution Number of Central Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistribution
     *         CntrlPurContrHdrDistribution} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHdrDistributionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHdrDistributionByKeyFluentHelper
        getCntrlPurContrHdrDistributionByKey( final String centralPurchaseContract, final String distributionKey );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartner
     * CntrlPurContrHeaderPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartner
     *         CntrlPurContrHeaderPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHeaderPartnerFluentHelper getAllCntrlPurContrHeaderPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartner
     * CntrlPurContrHeaderPartner} entity using key fields.
     *
     * @param distributionKey
     *            Distribution Number of Central Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param partnerCounter
     *            Partner counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartner
     *         CntrlPurContrHeaderPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrHeaderPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrHeaderPartnerByKeyFluentHelper getCntrlPurContrHeaderPartnerByKey(
        final String centralPurchaseContract,
        final String distributionKey,
        final String partnerCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner
     * CntrlPurContrItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner
     *         CntrlPurContrItemPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItemPartnerFluentHelper getAllCntrlPurContrItemPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner
     * CntrlPurContrItemPartner} entity using key fields.
     *
     * @param distributionKey
     *            Distribution Number of Central Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param partnerCounter
     *            Partner counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartner
     *         CntrlPurContrItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItemPartnerByKeyFluentHelper getCntrlPurContrItemPartnerByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String distributionKey,
        final String partnerCounter );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty
     * CntrlPurContrItmCmmdtyQty} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty
     *         CntrlPurContrItmCmmdtyQty} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQtyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmCmmdtyQtyFluentHelper getAllCntrlPurContrItmCmmdtyQty();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty
     * CntrlPurContrItmCmmdtyQty} entity using key fields.
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param purgDocCmmdtyQtySqntlNumber
     *            Commodity Qunatity Sequence Number in Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQty
     *         CntrlPurContrItmCmmdtyQty} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCmmdtyQtyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmCmmdtyQtyByKeyFluentHelper getCntrlPurContrItmCmmdtyQtyByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String purgDocCmmdtyQtySqntlNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmount
     * CntrlPurContrItmCndnAmount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmount
     *         CntrlPurContrItmCndnAmount} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmCndnAmountFluentHelper getAllCntrlPurContrItmCndnAmount();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmount
     * CntrlPurContrItmCndnAmount} entity using key fields.
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmount
     *         CntrlPurContrItmCndnAmount} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnAmountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmCndnAmountByKeyFluentHelper getCntrlPurContrItmCndnAmountByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate,
        final String conditionSequentialNumber );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScales
     * CntrlPurContrItmCndnScales} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScales
     *         CntrlPurContrItmCndnScales} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScalesFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmCndnScalesFluentHelper getAllCntrlPurContrItmCndnScales();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScales
     * CntrlPurContrItmCndnScales} entity using key fields.
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param conditionScaleLine
     *            Current number of the line scale
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScales
     *         CntrlPurContrItmCndnScales} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnScalesByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmCndnScalesByKeyFluentHelper getCntrlPurContrItmCndnScalesByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String conditionRecord,
        final String conditionSequentialNumber,
        final LocalDateTime conditionValidityEndDate,
        final String conditionScaleLine );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty
     * CntrlPurContrItmCndnValdty} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty
     *         CntrlPurContrItmCndnValdty} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdtyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmCndnValdtyFluentHelper getAllCntrlPurContrItmCndnValdty();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty
     * CntrlPurContrItmCndnValdty} entity using key fields.
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdty
     *         CntrlPurContrItmCndnValdty} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmCndnValdtyByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmCndnValdtyByKeyFluentHelper getCntrlPurContrItmCndnValdtyByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String conditionRecord,
        final LocalDateTime conditionValidityEndDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistribution
     * CntrlPurContrItmDistribution} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistribution
     *         CntrlPurContrItmDistribution} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistributionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmDistributionFluentHelper getAllCntrlPurContrItmDistribution();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistribution
     * CntrlPurContrItmDistribution} entity using key fields.
     *
     * @param distributionKey
     *            Distribution Number of Central Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistribution
     *         CntrlPurContrItmDistribution} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrItmDistributionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrItmDistributionByKeyFluentHelper getCntrlPurContrItmDistributionByKey(
        final String centralPurchaseContract,
        final String centralPurchaseContractItem,
        final String distributionKey );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTrans
     * CntrlPurContrLegalTrans} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTrans
     *         CntrlPurContrLegalTrans} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTransFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrLegalTransFluentHelper getAllCntrlPurContrLegalTrans();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTrans
     * CntrlPurContrLegalTrans} entity using key fields.
     *
     * @param centralPurchaseContract
     *            Central Purchase Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param legalTransaction
     *            Legal Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTrans
     *         CntrlPurContrLegalTrans} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrLegalTransByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrLegalTransByKeyFluentHelper
        getCntrlPurContrLegalTransByKey( final String centralPurchaseContract, final String legalTransaction );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory
     * CntrlPurContrVersionHistory} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory
     *         CntrlPurContrVersionHistory} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistoryFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrVersionHistoryFluentHelper getAllCntrlPurContrVersionHistory();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory
     * CntrlPurContrVersionHistory} entity using key fields.
     *
     * @param purchasingDocumentVersion
     *            Version number in Purchasing
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param centralPurchaseContract
     *            Active Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistory
     *         CntrlPurContrVersionHistory} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrVersionHistoryByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CntrlPurContrVersionHistoryByKeyFluentHelper getCntrlPurContrVersionHistoryByKey(
        final String centralPurchaseContract,
        final String purchasingDocumentVersion );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract
     * SubordinateCntrlContract} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract
     *         SubordinateCntrlContract} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContractFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubordinateCntrlContractFluentHelper getAllSubordinateCntrlContract();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract
     * SubordinateCntrlContract} entity using key fields.
     *
     * @param purchasingParentDocument
     *            ID of the Parent Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subordCntrlPurContract
     *            Active Purchasing Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param procmtHubCompanyCodeGroupingID
     *            Grouping ID for Company Codes
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContract
     *         SubordinateCntrlContract} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.SubordinateCntrlContractByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SubordinateCntrlContractByKeyFluentHelper getSubordinateCntrlContractByKey(
        final String purchasingParentDocument,
        final String subordCntrlPurContract,
        final String procmtHubCompanyCodeGroupingID );

    /**
     * <p>
     * Creates a fluent helper for the <b>WithdrawFromApproval</b> OData function import.
     * </p>
     *
     * @param centralPurchaseContract
     *            Central Purchase Contract
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CentralPurchaseContract</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>WithdrawFromApproval</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.WithdrawFromApprovalFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WithdrawFromApprovalFluentHelper withdrawFromApproval( @Nonnull final String centralPurchaseContract );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignLegalTransaction</b> OData function import.
     * </p>
     *
     * @param centralPurchaseContract
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CentralPurchaseContract</b>
     *            </p>
     * @param legalTransactionId
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LegalTransactionId</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignLegalTransaction</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.AssignLegalTransactionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignLegalTransactionFluentHelper assignLegalTransaction(
        @Nonnull final String legalTransactionId,
        @Nonnull final String centralPurchaseContract );

    /**
     * <p>
     * Creates a fluent helper for the <b>UnAssignLegalTransaction</b> OData function import.
     * </p>
     *
     * @param legaltransactionlinkdobjuuid
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Legaltransactionlinkdobjuuid</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>UnAssignLegalTransaction</b> OData function import with
     *         the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.UnAssignLegalTransactionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UnAssignLegalTransactionFluentHelper unAssignLegalTransaction( @Nonnull final String legaltransactionlinkdobjuuid );

    /**
     * <p>
     * Creates a fluent helper for the <b>CancelContract</b> OData function import.
     * </p>
     *
     * @param centralPurchaseContract
     *            Central Purchase Contract
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CentralPurchaseContract</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CancelContract</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CancelContractFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CancelContractFluentHelper cancelContract( @Nonnull final String centralPurchaseContract );

}
