/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToMaterialObjectMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToMatlBOMObjectMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAlternativeDateToObjectMgmtRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ShiftValidityStartDateOfChangeMasterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromDocInfoRecdObjMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromMaterialObjMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromMatlBOMObjMgmtRecFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAlternativeDateFromObjMgmtRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.batch.ChangeMasterV2ServiceBatch;

/**
 * <p>
 *
 * You can display and edit change master header data, as well as specify the allowed object types and add alternative
 * dates to your change masters. You can also maintain object management records of the following objects: document info
 * record, material, and bill of material..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/86/ebe598240d486dafbda2b4e523f553/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CHANGEMASTER_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CHANGEMASTER_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Change Master</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ChangeMasterV2Service extends BatchService<ChangeMasterV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CHANGEMASTER;v=0002";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ChangeMasterV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     * ChangeMasterAltDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *         ChangeMasterAltDate} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterAltDateFluentHelper getAllChangeMasterAltDate();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     * ChangeMasterAltDate} entity using key fields.
     *
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param chgNmbrAlternativeDateID
     *            Alternative date external key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *         ChangeMasterAltDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterAltDateByKeyFluentHelper
        getChangeMasterAltDateByKey( final String changeNumber, final String chgNmbrAlternativeDateID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     * ChangeMasterAltDate} entity and save it to the S/4HANA system.
     *
     * @param changeMasterAltDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *            ChangeMasterAltDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *         ChangeMasterAltDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterAltDateCreateFluentHelper
        createChangeMasterAltDate( @Nonnull final ChangeMasterAltDate changeMasterAltDate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     * ChangeMasterAltDate} entity and save it to the S/4HANA system.
     *
     * @param changeMasterAltDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *            ChangeMasterAltDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *         ChangeMasterAltDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterAltDateUpdateFluentHelper
        updateChangeMasterAltDate( @Nonnull final ChangeMasterAltDate changeMasterAltDate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     * ChangeMasterAltDate} entity in the S/4HANA system.
     *
     * @param changeMasterAltDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *            ChangeMasterAltDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDate
     *         ChangeMasterAltDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterAltDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterAltDateDeleteFluentHelper
        deleteChangeMasterAltDate( @Nonnull final ChangeMasterAltDate changeMasterAltDate );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharc
     * ChangeMasterCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharc
     *         ChangeMasterCharc} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterCharcFluentHelper getAllChangeMasterCharc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharc
     * ChangeMasterCharc} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param changeNumber
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharc
     *         ChangeMasterCharc} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterCharcByKeyFluentHelper
        getChangeMasterCharcByKey( final String changeNumber, final String charcInternalID, final String classType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValue
     * ChangeMasterCharcValue} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValue
     *         ChangeMasterCharcValue} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValueFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterCharcValueFluentHelper getAllChangeMasterCharcValue();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValue
     * ChangeMasterCharcValue} entity using key fields.
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param changeNumber
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValue
     *         ChangeMasterCharcValue} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCharcValueByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterCharcValueByKeyFluentHelper getChangeMasterCharcValueByKey(
        final String changeNumber,
        final String classType,
        final String charcInternalID,
        final String charcValuePositionNumber );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClass
     * ChangeMasterClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClass
     *         ChangeMasterClass} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterClassFluentHelper getAllChangeMasterClass();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClass
     * ChangeMasterClass} entity using key fields.
     *
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param changeNumber
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClass
     *         ChangeMasterClass} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterClassByKeyFluentHelper
        getChangeMasterClassByKey( final String changeNumber, final String classInternalID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharc
     * ChangeMasterClassCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharc
     *         ChangeMasterClassCharc} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterClassCharcFluentHelper getAllChangeMasterClassCharc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharc
     * ChangeMasterClassCharc} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param changeNumber
     *            Key of Object to be Classified
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharc
     *         ChangeMasterClassCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterClassCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterClassCharcByKeyFluentHelper getChangeMasterClassCharcByKey(
        final String changeNumber,
        final String classInternalID,
        final String charcInternalID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     * ChangeMasterObjTypeAssgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *         ChangeMasterObjTypeAssgmt} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterObjTypeAssgmtFluentHelper getAllChangeMasterObjTypeAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     * ChangeMasterObjTypeAssgmt} entity using key fields.
     *
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *         ChangeMasterObjTypeAssgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterObjTypeAssgmtByKeyFluentHelper
        getChangeMasterObjTypeAssgmtByKey( final String changeNumber, final String sAPObjectType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     * ChangeMasterObjTypeAssgmt} entity and save it to the S/4HANA system.
     *
     * @param changeMasterObjTypeAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *            ChangeMasterObjTypeAssgmt} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *         ChangeMasterObjTypeAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterObjTypeAssgmtCreateFluentHelper
        createChangeMasterObjTypeAssgmt( @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     * ChangeMasterObjTypeAssgmt} entity and save it to the S/4HANA system.
     *
     * @param changeMasterObjTypeAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *            ChangeMasterObjTypeAssgmt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *         ChangeMasterObjTypeAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterObjTypeAssgmtUpdateFluentHelper
        updateChangeMasterObjTypeAssgmt( @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     * ChangeMasterObjTypeAssgmt} entity in the S/4HANA system.
     *
     * @param changeMasterObjTypeAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *            ChangeMasterObjTypeAssgmt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmt
     *         ChangeMasterObjTypeAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterObjTypeAssgmtDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterObjTypeAssgmtDeleteFluentHelper
        deleteChangeMasterObjTypeAssgmt( @Nonnull final ChangeMasterObjTypeAssgmt changeMasterObjTypeAssgmt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster
     * ChangeMaster} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterFluentHelper getAllChangeMaster();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster
     * ChangeMaster} entity using key fields.
     *
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterByKeyFluentHelper getChangeMasterByKey( final String changeNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     * entity and save it to the S/4HANA system.
     *
     * @param changeMaster
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterCreateFluentHelper createChangeMaster( @Nonnull final ChangeMaster changeMaster );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster
     * ChangeMaster} entity and save it to the S/4HANA system.
     *
     * @param changeMaster
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterUpdateFluentHelper updateChangeMaster( @Nonnull final ChangeMaster changeMaster );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster
     * ChangeMaster} entity in the S/4HANA system.
     *
     * @param changeMaster
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMaster ChangeMaster}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMasterDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMasterDeleteFluentHelper deleteChangeMaster( @Nonnull final ChangeMaster changeMaster );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     * ChangeMstrObjectMgmtRecord} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     *         ChangeMstrObjectMgmtRecord} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObjectMgmtRecordFluentHelper getAllChangeMstrObjectMgmtRecord();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     * ChangeMstrObjectMgmtRecord} entity using key fields.
     *
     * @param sAPObjectTechnicalID
     *            Identification of object to be changed
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     *         ChangeMstrObjectMgmtRecord} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObjectMgmtRecordByKeyFluentHelper getChangeMstrObjectMgmtRecordByKey(
        final String changeNumber,
        final String sAPObjectType,
        final String sAPObjectTechnicalID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     * ChangeMstrObjectMgmtRecord} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObjectMgmtRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     *            ChangeMstrObjectMgmtRecord} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     *         ChangeMstrObjectMgmtRecord} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObjectMgmtRecordUpdateFluentHelper
        updateChangeMstrObjectMgmtRecord( @Nonnull final ChangeMstrObjectMgmtRecord changeMstrObjectMgmtRecord );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     * ChangeMstrObjectMgmtRecord} entity in the S/4HANA system.
     *
     * @param changeMstrObjectMgmtRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     *            ChangeMstrObjectMgmtRecord} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecord
     *         ChangeMstrObjectMgmtRecord} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObjectMgmtRecordDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObjectMgmtRecordDeleteFluentHelper
        deleteChangeMstrObjectMgmtRecord( @Nonnull final ChangeMstrObjectMgmtRecord changeMstrObjectMgmtRecord );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *         ChangeMstrObMgReDocInfoRecd} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReDocInfoRecdFluentHelper getAllChangeMstrObMgReDocInfoRecd();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entity using key fields.
     *
     * @param documentInfoRecord
     *            Document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param documentPart
     *            Document Part
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param documentType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param documentVersion
     *            Document Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *         ChangeMstrObMgReDocInfoRecd} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReDocInfoRecdByKeyFluentHelper getChangeMstrObMgReDocInfoRecdByKey(
        final String changeNumber,
        final String documentType,
        final String documentInfoRecord,
        final String documentPart,
        final String documentVersion );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReDocInfoRecd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *            ChangeMstrObMgReDocInfoRecd} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *         ChangeMstrObMgReDocInfoRecd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReDocInfoRecdCreateFluentHelper
        createChangeMstrObMgReDocInfoRecd( @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReDocInfoRecd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *            ChangeMstrObMgReDocInfoRecd} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *         ChangeMstrObMgReDocInfoRecd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReDocInfoRecdUpdateFluentHelper
        updateChangeMstrObMgReDocInfoRecd( @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     * ChangeMstrObMgReDocInfoRecd} entity in the S/4HANA system.
     *
     * @param changeMstrObMgReDocInfoRecd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *            ChangeMstrObMgReDocInfoRecd} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecd
     *         ChangeMstrObMgReDocInfoRecd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReDocInfoRecdDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReDocInfoRecdDeleteFluentHelper
        deleteChangeMstrObMgReDocInfoRecd( @Nonnull final ChangeMstrObMgReDocInfoRecd changeMstrObMgReDocInfoRecd );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *         ChangeMstrObMgReMaterial} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMaterialFluentHelper getAllChangeMstrObMgReMaterial();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *         ChangeMstrObMgReMaterial} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMaterialByKeyFluentHelper
        getChangeMstrObMgReMaterialByKey( final String changeNumber, final String material );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *            ChangeMstrObMgReMaterial} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *         ChangeMstrObMgReMaterial} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMaterialCreateFluentHelper
        createChangeMstrObMgReMaterial( @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *            ChangeMstrObMgReMaterial} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *         ChangeMstrObMgReMaterial} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMaterialUpdateFluentHelper
        updateChangeMstrObMgReMaterial( @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     * ChangeMstrObMgReMaterial} entity in the S/4HANA system.
     *
     * @param changeMstrObMgReMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *            ChangeMstrObMgReMaterial} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterial
     *         ChangeMstrObMgReMaterial} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMaterialDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMaterialDeleteFluentHelper
        deleteChangeMstrObMgReMaterial( @Nonnull final ChangeMstrObMgReMaterial changeMstrObMgReMaterial );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     * ChangeMstrObMgReMatlBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *         ChangeMstrObMgReMatlBOM} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMatlBOMFluentHelper getAllChangeMstrObMgReMatlBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     * ChangeMstrObMgReMatlBOM} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *         ChangeMstrObMgReMatlBOM} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMatlBOMByKeyFluentHelper getChangeMstrObMgReMatlBOMByKey(
        final String changeNumber,
        final String material,
        final String plant,
        final String billOfMaterialVariantUsage );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     * ChangeMstrObMgReMatlBOM} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReMatlBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *            ChangeMstrObMgReMatlBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *         ChangeMstrObMgReMatlBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMatlBOMCreateFluentHelper
        createChangeMstrObMgReMatlBOM( @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     * ChangeMstrObMgReMatlBOM} entity and save it to the S/4HANA system.
     *
     * @param changeMstrObMgReMatlBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *            ChangeMstrObMgReMatlBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *         ChangeMstrObMgReMatlBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMatlBOMUpdateFluentHelper
        updateChangeMstrObMgReMatlBOM( @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     * ChangeMstrObMgReMatlBOM} entity in the S/4HANA system.
     *
     * @param changeMstrObMgReMatlBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *            ChangeMstrObMgReMatlBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOM
     *         ChangeMstrObMgReMatlBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ChangeMstrObMgReMatlBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeMstrObMgReMatlBOMDeleteFluentHelper
        deleteChangeMstrObMgReMatlBOM( @Nonnull final ChangeMstrObMgReMatlBOM changeMstrObMgReMatlBOM );

    /**
     * <p>
     * Creates a fluent helper for the <b>ShiftValidityStartDateOfChangeMaster</b> OData function import.
     * </p>
     *
     * @param validityStartDate
     *            Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityStartDate</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ShiftValidityStartDateOfChangeMaster</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.ShiftValidityStartDateOfChangeMasterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ShiftValidityStartDateOfChangeMasterFluentHelper shiftValidityStartDateOfChangeMaster(
        @Nonnull final String changeNumber,
        @Nullable final LocalDateTime validityStartDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignAlternativeDateToObjectMgmtRecord</b> OData function import.
     * </p>
     *
     * @param sAPObjectTechnicalID
     *            Object
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectTechnicalID</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @param chgNmbrAlternativeDateID
     *            Alternative date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignAlternativeDateToObjectMgmtRecord</b> OData
     *         function import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAlternativeDateToObjectMgmtRecordFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignAlternativeDateToObjectMgmtRecordFluentHelper assignAlternativeDateToObjectMgmtRecord(
        @Nonnull final String changeNumber,
        @Nonnull final String sAPObjectType,
        @Nonnull final String sAPObjectTechnicalID,
        @Nullable final String chgNmbrAlternativeDateID );

    /**
     * <p>
     * Creates a fluent helper for the <b>UnassignAlternativeDateFromObjMgmtRecord</b> OData function import.
     * </p>
     *
     * @param sAPObjectTechnicalID
     *            Object
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 90
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectTechnicalID</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SAPObjectType</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>UnassignAlternativeDateFromObjMgmtRecord</b> OData
     *         function import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAlternativeDateFromObjMgmtRecordFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UnassignAlternativeDateFromObjMgmtRecordFluentHelper unassignAlternativeDateFromObjMgmtRecord(
        @Nonnull final String changeNumber,
        @Nonnull final String sAPObjectType,
        @Nonnull final String sAPObjectTechnicalID );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignAltDateToDocInfoRecdObjectMgmtRec</b> OData function import.
     * </p>
     *
     * @param documentInfoRecord
     *            Document
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecord</b>
     *            </p>
     * @param documentPart
     *            Document Part
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentPart</b>
     *            </p>
     * @param documentType
     *            Document Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentType</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @param chgNmbrAlternativeDateID
     *            Alternative date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     *            </p>
     * @param documentVersion
     *            Document Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentVersion</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignAltDateToDocInfoRecdObjectMgmtRec</b> OData
     *         function import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignAltDateToDocInfoRecdObjectMgmtRecFluentHelper assignAltDateToDocInfoRecdObjectMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String documentType,
        @Nonnull final String documentInfoRecord,
        @Nonnull final String documentPart,
        @Nonnull final String documentVersion,
        @Nullable final String chgNmbrAlternativeDateID );

    /**
     * <p>
     * Creates a fluent helper for the <b>UnassignAltDateFromDocInfoRecdObjMgmtRec</b> OData function import.
     * </p>
     *
     * @param documentInfoRecord
     *            Document
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentInfoRecord</b>
     *            </p>
     * @param documentPart
     *            Document Part
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentPart</b>
     *            </p>
     * @param documentType
     *            Document Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentType</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @param documentVersion
     *            Document Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentVersion</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>UnassignAltDateFromDocInfoRecdObjMgmtRec</b> OData
     *         function import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromDocInfoRecdObjMgmtRecFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UnassignAltDateFromDocInfoRecdObjMgmtRecFluentHelper unassignAltDateFromDocInfoRecdObjMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String documentType,
        @Nonnull final String documentInfoRecord,
        @Nonnull final String documentPart,
        @Nonnull final String documentVersion );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignAltDateToMaterialObjectMgmtRec</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @param chgNmbrAlternativeDateID
     *            Alternative date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignAltDateToMaterialObjectMgmtRec</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToMaterialObjectMgmtRecFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignAltDateToMaterialObjectMgmtRecFluentHelper assignAltDateToMaterialObjectMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String material,
        @Nullable final String chgNmbrAlternativeDateID );

    /**
     * <p>
     * Creates a fluent helper for the <b>UnassignAltDateFromMaterialObjMgmtRec</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>UnassignAltDateFromMaterialObjMgmtRec</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromMaterialObjMgmtRecFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UnassignAltDateFromMaterialObjMgmtRecFluentHelper
        unassignAltDateFromMaterialObjMgmtRec( @Nonnull final String changeNumber, @Nonnull final String material );

    /**
     * <p>
     * Creates a fluent helper for the <b>AssignAltDateToMatlBOMObjectMgmtRec</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @param chgNmbrAlternativeDateID
     *            Alternative date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChgNmbrAlternativeDateID</b>
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>AssignAltDateToMatlBOMObjectMgmtRec</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.AssignAltDateToMatlBOMObjectMgmtRecFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    AssignAltDateToMatlBOMObjectMgmtRecFluentHelper assignAltDateToMatlBOMObjectMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String billOfMaterialVariantUsage,
        @Nullable final String chgNmbrAlternativeDateID );

    /**
     * <p>
     * Creates a fluent helper for the <b>UnassignAltDateFromMatlBOMObjMgmtRec</b> OData function import.
     * </p>
     *
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param changeNumber
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumber</b>
     *            </p>
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>UnassignAltDateFromMatlBOMObjMgmtRec</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changemasterv2.UnassignAltDateFromMatlBOMObjMgmtRecFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UnassignAltDateFromMatlBOMObjMgmtRecFluentHelper unassignAltDateFromMatlBOMObjMgmtRec(
        @Nonnull final String changeNumber,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String billOfMaterialVariantUsage );

}
