/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.batch.ChangeRecordServiceBatch;

/**
 * <p>
 *
 * You can create, read, and delete change records as header objects. You can also assign (write), read, and delete the
 * following objects belonging to change records: - BOM - BOM item - Characteristic - Class - Document info record -
 * Equipment BOM - Equipment Task List - Functional Location BOM - Functional Location Task List - Maintenance Task List
 * - Master Recipes - Material - Product structure variant - Production Routings - Standard BOM - Variant BOM -
 * Collaboration - Engineering BOM - Manufacturing BOM.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/55/c67e37571043f6824dd3f8aaa48b1b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CHANGE_RECORD?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CHANGE_RECORD</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Change Record Integration(SAP_COM_0339)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NF'>Engineering Change Management with Change Records(1NF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/64E'>Product Change Mgmt with Change Records - Discrete
 * Industries(64E)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/5QC'>Product Change Management with Change
 * Records - Process Industries(5QC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Change Record</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ChangeRecordService extends BatchService<ChangeRecordServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CHANGE_RECORD";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ChangeRecordService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordFluentHelper getAllChangeRecord();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     * entity using key fields.
     *
     * @param changeRecordUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordByKeyFluentHelper getChangeRecordByKey( final UUID changeRecordUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     * entity and save it to the S/4HANA system.
     *
     * @param changeRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordCreateFluentHelper createChangeRecord( @Nonnull final ChangeRecord changeRecord );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord
     * ChangeRecord} entity and save it to the S/4HANA system.
     *
     * @param changeRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecord ChangeRecord}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordUpdateFluentHelper updateChangeRecord( @Nonnull final ChangeRecord changeRecord );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     * ChangeRecordRefCharc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *         ChangeRecordRefCharc} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefCharcFluentHelper getAllChangeRecordRefCharc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     * ChangeRecordRefCharc} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *         ChangeRecordRefCharc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefCharcByKeyFluentHelper getChangeRecordRefCharcByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     * ChangeRecordRefCharc} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *            ChangeRecordRefCharc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *         ChangeRecordRefCharc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefCharcCreateFluentHelper
        createChangeRecordRefCharc( @Nonnull final ChangeRecordRefCharc changeRecordRefCharc );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     * ChangeRecordRefCharc} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *            ChangeRecordRefCharc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *         ChangeRecordRefCharc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefCharcUpdateFluentHelper
        updateChangeRecordRefCharc( @Nonnull final ChangeRecordRefCharc changeRecordRefCharc );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     * ChangeRecordRefCharc} entity in the S/4HANA system.
     *
     * @param changeRecordRefCharc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *            ChangeRecordRefCharc} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharc
     *         ChangeRecordRefCharc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefCharcDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefCharcDeleteFluentHelper
        deleteChangeRecordRefCharc( @Nonnull final ChangeRecordRefCharc changeRecordRefCharc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     * ChangeRecordRefClass} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *         ChangeRecordRefClass} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefClassFluentHelper getAllChangeRecordRefClass();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     * ChangeRecordRefClass} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *         ChangeRecordRefClass} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefClassByKeyFluentHelper getChangeRecordRefClassByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     * ChangeRecordRefClass} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *            ChangeRecordRefClass} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *         ChangeRecordRefClass} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefClassCreateFluentHelper
        createChangeRecordRefClass( @Nonnull final ChangeRecordRefClass changeRecordRefClass );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     * ChangeRecordRefClass} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *            ChangeRecordRefClass} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *         ChangeRecordRefClass} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefClassUpdateFluentHelper
        updateChangeRecordRefClass( @Nonnull final ChangeRecordRefClass changeRecordRefClass );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     * ChangeRecordRefClass} entity in the S/4HANA system.
     *
     * @param changeRecordRefClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *            ChangeRecordRefClass} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClass
     *         ChangeRecordRefClass} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefClassDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefClassDeleteFluentHelper
        deleteChangeRecordRefClass( @Nonnull final ChangeRecordRefClass changeRecordRefClass );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     * ChangeRecordReferenceBit} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *         ChangeRecordReferenceBit} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBitFluentHelper getAllChangeRecordReferenceBit();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     * ChangeRecordReferenceBit} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *         ChangeRecordReferenceBit} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBitByKeyFluentHelper getChangeRecordReferenceBitByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     * ChangeRecordReferenceBit} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceBit
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *            ChangeRecordReferenceBit} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *         ChangeRecordReferenceBit} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBitCreateFluentHelper
        createChangeRecordReferenceBit( @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     * ChangeRecordReferenceBit} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceBit
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *            ChangeRecordReferenceBit} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *         ChangeRecordReferenceBit} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBitUpdateFluentHelper
        updateChangeRecordReferenceBit( @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     * ChangeRecordReferenceBit} entity in the S/4HANA system.
     *
     * @param changeRecordReferenceBit
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *            ChangeRecordReferenceBit} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBit
     *         ChangeRecordReferenceBit} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBitDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBitDeleteFluentHelper
        deleteChangeRecordReferenceBit( @Nonnull final ChangeRecordReferenceBit changeRecordReferenceBit );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     * ChangeRecordReferenceBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *         ChangeRecordReferenceBOM} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBOMFluentHelper getAllChangeRecordReferenceBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     * ChangeRecordReferenceBOM} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *         ChangeRecordReferenceBOM} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBOMByKeyFluentHelper getChangeRecordReferenceBOMByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     * ChangeRecordReferenceBOM} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *            ChangeRecordReferenceBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *         ChangeRecordReferenceBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBOMCreateFluentHelper
        createChangeRecordReferenceBOM( @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     * ChangeRecordReferenceBOM} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *            ChangeRecordReferenceBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *         ChangeRecordReferenceBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBOMUpdateFluentHelper
        updateChangeRecordReferenceBOM( @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     * ChangeRecordReferenceBOM} entity in the S/4HANA system.
     *
     * @param changeRecordReferenceBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *            ChangeRecordReferenceBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOM
     *         ChangeRecordReferenceBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceBOMDeleteFluentHelper
        deleteChangeRecordReferenceBOM( @Nonnull final ChangeRecordReferenceBOM changeRecordReferenceBOM );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *         ChangeRecordReferenceDoc} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceDocFluentHelper getAllChangeRecordReferenceDoc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *         ChangeRecordReferenceDoc} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceDocByKeyFluentHelper getChangeRecordReferenceDocByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *            ChangeRecordReferenceDoc} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *         ChangeRecordReferenceDoc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceDocCreateFluentHelper
        createChangeRecordReferenceDoc( @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *            ChangeRecordReferenceDoc} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *         ChangeRecordReferenceDoc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceDocUpdateFluentHelper
        updateChangeRecordReferenceDoc( @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     * ChangeRecordReferenceDoc} entity in the S/4HANA system.
     *
     * @param changeRecordReferenceDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *            ChangeRecordReferenceDoc} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDoc
     *         ChangeRecordReferenceDoc} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceDocDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceDocDeleteFluentHelper
        deleteChangeRecordReferenceDoc( @Nonnull final ChangeRecordReferenceDoc changeRecordReferenceDoc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     * ChangeRecordReferenceMat} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *         ChangeRecordReferenceMat} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceMatFluentHelper getAllChangeRecordReferenceMat();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     * ChangeRecordReferenceMat} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *         ChangeRecordReferenceMat} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceMatByKeyFluentHelper getChangeRecordReferenceMatByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     * ChangeRecordReferenceMat} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceMat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *            ChangeRecordReferenceMat} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *         ChangeRecordReferenceMat} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceMatCreateFluentHelper
        createChangeRecordReferenceMat( @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     * ChangeRecordReferenceMat} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferenceMat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *            ChangeRecordReferenceMat} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *         ChangeRecordReferenceMat} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceMatUpdateFluentHelper
        updateChangeRecordReferenceMat( @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     * ChangeRecordReferenceMat} entity in the S/4HANA system.
     *
     * @param changeRecordReferenceMat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *            ChangeRecordReferenceMat} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMat
     *         ChangeRecordReferenceMat} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferenceMatDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferenceMatDeleteFluentHelper
        deleteChangeRecordReferenceMat( @Nonnull final ChangeRecordReferenceMat changeRecordReferenceMat );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     * ChangeRecordReferencePSV} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *         ChangeRecordReferencePSV} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferencePSVFluentHelper getAllChangeRecordReferencePSV();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     * ChangeRecordReferencePSV} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *         ChangeRecordReferencePSV} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferencePSVByKeyFluentHelper getChangeRecordReferencePSVByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     * ChangeRecordReferencePSV} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferencePSV
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *            ChangeRecordReferencePSV} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *         ChangeRecordReferencePSV} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferencePSVCreateFluentHelper
        createChangeRecordReferencePSV( @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     * ChangeRecordReferencePSV} entity and save it to the S/4HANA system.
     *
     * @param changeRecordReferencePSV
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *            ChangeRecordReferencePSV} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *         ChangeRecordReferencePSV} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferencePSVUpdateFluentHelper
        updateChangeRecordReferencePSV( @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     * ChangeRecordReferencePSV} entity in the S/4HANA system.
     *
     * @param changeRecordReferencePSV
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *            ChangeRecordReferencePSV} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSV
     *         ChangeRecordReferencePSV} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordReferencePSVDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordReferencePSVDeleteFluentHelper
        deleteChangeRecordReferencePSV( @Nonnull final ChangeRecordReferencePSV changeRecordReferencePSV );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     * ChangeRecordRefMasterRecipe} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *         ChangeRecordRefMasterRecipe} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefMasterRecipeFluentHelper getAllChangeRecordRefMasterRecipe();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     * ChangeRecordRefMasterRecipe} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *         ChangeRecordRefMasterRecipe} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefMasterRecipeByKeyFluentHelper
        getChangeRecordRefMasterRecipeByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     * ChangeRecordRefMasterRecipe} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefMasterRecipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *            ChangeRecordRefMasterRecipe} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *         ChangeRecordRefMasterRecipe} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefMasterRecipeCreateFluentHelper
        createChangeRecordRefMasterRecipe( @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     * ChangeRecordRefMasterRecipe} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefMasterRecipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *            ChangeRecordRefMasterRecipe} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *         ChangeRecordRefMasterRecipe} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefMasterRecipeUpdateFluentHelper
        updateChangeRecordRefMasterRecipe( @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     * ChangeRecordRefMasterRecipe} entity in the S/4HANA system.
     *
     * @param changeRecordRefMasterRecipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *            ChangeRecordRefMasterRecipe} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipe
     *         ChangeRecordRefMasterRecipe} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefMasterRecipeDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefMasterRecipeDeleteFluentHelper
        deleteChangeRecordRefMasterRecipe( @Nonnull final ChangeRecordRefMasterRecipe changeRecordRefMasterRecipe );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     * ChangeRecordRefProdnRouting} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *         ChangeRecordRefProdnRouting} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefProdnRoutingFluentHelper getAllChangeRecordRefProdnRouting();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     * ChangeRecordRefProdnRouting} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *         ChangeRecordRefProdnRouting} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefProdnRoutingByKeyFluentHelper
        getChangeRecordRefProdnRoutingByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     * ChangeRecordRefProdnRouting} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefProdnRouting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *            ChangeRecordRefProdnRouting} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *         ChangeRecordRefProdnRouting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefProdnRoutingCreateFluentHelper
        createChangeRecordRefProdnRouting( @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     * ChangeRecordRefProdnRouting} entity and save it to the S/4HANA system.
     *
     * @param changeRecordRefProdnRouting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *            ChangeRecordRefProdnRouting} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *         ChangeRecordRefProdnRouting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefProdnRoutingUpdateFluentHelper
        updateChangeRecordRefProdnRouting( @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     * ChangeRecordRefProdnRouting} entity in the S/4HANA system.
     *
     * @param changeRecordRefProdnRouting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *            ChangeRecordRefProdnRouting} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRouting
     *         ChangeRecordRefProdnRouting} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChangeRecordRefProdnRoutingDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChangeRecordRefProdnRoutingDeleteFluentHelper
        deleteChangeRecordRefProdnRouting( @Nonnull final ChangeRecordRefProdnRouting changeRecordRefProdnRouting );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     * ChgRecdEquipBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM ChgRecdEquipBOM}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdEquipBOMFluentHelper getAllChgRecdEquipBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     * ChgRecdEquipBOM} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM ChgRecdEquipBOM}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdEquipBOMByKeyFluentHelper getChgRecdEquipBOMByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     * ChgRecdEquipBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdEquipBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     *            ChgRecdEquipBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM ChgRecdEquipBOM}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdEquipBOMCreateFluentHelper createChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     * ChgRecdEquipBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdEquipBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     *            ChgRecdEquipBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM ChgRecdEquipBOM}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdEquipBOMUpdateFluentHelper updateChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     * ChgRecdEquipBOM} entity in the S/4HANA system.
     *
     * @param chgRecdEquipBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM
     *            ChgRecdEquipBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOM ChgRecdEquipBOM}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdEquipBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdEquipBOMDeleteFluentHelper deleteChgRecdEquipBOM( @Nonnull final ChgRecdEquipBOM chgRecdEquipBOM );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     * ChgRecdFuncLocBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *         ChgRecdFuncLocBOM} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocBOMFluentHelper getAllChgRecdFuncLocBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     * ChgRecdFuncLocBOM} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *         ChgRecdFuncLocBOM} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocBOMByKeyFluentHelper getChgRecdFuncLocBOMByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     * ChgRecdFuncLocBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdFuncLocBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *            ChgRecdFuncLocBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *         ChgRecdFuncLocBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocBOMCreateFluentHelper createChgRecdFuncLocBOM( @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     * ChgRecdFuncLocBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdFuncLocBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *            ChgRecdFuncLocBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *         ChgRecdFuncLocBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocBOMUpdateFluentHelper updateChgRecdFuncLocBOM( @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     * ChgRecdFuncLocBOM} entity in the S/4HANA system.
     *
     * @param chgRecdFuncLocBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *            ChgRecdFuncLocBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOM
     *         ChgRecdFuncLocBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocBOMDeleteFluentHelper deleteChgRecdFuncLocBOM( @Nonnull final ChgRecdFuncLocBOM chgRecdFuncLocBOM );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     * ChgRecdFuncLocTskList} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *         ChgRecdFuncLocTskList} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocTskListFluentHelper getAllChgRecdFuncLocTskList();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     * ChgRecdFuncLocTskList} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *         ChgRecdFuncLocTskList} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocTskListByKeyFluentHelper getChgRecdFuncLocTskListByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     * ChgRecdFuncLocTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdFuncLocTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *            ChgRecdFuncLocTskList} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *         ChgRecdFuncLocTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocTskListCreateFluentHelper
        createChgRecdFuncLocTskList( @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     * ChgRecdFuncLocTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdFuncLocTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *            ChgRecdFuncLocTskList} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *         ChgRecdFuncLocTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocTskListUpdateFluentHelper
        updateChgRecdFuncLocTskList( @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     * ChgRecdFuncLocTskList} entity in the S/4HANA system.
     *
     * @param chgRecdFuncLocTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *            ChgRecdFuncLocTskList} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskList
     *         ChgRecdFuncLocTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdFuncLocTskListDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdFuncLocTskListDeleteFluentHelper
        deleteChgRecdFuncLocTskList( @Nonnull final ChgRecdFuncLocTskList chgRecdFuncLocTskList );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     * ChgRecdObjPgMaintTskList} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *         ChgRecdObjPgMaintTskList} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdObjPgMaintTskListFluentHelper getAllChgRecdObjPgMaintTskList();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     * ChgRecdObjPgMaintTskList} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *         ChgRecdObjPgMaintTskList} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdObjPgMaintTskListByKeyFluentHelper getChgRecdObjPgMaintTskListByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     * ChgRecdObjPgMaintTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdObjPgMaintTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *            ChgRecdObjPgMaintTskList} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *         ChgRecdObjPgMaintTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdObjPgMaintTskListCreateFluentHelper
        createChgRecdObjPgMaintTskList( @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     * ChgRecdObjPgMaintTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdObjPgMaintTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *            ChgRecdObjPgMaintTskList} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *         ChgRecdObjPgMaintTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdObjPgMaintTskListUpdateFluentHelper
        updateChgRecdObjPgMaintTskList( @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     * ChgRecdObjPgMaintTskList} entity in the S/4HANA system.
     *
     * @param chgRecdObjPgMaintTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *            ChgRecdObjPgMaintTskList} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskList
     *         ChgRecdObjPgMaintTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdObjPgMaintTskListDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdObjPgMaintTskListDeleteFluentHelper
        deleteChgRecdObjPgMaintTskList( @Nonnull final ChgRecdObjPgMaintTskList chgRecdObjPgMaintTskList );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     * ChgRecdPLMEPDCollabn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     *         ChgRecdPLMEPDCollabn} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdPLMEPDCollabnFluentHelper getAllChgRecdPLMEPDCollabn();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     * ChgRecdPLMEPDCollabn} entity using key fields.
     *
     * @param changeRecordUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param chgRecdPLMEPDCollabnUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     *         ChgRecdPLMEPDCollabn} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdPLMEPDCollabnByKeyFluentHelper
        getChgRecdPLMEPDCollabnByKey( final UUID chgRecdPLMEPDCollabnUUID, final UUID changeRecordUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     * ChgRecdPLMEPDCollabn} entity and save it to the S/4HANA system.
     *
     * @param chgRecdPLMEPDCollabn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     *            ChgRecdPLMEPDCollabn} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     *         ChgRecdPLMEPDCollabn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdPLMEPDCollabnCreateFluentHelper
        createChgRecdPLMEPDCollabn( @Nonnull final ChgRecdPLMEPDCollabn chgRecdPLMEPDCollabn );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     * ChgRecdPLMEPDCollabn} entity in the S/4HANA system.
     *
     * @param chgRecdPLMEPDCollabn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     *            ChgRecdPLMEPDCollabn} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabn
     *         ChgRecdPLMEPDCollabn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdPLMEPDCollabnDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdPLMEPDCollabnDeleteFluentHelper
        deleteChgRecdPLMEPDCollabn( @Nonnull final ChgRecdPLMEPDCollabn chgRecdPLMEPDCollabn );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     * ChgRecdRefEngBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *         ChgRecdRefEngBOM} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEngBOMFluentHelper getAllChgRecdRefEngBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     * ChgRecdRefEngBOM} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *         ChgRecdRefEngBOM} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEngBOMByKeyFluentHelper getChgRecdRefEngBOMByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     * ChgRecdRefEngBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefEngBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *            ChgRecdRefEngBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *         ChgRecdRefEngBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEngBOMCreateFluentHelper createChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     * ChgRecdRefEngBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefEngBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *            ChgRecdRefEngBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *         ChgRecdRefEngBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEngBOMUpdateFluentHelper updateChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     * ChgRecdRefEngBOM} entity in the S/4HANA system.
     *
     * @param chgRecdRefEngBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *            ChgRecdRefEngBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOM
     *         ChgRecdRefEngBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEngBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEngBOMDeleteFluentHelper deleteChgRecdRefEngBOM( @Nonnull final ChgRecdRefEngBOM chgRecdRefEngBOM );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *         ChgRecdRefEquipTskList} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEquipTskListFluentHelper getAllChgRecdRefEquipTskList();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *         ChgRecdRefEquipTskList} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEquipTskListByKeyFluentHelper getChgRecdRefEquipTskListByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefEquipTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *            ChgRecdRefEquipTskList} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *         ChgRecdRefEquipTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEquipTskListCreateFluentHelper
        createChgRecdRefEquipTskList( @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefEquipTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *            ChgRecdRefEquipTskList} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *         ChgRecdRefEquipTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEquipTskListUpdateFluentHelper
        updateChgRecdRefEquipTskList( @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     * ChgRecdRefEquipTskList} entity in the S/4HANA system.
     *
     * @param chgRecdRefEquipTskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *            ChgRecdRefEquipTskList} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskList
     *         ChgRecdRefEquipTskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefEquipTskListDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefEquipTskListDeleteFluentHelper
        deleteChgRecdRefEquipTskList( @Nonnull final ChgRecdRefEquipTskList chgRecdRefEquipTskList );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     * ChgRecdRefMfgBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *         ChgRecdRefMfgBOM} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefMfgBOMFluentHelper getAllChgRecdRefMfgBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     * ChgRecdRefMfgBOM} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *         ChgRecdRefMfgBOM} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefMfgBOMByKeyFluentHelper getChgRecdRefMfgBOMByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     * ChgRecdRefMfgBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefMfgBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *            ChgRecdRefMfgBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *         ChgRecdRefMfgBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefMfgBOMCreateFluentHelper createChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     * ChgRecdRefMfgBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefMfgBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *            ChgRecdRefMfgBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *         ChgRecdRefMfgBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefMfgBOMUpdateFluentHelper updateChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     * ChgRecdRefMfgBOM} entity in the S/4HANA system.
     *
     * @param chgRecdRefMfgBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *            ChgRecdRefMfgBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOM
     *         ChgRecdRefMfgBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefMfgBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefMfgBOMDeleteFluentHelper deleteChgRecdRefMfgBOM( @Nonnull final ChgRecdRefMfgBOM chgRecdRefMfgBOM );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     * ChgRecdRefStdBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *         ChgRecdRefStdBOM} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefStdBOMFluentHelper getAllChgRecdRefStdBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     * ChgRecdRefStdBOM} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *         ChgRecdRefStdBOM} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefStdBOMByKeyFluentHelper getChgRecdRefStdBOMByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     * ChgRecdRefStdBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefStdBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *            ChgRecdRefStdBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *         ChgRecdRefStdBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefStdBOMCreateFluentHelper createChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     * ChgRecdRefStdBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefStdBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *            ChgRecdRefStdBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *         ChgRecdRefStdBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefStdBOMUpdateFluentHelper updateChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     * ChgRecdRefStdBOM} entity in the S/4HANA system.
     *
     * @param chgRecdRefStdBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *            ChgRecdRefStdBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOM
     *         ChgRecdRefStdBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefStdBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefStdBOMDeleteFluentHelper deleteChgRecdRefStdBOM( @Nonnull final ChgRecdRefStdBOM chgRecdRefStdBOM );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     * ChgRecdRefVarBOM} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *         ChgRecdRefVarBOM} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefVarBOMFluentHelper getAllChgRecdRefVarBOM();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     * ChgRecdRefVarBOM} entity using key fields.
     *
     * @param changeRecordReferenceUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *         ChgRecdRefVarBOM} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefVarBOMByKeyFluentHelper getChgRecdRefVarBOMByKey( final UUID changeRecordReferenceUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     * ChgRecdRefVarBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefVarBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *            ChgRecdRefVarBOM} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *         ChgRecdRefVarBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefVarBOMCreateFluentHelper createChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     * ChgRecdRefVarBOM} entity and save it to the S/4HANA system.
     *
     * @param chgRecdRefVarBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *            ChgRecdRefVarBOM} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *         ChgRecdRefVarBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefVarBOMUpdateFluentHelper updateChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     * ChgRecdRefVarBOM} entity in the S/4HANA system.
     *
     * @param chgRecdRefVarBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *            ChgRecdRefVarBOM} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOM
     *         ChgRecdRefVarBOM} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.changerecord.ChgRecdRefVarBOMDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ChgRecdRefVarBOMDeleteFluentHelper deleteChgRecdRefVarBOM( @Nonnull final ChgRecdRefVarBOM chgRecdRefVarBOM );

}
