/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSetByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSetFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetTByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetTFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.batch.CharacteristicAttributeCatalogServiceBatch;

/**
 * <p>
 *
 * The catalog data that is read with this service consists of plant-specific selected sets with their codes that are
 * used to record inspection results for qualitative characteristics, for example, the codes 01 (Smooth) and 02 (Rough)
 * for the characteristic ***Surface***..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/92/9751669aeb40f083215bf16c284c1a/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CHARCATTRIBUTECATALOG_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CHARCATTRIBUTECATALOG_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Inspection Master Data Integration(SAP_COM_0110)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1E1'>Quality Management in Discrete Manufacturing(1E1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1FM'>Quality Management in Procurement(1FM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MP'>Quality Management in Sales(1MP)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MR'>Quality Management in Stock Handling(1MR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2QN'>Nonconformance Management(2QN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Characteristic Attribute Selected Code Set</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CharacteristicAttributeCatalogService extends BatchService<CharacteristicAttributeCatalogServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CHARCATTRIBUTECATALOG_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CharacteristicAttributeCatalogService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet
     * CharcAttribSeldCodeSet} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet
     *         CharcAttribSeldCodeSet} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSetFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharcAttribSeldCodeSetFluentHelper getAllCharcAttribSeldCodeSet();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet
     * CharcAttribSeldCodeSet} entity using key fields.
     *
     * @param selectedCodeSetPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param selectedCodeSet
     *            Selected Set
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSet
     *         CharcAttribSeldCodeSet} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldCodeSetByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharcAttribSeldCodeSetByKeyFluentHelper
        getCharcAttribSeldCodeSetByKey( final String selectedCodeSetPlant, final String selectedCodeSet );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode
     * CharcAttribSeldSetCode} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode
     *         CharcAttribSeldSetCode} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharcAttribSeldSetCodeFluentHelper getAllCharcAttribSeldSetCode();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode
     * CharcAttribSeldSetCode} entity using key fields.
     *
     * @param selectedCodeSetPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param characteristicAttributeCode
     *            Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param selectedCodeSet
     *            Selected Set
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param characteristicAttributeCodeGrp
     *            Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCode
     *         CharcAttribSeldSetCode} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharcAttribSeldSetCodeByKeyFluentHelper getCharcAttribSeldSetCodeByKey(
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String characteristicAttributeCodeGrp,
        final String characteristicAttributeCode );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeT
     * CharcAttribSeldSetCodeT} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeT
     *         CharcAttribSeldSetCodeT} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeTFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharcAttribSeldSetCodeTFluentHelper getAllCharcAttribSeldSetCodeT();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeT
     * CharcAttribSeldSetCodeT} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param selectedCodeSetPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param characteristicAttributeCode
     *            Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param selectedCodeSet
     *            Selected Set
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param characteristicAttributeCodeGrp
     *            Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeT
     *         CharcAttribSeldSetCodeT} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetCodeTByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharcAttribSeldSetCodeTByKeyFluentHelper getCharcAttribSeldSetCodeTByKey(
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String characteristicAttributeCodeGrp,
        final String characteristicAttributeCode,
        final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT
     * CharcAttribSeldSetT} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT
     *         CharcAttribSeldSetT} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetTFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharcAttribSeldSetTFluentHelper getAllCharcAttribSeldSetT();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT
     * CharcAttribSeldSetT} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param selectedCodeSetPlant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param selectedCodeSet
     *            Selected Set
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetT
     *         CharcAttribSeldSetT} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicattributecatalog.CharcAttribSeldSetTByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CharcAttribSeldSetTByKeyFluentHelper getCharcAttribSeldSetTByKey(
        final String selectedCodeSetPlant,
        final String selectedCodeSet,
        final String language );

}
