/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.batch.CharacteristicDataForClassificationServiceBatch;

/**
 * <p>
 * Characteristics describe attributes of the objects to be classified. Using the API you can maintain characteristic
 * header data, descriptions, references, restrictions and values.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/5c/3fb6b558b1482491fd786ec7fa0c26/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CLFN_CHARACTERISTIC_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CLFN_CHARACTERISTIC_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Classification Systems OData/SOAP Integration(SAP_COM_0163), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Classification Characteristic</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CharacteristicDataForClassificationService
    extends
    BatchService<CharacteristicDataForClassificationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CLFN_CHARACTERISTIC_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CharacteristicDataForClassificationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     * ClfnCharacteristicForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *         ClfnCharacteristicForKeyDate} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharacteristicForKeyDateFluentHelper getAllClfnCharacteristicForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     * ClfnCharacteristicForKeyDate} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *         ClfnCharacteristicForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharacteristicForKeyDateByKeyFluentHelper getClfnCharacteristicForKeyDateByKey( final String charcInternalID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     * ClfnCharacteristicForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharacteristicForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *            ClfnCharacteristicForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *         ClfnCharacteristicForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharacteristicForKeyDateCreateFluentHelper
        createClfnCharacteristicForKeyDate( @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     * ClfnCharacteristicForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharacteristicForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *            ClfnCharacteristicForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *         ClfnCharacteristicForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharacteristicForKeyDateUpdateFluentHelper
        updateClfnCharacteristicForKeyDate( @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     * ClfnCharacteristicForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharacteristicForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *            ClfnCharacteristicForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDate
     *         ClfnCharacteristicForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharacteristicForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharacteristicForKeyDateDeleteFluentHelper
        deleteClfnCharacteristicForKeyDate( @Nonnull final ClfnCharacteristicForKeyDate clfnCharacteristicForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     * ClfnCharcDescForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *         ClfnCharcDescForKeyDate} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcDescForKeyDateFluentHelper getAllClfnCharcDescForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     * ClfnCharcDescForKeyDate} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *         ClfnCharcDescForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcDescForKeyDateByKeyFluentHelper
        getClfnCharcDescForKeyDateByKey( final String charcInternalID, final String language );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     * ClfnCharcDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *            ClfnCharcDescForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *         ClfnCharcDescForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcDescForKeyDateCreateFluentHelper
        createClfnCharcDescForKeyDate( @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     * ClfnCharcDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *            ClfnCharcDescForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *         ClfnCharcDescForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcDescForKeyDateUpdateFluentHelper
        updateClfnCharcDescForKeyDate( @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     * ClfnCharcDescForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *            ClfnCharcDescForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDate
     *         ClfnCharcDescForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcDescForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcDescForKeyDateDeleteFluentHelper
        deleteClfnCharcDescForKeyDate( @Nonnull final ClfnCharcDescForKeyDate clfnCharcDescForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     * ClfnCharcRefForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     *         ClfnCharcRefForKeyDate} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcRefForKeyDateFluentHelper getAllClfnCharcRefForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     * ClfnCharcRefForKeyDate} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param charcReferenceTableField
     *            Field Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param charcReferenceTable
     *            Table Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     *         ClfnCharcRefForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcRefForKeyDateByKeyFluentHelper getClfnCharcRefForKeyDateByKey(
        final String charcInternalID,
        final String charcReferenceTable,
        final String charcReferenceTableField );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     * ClfnCharcRefForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcRefForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     *            ClfnCharcRefForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     *         ClfnCharcRefForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcRefForKeyDateCreateFluentHelper
        createClfnCharcRefForKeyDate( @Nonnull final ClfnCharcRefForKeyDate clfnCharcRefForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     * ClfnCharcRefForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcRefForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     *            ClfnCharcRefForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDate
     *         ClfnCharcRefForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRefForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcRefForKeyDateDeleteFluentHelper
        deleteClfnCharcRefForKeyDate( @Nonnull final ClfnCharcRefForKeyDate clfnCharcRefForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     * ClfnCharcRstrcnForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     *         ClfnCharcRstrcnForKeyDate} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcRstrcnForKeyDateFluentHelper getAllClfnCharcRstrcnForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     * ClfnCharcRstrcnForKeyDate} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     *         ClfnCharcRstrcnForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcRstrcnForKeyDateByKeyFluentHelper
        getClfnCharcRstrcnForKeyDateByKey( final String charcInternalID, final String classType );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     * ClfnCharcRstrcnForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcRstrcnForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     *            ClfnCharcRstrcnForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     *         ClfnCharcRstrcnForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcRstrcnForKeyDateCreateFluentHelper
        createClfnCharcRstrcnForKeyDate( @Nonnull final ClfnCharcRstrcnForKeyDate clfnCharcRstrcnForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     * ClfnCharcRstrcnForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcRstrcnForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     *            ClfnCharcRstrcnForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDate
     *         ClfnCharcRstrcnForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcRstrcnForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcRstrcnForKeyDateDeleteFluentHelper
        deleteClfnCharcRstrcnForKeyDate( @Nonnull final ClfnCharcRstrcnForKeyDate clfnCharcRstrcnForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     * ClfnCharcValueDescForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *         ClfnCharcValueDescForKeyDate} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueDescForKeyDateFluentHelper getAllClfnCharcValueDescForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     * ClfnCharcValueDescForKeyDate} entity using key fields.
     *
     * @param charcValuePositionNumber
     *            Int counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *         ClfnCharcValueDescForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueDescForKeyDateByKeyFluentHelper getClfnCharcValueDescForKeyDateByKey(
        final String charcInternalID,
        final String charcValuePositionNumber,
        final String language );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     * ClfnCharcValueDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcValueDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *            ClfnCharcValueDescForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *         ClfnCharcValueDescForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueDescForKeyDateCreateFluentHelper
        createClfnCharcValueDescForKeyDate( @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     * ClfnCharcValueDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcValueDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *            ClfnCharcValueDescForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *         ClfnCharcValueDescForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueDescForKeyDateUpdateFluentHelper
        updateClfnCharcValueDescForKeyDate( @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     * ClfnCharcValueDescForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcValueDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *            ClfnCharcValueDescForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDate
     *         ClfnCharcValueDescForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueDescForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueDescForKeyDateDeleteFluentHelper
        deleteClfnCharcValueDescForKeyDate( @Nonnull final ClfnCharcValueDescForKeyDate clfnCharcValueDescForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     * ClfnCharcValueForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *         ClfnCharcValueForKeyDate} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueForKeyDateFluentHelper getAllClfnCharcValueForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     * ClfnCharcValueForKeyDate} entity using key fields.
     *
     * @param charcValuePositionNumber
     *            Int counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *         ClfnCharcValueForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueForKeyDateByKeyFluentHelper
        getClfnCharcValueForKeyDateByKey( final String charcInternalID, final String charcValuePositionNumber );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     * ClfnCharcValueForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcValueForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *            ClfnCharcValueForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *         ClfnCharcValueForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueForKeyDateCreateFluentHelper
        createClfnCharcValueForKeyDate( @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     * ClfnCharcValueForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnCharcValueForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *            ClfnCharcValueForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *         ClfnCharcValueForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueForKeyDateUpdateFluentHelper
        updateClfnCharcValueForKeyDate( @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     * ClfnCharcValueForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnCharcValueForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *            ClfnCharcValueForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDate
     *         ClfnCharcValueForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.characteristicdataforclassification.ClfnCharcValueForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnCharcValueForKeyDateDeleteFluentHelper
        deleteClfnCharcValueForKeyDate( @Nonnull final ClfnCharcValueForKeyDate clfnCharcValueForKeyDate );

}
