/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.batch.ClassDataForClassificationServiceBatch;

/**
 * <p>
 * Classes allow you to group objects together according to criteria that you define. Using the API you can maintain
 * class header data, descriptions, keywords, texts and characteristic assignments.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/b4/14e320706a4071adec31121ef1f3c1/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CLFN_CLASS_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CLFN_CLASS_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Classification Systems OData/SOAP Integration(SAP_COM_0163), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Classification Class</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ClassDataForClassificationService extends BatchService<ClassDataForClassificationServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CLFN_CLASS_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ClassDataForClassificationService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *         ClfnClassCharcForKeyDate} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassCharcForKeyDateFluentHelper getAllClfnClassCharcForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity using key fields.
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *         ClfnClassCharcForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassCharcForKeyDateByKeyFluentHelper
        getClfnClassCharcForKeyDateByKey( final String classInternalID, final String charcInternalID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassCharcForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *            ClfnClassCharcForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *         ClfnClassCharcForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassCharcForKeyDateCreateFluentHelper
        createClfnClassCharcForKeyDate( @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassCharcForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *            ClfnClassCharcForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *         ClfnClassCharcForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassCharcForKeyDateUpdateFluentHelper
        updateClfnClassCharcForKeyDate( @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnClassCharcForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *            ClfnClassCharcForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *         ClfnClassCharcForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassCharcForKeyDateDeleteFluentHelper
        deleteClfnClassCharcForKeyDate( @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     * ClfnClassDescForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     *         ClfnClassDescForKeyDate} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassDescForKeyDateFluentHelper getAllClfnClassDescForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     * ClfnClassDescForKeyDate} entity using key fields.
     *
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     *         ClfnClassDescForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassDescForKeyDateByKeyFluentHelper
        getClfnClassDescForKeyDateByKey( final String classInternalID, final String language );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     * ClfnClassDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     *            ClfnClassDescForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     *         ClfnClassDescForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassDescForKeyDateCreateFluentHelper
        createClfnClassDescForKeyDate( @Nonnull final ClfnClassDescForKeyDate clfnClassDescForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     * ClfnClassDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     *            ClfnClassDescForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     *         ClfnClassDescForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassDescForKeyDateUpdateFluentHelper
        updateClfnClassDescForKeyDate( @Nonnull final ClfnClassDescForKeyDate clfnClassDescForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *         ClfnClassForKeyDate} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassForKeyDateFluentHelper getAllClfnClassForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entity using key fields.
     *
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *         ClfnClassForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassForKeyDateByKeyFluentHelper getClfnClassForKeyDateByKey( final String classInternalID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *            ClfnClassForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *         ClfnClassForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassForKeyDateCreateFluentHelper
        createClfnClassForKeyDate( @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *            ClfnClassForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *         ClfnClassForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassForKeyDateUpdateFluentHelper
        updateClfnClassForKeyDate( @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnClassForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *            ClfnClassForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *         ClfnClassForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassForKeyDateDeleteFluentHelper
        deleteClfnClassForKeyDate( @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *         ClfnClassKeywordForKeyDate} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassKeywordForKeyDateFluentHelper getAllClfnClassKeywordForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity using key fields.
     *
     * @param classKeywordPositionNumber
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *         ClfnClassKeywordForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassKeywordForKeyDateByKeyFluentHelper getClfnClassKeywordForKeyDateByKey(
        final String classInternalID,
        final String language,
        final String classKeywordPositionNumber );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassKeywordForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *            ClfnClassKeywordForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *         ClfnClassKeywordForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassKeywordForKeyDateCreateFluentHelper
        createClfnClassKeywordForKeyDate( @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassKeywordForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *            ClfnClassKeywordForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *         ClfnClassKeywordForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassKeywordForKeyDateUpdateFluentHelper
        updateClfnClassKeywordForKeyDate( @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnClassKeywordForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *            ClfnClassKeywordForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *         ClfnClassKeywordForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassKeywordForKeyDateDeleteFluentHelper
        deleteClfnClassKeywordForKeyDate( @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     * ClfnClassTextForKeyDate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *         ClfnClassTextForKeyDate} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassTextForKeyDateFluentHelper getAllClfnClassTextForKeyDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     * ClfnClassTextForKeyDate} entity using key fields.
     *
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *         ClfnClassTextForKeyDate} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassTextForKeyDateByKeyFluentHelper
        getClfnClassTextForKeyDateByKey( final String classInternalID, final String language, final String longTextID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     * ClfnClassTextForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassTextForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *            ClfnClassTextForKeyDate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *         ClfnClassTextForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassTextForKeyDateCreateFluentHelper
        createClfnClassTextForKeyDate( @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     * ClfnClassTextForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassTextForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *            ClfnClassTextForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *         ClfnClassTextForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassTextForKeyDateUpdateFluentHelper
        updateClfnClassTextForKeyDate( @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     * ClfnClassTextForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnClassTextForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *            ClfnClassTextForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *         ClfnClassTextForKeyDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ClfnClassTextForKeyDateDeleteFluentHelper
        deleteClfnClassTextForKeyDate( @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate );

}
