/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRoleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRoleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingDataByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingDataFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunctionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunctionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkpackageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkpackageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.batch.CommercialProjectDetailServiceBatch;

/**
 * <p>
 *
 * The service provides header and detail-level information about customer and internal projects. It can be used as a
 * data provider to integrate third-party tools or applications for business processes such as resource management,
 * staffing, or time recording..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2b/23f2577840bd12e10000000a4450e5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/_CPD_SC_EXTERNAL_SERVICES_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>_CPD_SC_EXTERNAL_SERVICES_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Commercial Project Integration(SAP_COM_0054)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1A8'>Internal Project Management - Project-Based
 * Services(1A8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J11'>Customer Project Management - Project-Based
 * Services(J11)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Commercial Project</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CommercialProjectDetailService extends BatchService<CommercialProjectDetailServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/CPD/SC_EXTERNAL_SERVICES_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CommercialProjectDetailService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Project
     * Project} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Project Project}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectFluentHelper getAllProject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Project
     * Project} entity using key fields.
     *
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Project Project}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectByKeyFluentHelper getProjectByKey( final String projectID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage
     * Workpackage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage
     *         Workpackage} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkpackageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkpackageFluentHelper getAllWorkpackage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage
     * Workpackage} entity using key fields.
     *
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.Workpackage
     *         Workpackage} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkpackageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkpackageByKeyFluentHelper getWorkpackageByKey( final String workPackageID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData
     * PlanData} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData PlanData}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanDataFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlanDataFluentHelper getAllPlanData();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData
     * PlanData} entity using key fields.
     *
     * @param workitemId
     *            Work Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param delvryServOrg
     *            Delivery Org. ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param resourceId
     *            Resource ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param resType
     *            Resource Type ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param employee
     *            Employee ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param version
     *            Version ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 28
     *            </p>
     * @param confirmed
     *            Resource is Confirmed
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData PlanData}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanDataByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlanDataByKeyFluentHelper getPlanDataByKey(
        final String projectID,
        final String resType,
        final String workPackageID,
        final String resourceId,
        final String version,
        final String employee,
        final String confirmed,
        final String workitemId,
        final String delvryServOrg );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem
     * WorkItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem WorkItem}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkItemFluentHelper getAllWorkItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem
     * WorkItem} entity using key fields.
     *
     * @param workpackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param workitem
     *            Work Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItem WorkItem}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkItemByKeyFluentHelper getWorkItemByKey( final String workitem, final String workpackageID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole
     * ProjectRole} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole
     *         ProjectRole} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRoleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectRoleFluentHelper getAllProjectRole();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole
     * ProjectRole} entity using key fields.
     *
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param projectRoleID
     *            Project Role ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 15
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRole
     *         ProjectRole} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.ProjectRoleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectRoleByKeyFluentHelper getProjectRoleByKey( final String projectID, final String projectRoleID );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData
     * StaffingData} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData
     *         StaffingData} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingDataFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StaffingDataFluentHelper getAllStaffingData();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData
     * StaffingData} entity using key fields.
     *
     * @param workitemId
     *            Work Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param resourceId
     *            Resource ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param resType
     *            ResourceTypeID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingData
     *         StaffingData} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.StaffingDataByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    StaffingDataByKeyFluentHelper getStaffingDataByKey(
        final String projectID,
        final String workPackageID,
        final String resType,
        final String resourceId,
        final String workitemId );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunction
     * WorkPackageFunction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunction
     *         WorkPackageFunction} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunctionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageFunctionFluentHelper getAllWorkPackageFunction();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunction
     * WorkPackageFunction} entity using key fields.
     *
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param workPackageFunctionId
     *            Work Package Function ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunction
     *         WorkPackageFunction} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunctionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageFunctionByKeyFluentHelper getWorkPackageFunctionByKey(
        final String projectID,
        final String workPackageID,
        final String workPackageFunctionId );

}
