/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkillByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkillFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.UpdateCustProjSlsOrdItemMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.batch.CommercialProjectServiceBatch;

/**
 * <p>
 *
 * The service enables you to do the following: - Create and manage customer and internal projects - Manage work
 * packages and work items - Plan resources and expenses in work packages - Staff resources to work packages - Create,
 * read, and update sales orders for your customer projects.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8a/6dc4ab5f854c92863a2f8a248b061b/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/_CPD_SC_PROJ_ENGMT_CREATE_UPD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>_CPD_SC_PROJ_ENGMT_CREATE_UPD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Commercial Project Integration(SAP_COM_0054)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1A8'>Internal Project Management - Project-Based
 * Services(1A8)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/J11'>Customer Project Management - Project-Based
 * Services(J11)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Commercial Project</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CommercialProjectService extends BatchService<CommercialProjectServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/CPD/SC_PROJ_ENGMT_CREATE_UPD_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CommercialProjectService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     * CustProjSlsOrd} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     *         CustProjSlsOrd} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdFluentHelper getAllCustProjSlsOrd();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     * CustProjSlsOrd} entity using key fields.
     *
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     *         CustProjSlsOrd} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdByKeyFluentHelper getCustProjSlsOrdByKey( final String customerProject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     * CustProjSlsOrd} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     *            CustProjSlsOrd} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     *         CustProjSlsOrd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdCreateFluentHelper createCustProjSlsOrd( @Nonnull final CustProjSlsOrd custProjSlsOrd );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     * CustProjSlsOrd} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     *            CustProjSlsOrd} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     *         CustProjSlsOrd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdUpdateFluentHelper updateCustProjSlsOrd( @Nonnull final CustProjSlsOrd custProjSlsOrd );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     * CustProjSlsOrdItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *         CustProjSlsOrdItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemFluentHelper getAllCustProjSlsOrdItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     * CustProjSlsOrdItem} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *         CustProjSlsOrdItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemByKeyFluentHelper
        getCustProjSlsOrdItemByKey( final String customerProject, final String salesOrderItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     * CustProjSlsOrdItem} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *            CustProjSlsOrdItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *         CustProjSlsOrdItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemCreateFluentHelper
        createCustProjSlsOrdItem( @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     * CustProjSlsOrdItem} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *            CustProjSlsOrdItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *         CustProjSlsOrdItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemUpdateFluentHelper
        updateCustProjSlsOrdItem( @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     * CustProjSlsOrdItem} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *            CustProjSlsOrdItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *         CustProjSlsOrdItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemDeleteFluentHelper
        deleteCustProjSlsOrdItem( @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     * CustProjSlsOrdItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     *         CustProjSlsOrdItemPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemPartnerFluentHelper getAllCustProjSlsOrdItemPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     * CustProjSlsOrdItemPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     *         CustProjSlsOrdItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemPartnerByKeyFluentHelper getCustProjSlsOrdItemPartnerByKey(
        final String customerProject,
        final String partnerFunction,
        final String salesOrderItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     * CustProjSlsOrdItemPartner} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     *            CustProjSlsOrdItemPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     *         CustProjSlsOrdItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemPartnerCreateFluentHelper
        createCustProjSlsOrdItemPartner( @Nonnull final CustProjSlsOrdItemPartner custProjSlsOrdItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     * CustProjSlsOrdItemPartner} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     *            CustProjSlsOrdItemPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     *         CustProjSlsOrdItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemPartnerUpdateFluentHelper
        updateCustProjSlsOrdItemPartner( @Nonnull final CustProjSlsOrdItemPartner custProjSlsOrdItemPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     * CustProjSlsOrdItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *         CustProjSlsOrdItemText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemTextFluentHelper getAllCustProjSlsOrdItemText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     * CustProjSlsOrdItemText} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *         CustProjSlsOrdItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemTextByKeyFluentHelper getCustProjSlsOrdItemTextByKey(
        final String customerProject,
        final String salesOrderItem,
        final String language,
        final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     * CustProjSlsOrdItemText} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *            CustProjSlsOrdItemText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *         CustProjSlsOrdItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemTextCreateFluentHelper
        createCustProjSlsOrdItemText( @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     * CustProjSlsOrdItemText} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *            CustProjSlsOrdItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *         CustProjSlsOrdItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemTextUpdateFluentHelper
        updateCustProjSlsOrdItemText( @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     * CustProjSlsOrdItemText} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *            CustProjSlsOrdItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *         CustProjSlsOrdItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemTextDeleteFluentHelper
        deleteCustProjSlsOrdItemText( @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     * CustProjSlsOrdItemWorkPckg} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     *         CustProjSlsOrdItemWorkPckg} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemWorkPckgFluentHelper getAllCustProjSlsOrdItemWorkPckg();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     * CustProjSlsOrdItemWorkPckg} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param workPackage
     *            Plan Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     *         CustProjSlsOrdItemWorkPckg} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemWorkPckgByKeyFluentHelper getCustProjSlsOrdItemWorkPckgByKey(
        final String customerProject,
        final String salesOrderItem,
        final String workPackage );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     * CustProjSlsOrdItemWorkPckg} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemWorkPckg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     *            CustProjSlsOrdItemWorkPckg} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     *         CustProjSlsOrdItemWorkPckg} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemWorkPckgCreateFluentHelper
        createCustProjSlsOrdItemWorkPckg( @Nonnull final CustProjSlsOrdItemWorkPckg custProjSlsOrdItemWorkPckg );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     * CustProjSlsOrdItemWorkPckg} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdItemWorkPckg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     *            CustProjSlsOrdItemWorkPckg} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     *         CustProjSlsOrdItemWorkPckg} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckgDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItemWorkPckgDeleteFluentHelper
        deleteCustProjSlsOrdItemWorkPckg( @Nonnull final CustProjSlsOrdItemWorkPckg custProjSlsOrdItemWorkPckg );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     * CustProjSlsOrdItmBillgPlnItm} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *         CustProjSlsOrdItmBillgPlnItm} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItmBillgPlnItmFluentHelper getAllCustProjSlsOrdItmBillgPlnItm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     * CustProjSlsOrdItmBillgPlnItm} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param billingPlanItem
     *            Item for billing plan/invoice plan/payment cards
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *         CustProjSlsOrdItmBillgPlnItm} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItmBillgPlnItmByKeyFluentHelper getCustProjSlsOrdItmBillgPlnItmByKey(
        final String customerProject,
        final String salesOrderItem,
        final String billingPlanItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     * CustProjSlsOrdItmBillgPlnItm} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItmBillgPlnItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *            CustProjSlsOrdItmBillgPlnItm} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *         CustProjSlsOrdItmBillgPlnItm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItmBillgPlnItmCreateFluentHelper
        createCustProjSlsOrdItmBillgPlnItm( @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     * CustProjSlsOrdItmBillgPlnItm} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItmBillgPlnItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *            CustProjSlsOrdItmBillgPlnItm} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *         CustProjSlsOrdItmBillgPlnItm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItmBillgPlnItmUpdateFluentHelper
        updateCustProjSlsOrdItmBillgPlnItm( @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     * CustProjSlsOrdItmBillgPlnItm} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdItmBillgPlnItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *            CustProjSlsOrdItmBillgPlnItm} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *         CustProjSlsOrdItmBillgPlnItm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItmDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItmBillgPlnItmDeleteFluentHelper
        deleteCustProjSlsOrdItmBillgPlnItm( @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElement
     * CustProjSlsOrdItmPrcgElement} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElement
     *         CustProjSlsOrdItmPrcgElement} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElementFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItmPrcgElementFluentHelper getAllCustProjSlsOrdItmPrcgElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElement
     * CustProjSlsOrdItmPrcgElement} entity using key fields.
     *
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElement
     *         CustProjSlsOrdItmPrcgElement} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElementByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdItmPrcgElementByKeyFluentHelper getCustProjSlsOrdItmPrcgElementByKey(
        final String customerProject,
        final String salesOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     * CustProjSlsOrdPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     *         CustProjSlsOrdPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdPartnerFluentHelper getAllCustProjSlsOrdPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     * CustProjSlsOrdPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     *         CustProjSlsOrdPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdPartnerByKeyFluentHelper
        getCustProjSlsOrdPartnerByKey( final String customerProject, final String partnerFunction );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     * CustProjSlsOrdPartner} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     *            CustProjSlsOrdPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     *         CustProjSlsOrdPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdPartnerCreateFluentHelper
        createCustProjSlsOrdPartner( @Nonnull final CustProjSlsOrdPartner custProjSlsOrdPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     * CustProjSlsOrdPartner} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     *            CustProjSlsOrdPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     *         CustProjSlsOrdPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdPartnerUpdateFluentHelper
        updateCustProjSlsOrdPartner( @Nonnull final CustProjSlsOrdPartner custProjSlsOrdPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *         CustProjSlsOrdText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdTextFluentHelper getAllCustProjSlsOrdText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity using key fields.
     *
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *         CustProjSlsOrdText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdTextByKeyFluentHelper
        getCustProjSlsOrdTextByKey( final String customerProject, final String language, final String longTextID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *            CustProjSlsOrdText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *         CustProjSlsOrdText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdTextCreateFluentHelper
        createCustProjSlsOrdText( @Nonnull final CustProjSlsOrdText custProjSlsOrdText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *            CustProjSlsOrdText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *         CustProjSlsOrdText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdTextUpdateFluentHelper
        updateCustProjSlsOrdText( @Nonnull final CustProjSlsOrdText custProjSlsOrdText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *            CustProjSlsOrdText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *         CustProjSlsOrdText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustProjSlsOrdTextDeleteFluentHelper
        deleteCustProjSlsOrdText( @Nonnull final CustProjSlsOrdText custProjSlsOrdText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     * EngmntProjRsceDmnd} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *         EngmntProjRsceDmnd} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndFluentHelper getAllEngmntProjRsceDmnd();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     * EngmntProjRsceDmnd} entity using key fields.
     *
     * @param resourceDemand
     *            Resource Demand ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param workPackage
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param version
     *            Plan Version ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 28
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *         EngmntProjRsceDmnd} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndByKeyFluentHelper
        getEngmntProjRsceDmndByKey( final String workPackage, final String resourceDemand, final String version );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     * EngmntProjRsceDmnd} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceDmnd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *            EngmntProjRsceDmnd} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *         EngmntProjRsceDmnd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndCreateFluentHelper
        createEngmntProjRsceDmnd( @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     * EngmntProjRsceDmnd} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceDmnd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *            EngmntProjRsceDmnd} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *         EngmntProjRsceDmnd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndUpdateFluentHelper
        updateEngmntProjRsceDmnd( @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     * EngmntProjRsceDmnd} entity in the S/4HANA system.
     *
     * @param engmntProjRsceDmnd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *            EngmntProjRsceDmnd} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *         EngmntProjRsceDmnd} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndDeleteFluentHelper
        deleteEngmntProjRsceDmnd( @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *         EngmntProjRsceDmndDistr} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndDistrFluentHelper getAllEngmntProjRsceDmndDistr();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entity using key fields.
     *
     * @param calendarMonth
     *            Calendar Month
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param resourceDemand
     *            Resource Demand ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param calendarYear
     *            Calendar Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workPackage
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param version
     *            Plan Version ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 28
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *         EngmntProjRsceDmndDistr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndDistrByKeyFluentHelper getEngmntProjRsceDmndDistrByKey(
        final String workPackage,
        final String resourceDemand,
        final String version,
        final String calendarMonth,
        final String calendarYear );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceDmndDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *            EngmntProjRsceDmndDistr} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *         EngmntProjRsceDmndDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndDistrCreateFluentHelper
        createEngmntProjRsceDmndDistr( @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceDmndDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *            EngmntProjRsceDmndDistr} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *         EngmntProjRsceDmndDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndDistrUpdateFluentHelper
        updateEngmntProjRsceDmndDistr( @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entity in the S/4HANA system.
     *
     * @param engmntProjRsceDmndDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *            EngmntProjRsceDmndDistr} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *         EngmntProjRsceDmndDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistrDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndDistrDeleteFluentHelper
        deleteEngmntProjRsceDmndDistr( @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill
     * EngmntProjRsceDmndSkill} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill
     *         EngmntProjRsceDmndSkill} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkillFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndSkillFluentHelper getAllEngmntProjRsceDmndSkill();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill
     * EngmntProjRsceDmndSkill} entity using key fields.
     *
     * @param resourceDemand
     *            Resource Demand ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param workPackage
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param version
     *            Plan Version ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 28
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill
     *         EngmntProjRsceDmndSkill} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkillByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceDmndSkillByKeyFluentHelper
        getEngmntProjRsceDmndSkillByKey( final String workPackage, final String resourceDemand, final String version );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     * EngmntProjRsceSup} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *         EngmntProjRsceSup} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupFluentHelper getAllEngmntProjRsceSup();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     * EngmntProjRsceSup} entity using key fields.
     *
     * @param resourceDemand
     *            Resource Demand ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param workPackage
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param resourceSupply
     *            Resource Supply ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param version
     *            Plan Version ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 28
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *         EngmntProjRsceSup} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupByKeyFluentHelper getEngmntProjRsceSupByKey(
        final String workPackage,
        final String resourceDemand,
        final String resourceSupply,
        final String version );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     * EngmntProjRsceSup} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceSup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *            EngmntProjRsceSup} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *         EngmntProjRsceSup} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupCreateFluentHelper createEngmntProjRsceSup( @Nonnull final EngmntProjRsceSup engmntProjRsceSup );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     * EngmntProjRsceSup} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceSup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *            EngmntProjRsceSup} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *         EngmntProjRsceSup} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupUpdateFluentHelper updateEngmntProjRsceSup( @Nonnull final EngmntProjRsceSup engmntProjRsceSup );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup EngmntProjRsceSup}
     * entity in the S/4HANA system.
     *
     * @param engmntProjRsceSup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *            EngmntProjRsceSup} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *         EngmntProjRsceSup} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupDeleteFluentHelper deleteEngmntProjRsceSup( @Nonnull final EngmntProjRsceSup engmntProjRsceSup );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     * EngmntProjRsceSupDistr} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *         EngmntProjRsceSupDistr} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupDistrFluentHelper getAllEngmntProjRsceSupDistr();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     * EngmntProjRsceSupDistr} entity using key fields.
     *
     * @param calendarMonth
     *            Calendar Month
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param resourceDemand
     *            Resource Demand ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param calendarYear
     *            Calendar Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workPackage
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param resourceSupply
     *            Resource Supply ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param version
     *            Plan Version ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 28
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *         EngmntProjRsceSupDistr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupDistrByKeyFluentHelper getEngmntProjRsceSupDistrByKey(
        final String workPackage,
        final String resourceDemand,
        final String resourceSupply,
        final String version,
        final String calendarMonth,
        final String calendarYear );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     * EngmntProjRsceSupDistr} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceSupDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *            EngmntProjRsceSupDistr} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *         EngmntProjRsceSupDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupDistrCreateFluentHelper
        createEngmntProjRsceSupDistr( @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     * EngmntProjRsceSupDistr} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceSupDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *            EngmntProjRsceSupDistr} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *         EngmntProjRsceSupDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupDistrUpdateFluentHelper
        updateEngmntProjRsceSupDistr( @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     * EngmntProjRsceSupDistr} entity in the S/4HANA system.
     *
     * @param engmntProjRsceSupDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *            EngmntProjRsceSupDistr} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *         EngmntProjRsceSupDistr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistrDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    EngmntProjRsceSupDistrDeleteFluentHelper
        deleteEngmntProjRsceSupDistr( @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     * WorkPackageFunction} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     *         WorkPackageFunction} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageFunctionFluentHelper getAllWorkPackageFunction();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     * WorkPackageFunction} entity using key fields.
     *
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param workPackageName
     *            Work Package Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param workPackageFunctionId
     *            Work Package Function ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     *         WorkPackageFunction} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageFunctionByKeyFluentHelper getWorkPackageFunctionByKey(
        final String projectID,
        final String workPackageID,
        final String workPackageName,
        final String workPackageFunctionId );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     * WorkPackageFunction} entity and save it to the S/4HANA system.
     *
     * @param workPackageFunction
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     *            WorkPackageFunction} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     *         WorkPackageFunction} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageFunctionCreateFluentHelper
        createWorkPackageFunction( @Nonnull final WorkPackageFunction workPackageFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     * WorkPackageFunction} entity and save it to the S/4HANA system.
     *
     * @param workPackageFunction
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     *            WorkPackageFunction} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     *         WorkPackageFunction} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunctionUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageFunctionUpdateFluentHelper
        updateWorkPackageFunction( @Nonnull final WorkPackageFunction workPackageFunction );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectFluentHelper getAllProject();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project}
     * entity using key fields.
     *
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectByKeyFluentHelper getProjectByKey( final String projectID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity
     * and save it to the S/4HANA system.
     *
     * @param project
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectCreateFluentHelper createProject( @Nonnull final Project project );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project}
     * entity and save it to the S/4HANA system.
     *
     * @param project
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectUpdateFluentHelper updateProject( @Nonnull final Project project );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage
     * WorkPackage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageFluentHelper getAllWorkPackage();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage
     * WorkPackage} entity using key fields.
     *
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param workPackageName
     *            Work Package Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageByKeyFluentHelper
        getWorkPackageByKey( final String projectID, final String workPackageID, final String workPackageName );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage
     * WorkPackage} entity and save it to the S/4HANA system.
     *
     * @param workPackage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageCreateFluentHelper createWorkPackage( @Nonnull final WorkPackage workPackage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage
     * WorkPackage} entity and save it to the S/4HANA system.
     *
     * @param workPackage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageUpdateFluentHelper updateWorkPackage( @Nonnull final WorkPackage workPackage );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage
     * WorkPackage} entity in the S/4HANA system.
     *
     * @param workPackage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkPackageDeleteFluentHelper deleteWorkPackage( @Nonnull final WorkPackage workPackage );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkItemFluentHelper getAllWorkItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem}
     * entity using key fields.
     *
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param workPackageName
     *            Work Package Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param workitem
     *            Work Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkItemByKeyFluentHelper getWorkItemByKey(
        final String projectID,
        final String workPackageID,
        final String workPackageName,
        final String workitem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem}
     * entity and save it to the S/4HANA system.
     *
     * @param workItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkItemCreateFluentHelper createWorkItem( @Nonnull final WorkItem workItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem
     * WorkItem} entity in the S/4HANA system.
     *
     * @param workItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem} entity
     *            object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    WorkItemDeleteFluentHelper deleteWorkItem( @Nonnull final WorkItem workItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandFluentHelper getAllDemand();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     * using key fields.
     *
     * @param delvryServOrg
     *            Delivery Org. ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param resourceId
     *            Resource ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param workPackageName
     *            Work Package Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param resType
     *            Resource Type ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workitem
     *            Work Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandByKeyFluentHelper getDemandByKey(
        final String projectID,
        final String workPackageID,
        final String workPackageName,
        final String resType,
        final String resourceId,
        final String workitem,
        final String delvryServOrg );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     * and save it to the S/4HANA system.
     *
     * @param demand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandCreateFluentHelper createDemand( @Nonnull final Demand demand );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand}
     * entity and save it to the S/4HANA system.
     *
     * @param demand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandUpdateFluentHelper updateDemand( @Nonnull final Demand demand );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand}
     * entity in the S/4HANA system.
     *
     * @param demand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     *            object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.DemandDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DemandDeleteFluentHelper deleteDemand( @Nonnull final Demand demand );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole
     * ProjectRole} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectRoleFluentHelper getAllProjectRole();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole
     * ProjectRole} entity using key fields.
     *
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param projectRoleID
     *            Project Role ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 15
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectRoleByKeyFluentHelper getProjectRoleByKey( final String projectID, final String projectRoleID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole
     * ProjectRole} entity and save it to the S/4HANA system.
     *
     * @param projectRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectRoleCreateFluentHelper createProjectRole( @Nonnull final ProjectRole projectRole );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole
     * ProjectRole} entity and save it to the S/4HANA system.
     *
     * @param projectRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectRoleUpdateFluentHelper updateProjectRole( @Nonnull final ProjectRole projectRole );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole
     * ProjectRole} entity in the S/4HANA system.
     *
     * @param projectRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRoleDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProjectRoleDeleteFluentHelper deleteProjectRole( @Nonnull final ProjectRole projectRole );

    /**
     * <p>
     * Creates a fluent helper for the <b>updateCustProjSlsOrdItemMaterial</b> OData function import.
     * </p>
     *
     * @param salesOrderItem
     *            Constraints: Not nullable, Maximum length: 6
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesOrderItem</b>
     *            </p>
     * @param customerProject
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CustomerProject</b>
     *            </p>
     * @param material
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>updateCustProjSlsOrdItemMaterial</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.UpdateCustProjSlsOrdItemMaterialFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    UpdateCustProjSlsOrdItemMaterialFluentHelper updateCustProjSlsOrdItemMaterial(
        @Nonnull final String customerProject,
        @Nonnull final String salesOrderItem,
        @Nonnull final String material );

}
