/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmtByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.batch.ConditionContractTypeServiceBatch;

/**
 * <p>
 *
 * The service is based on the OData protocol and can be consumed in SAP Fiori apps and in other user interfaces.
 *
 * In every API call, you can make use of the following operations: - You can retrieve condition contract types. - You
 * can retrieve business volume field combinations based on a contract type. - You can retrieve field name assignments
 * to business volume field combination types used in condition contract settlement processes. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/9f/a139d692dd43e7af01343a1e5ff9ec/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CONDITION_CONTRACT_TYPE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CONDITION_CONTRACT_TYPE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Condition Contract Type Integration(SAP_COM_0335)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1B6'>Sales Rebate Processing(1B6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2R7'>Purchasing Rebate Processing(2R7)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2TT'>Sales Commissions - External Sales Representative(2TT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/55I'>Royalties Settlement for Sales(55I)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Condition Contract Type</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ConditionContractTypeService extends BatchService<ConditionContractTypeServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CONDITION_CONTRACT_TYPE";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ConditionContractTypeService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt
     * BusVolFldCombnSetTypeAssgmt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt
     *         BusVolFldCombnSetTypeAssgmt} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmtFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusVolFldCombnSetTypeAssgmtFluentHelper getAllBusVolFldCombnSetTypeAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt
     * BusVolFldCombnSetTypeAssgmt} entity using key fields.
     *
     * @param busVolFldCombnSet
     *            Set of Field Combinations
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param busVolFieldCombnType
     *            Field Combination for Business Volume Selection
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param cndnContrType
     *            Condition Contract Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmt
     *         BusVolFldCombnSetTypeAssgmt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.BusVolFldCombnSetTypeAssgmtByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusVolFldCombnSetTypeAssgmtByKeyFluentHelper getBusVolFldCombnSetTypeAssgmtByKey(
        final String cndnContrType,
        final String busVolFldCombnSet,
        final String busVolFieldCombnType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType
     * CndnContrType} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType
     *         CndnContrType} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrTypeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CndnContrTypeFluentHelper getAllCndnContrType();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType
     * CndnContrType} entity using key fields.
     *
     * @param cndnContrType
     *            Condition Contract Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrType
     *         CndnContrType} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.conditioncontracttype.CndnContrTypeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CndnContrTypeByKeyFluentHelper getCndnContrTypeByKey( final String cndnContrType );

}
