/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersionByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.batch.ConsolidationUnitServiceBatch;

/**
 * <p>
 * A consolidation unit is the smallest entity of the corporate group structure that can be used as the basis for
 * performing a consolidation. Consolidation units belong to the master data of group reporting.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ea/fd484b398443cb96ed33c8a123f4de/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CONSOLIDATIONUNIT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CONSOLIDATIONUNIT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Cloud Consolidation Data Collection Integration(SAP_COM_0241), Finance - Cloud Consolidation Master
 * Data for Group Reporting Integration(SAP_COM_0336)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/2U6'>Group Reporting - Data from External
 * Systems(2U6)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Consolidation Unit</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ConsolidationUnitService extends BatchService<ConsolidationUnitServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CONSOLIDATIONUNIT";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ConsolidationUnitService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime
     * ConsolidationUnitByTime} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime
     *         ConsolidationUnitByTime} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConsolidationUnitByTimeFluentHelper getAllConsolidationUnitByTime();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime
     * ConsolidationUnitByTime} entity using key fields.
     *
     * @param fromFiscalYearPeriod
     *            From Fiscal Year Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param consolidationUnit
     *            Consolidation Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTime
     *         ConsolidationUnitByTime} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConsolidationUnitByTimeByKeyFluentHelper
        getConsolidationUnitByTimeByKey( final String consolidationUnit, final String fromFiscalYearPeriod );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion
     * ConsolidationUnitByTimeVersion} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion
     *         ConsolidationUnitByTimeVersion} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersionFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConsolidationUnitByTimeVersionFluentHelper getAllConsolidationUnitByTimeVersion();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion
     * ConsolidationUnitByTimeVersion} entity using key fields.
     *
     * @param fromFiscalYearPeriod
     *            From Fiscal Year Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 7
     *            </p>
     * @param consolidationVersion
     *            Consolidation Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param consolidationUnit
     *            Consolidation Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersion
     *         ConsolidationUnitByTimeVersion} entity using key fields. This fluent helper allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByTimeVersionByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConsolidationUnitByTimeVersionByKeyFluentHelper getConsolidationUnitByTimeVersionByKey(
        final String consolidationUnit,
        final String consolidationVersion,
        final String fromFiscalYearPeriod );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitText
     * ConsolidationUnitText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitText
     *         ConsolidationUnitText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConsolidationUnitTextFluentHelper getAllConsolidationUnitText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitText
     * ConsolidationUnitText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param consolidationUnit
     *            Consolidation Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitText
     *         ConsolidationUnitText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConsolidationUnitTextByKeyFluentHelper
        getConsolidationUnitTextByKey( final String language, final String consolidationUnit );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit
     * ConsolidationUnit} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit
     *         ConsolidationUnit} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConsolidationUnitFluentHelper getAllConsolidationUnit();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit
     * ConsolidationUnit} entity using key fields.
     *
     * @param consolidationUnit
     *            Consolidation Unit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnit
     *         ConsolidationUnit} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.consolidationunit.ConsolidationUnitByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConsolidationUnitByKeyFluentHelper getConsolidationUnitByKey( final String consolidationUnit );

}
