/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.batch.ContractAccountingSEPAMandateServiceBatch;

/**
 * <p>
 *
 * With this service you can create, read and update SEPA Mandates for Contract Accounting (FI-CA). You can also create
 * and read the usage of SEPA mandates..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c1/1dbbdc5b454ad5814c981f2ac9aeab/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_O2C_FICA_SEPA_MANDATE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_O2C_FICA_SEPA_MANDATE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Contract Accounting SEPA Mandate Integration(SAP_COM_0458)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2AR'>Contract Accounting - Master Data and Basic
 * Functions(2AR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/OAR'>Contract Accounting - Master Data and Basic
 * Functions(OAR)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>SEPA Mandate</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ContractAccountingSEPAMandateService extends BatchService<ContractAccountingSEPAMandateServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_O2C_FICA_SEPA_MANDATE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ContractAccountingSEPAMandateService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate SEPAMandate}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate
     *         SEPAMandate} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SEPAMandateFluentHelper getAllSEPAMandate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate SEPAMandate}
     * entity using key fields.
     *
     * @param creditor
     *            Creditor Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param sEPAMandate
     *            Unique Reference to Mandate for each Payee
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate
     *         SEPAMandate} entity using key fields. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SEPAMandateByKeyFluentHelper getSEPAMandateByKey( final String creditor, final String sEPAMandate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate
     * SEPAMandate} entity and save it to the S/4HANA system.
     *
     * @param sEPAMandate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate
     *            SEPAMandate} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate
     *         SEPAMandate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SEPAMandateCreateFluentHelper createSEPAMandate( @Nonnull final SEPAMandate sEPAMandate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate SEPAMandate}
     * entity and save it to the S/4HANA system.
     *
     * @param sEPAMandate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate
     *            SEPAMandate} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandate
     *         SEPAMandate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SEPAMandateUpdateFluentHelper updateSEPAMandate( @Nonnull final SEPAMandate sEPAMandate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage
     * SEPAMandateUsage} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage
     *         SEPAMandateUsage} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SEPAMandateUsageFluentHelper getAllSEPAMandateUsage();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage
     * SEPAMandateUsage} entity using key fields.
     *
     * @param sEPAMandateUsePaymentDoc
     *            Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     * @param sEPAMandateUseObjectType
     *            Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param creditor
     *            Creditor ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param sEPAMandate
     *            Mandate Refeference
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param sEPAMandateUseDate
     *            Date
     *            <p>
     *            Constraints: Not nullable, Precision: 7
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage
     *         SEPAMandateUsage} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SEPAMandateUsageByKeyFluentHelper getSEPAMandateUsageByKey(
        final String creditor,
        final String sEPAMandate,
        final LocalDateTime sEPAMandateUseDate,
        final String sEPAMandateUseObjectType,
        final String sEPAMandateUsePaymentDoc );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage
     * SEPAMandateUsage} entity and save it to the S/4HANA system.
     *
     * @param sEPAMandateUsage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage
     *            SEPAMandateUsage} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsage
     *         SEPAMandateUsage} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.contractaccountingsepamandate.SEPAMandateUsageCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SEPAMandateUsageCreateFluentHelper createSEPAMandateUsage( @Nonnull final SEPAMandateUsage sEPAMandateUsage );

}
