/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.batch.ControllingAreaServiceBatch;

/**
 * <p>
 * The service contains the controlling area node.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/36/1a2707d8834d4e8bd865642bf115a5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CONTROLLINGAREA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CONTROLLINGAREA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ControllingArea</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface ControllingAreaService extends BatchService<ControllingAreaServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CONTROLLINGAREA_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ControllingAreaService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea
     * ControllingArea} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea
     *         ControllingArea} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingAreaFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingAreaFluentHelper getAllControllingArea();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea
     * ControllingArea} entity using key fields.
     *
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingArea
     *         ControllingArea} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.controllingarea.ControllingAreaByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingAreaByKeyFluentHelper getControllingAreaByKey( final String controllingArea );

}
