/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.batch.CostCenterServiceBatch;

/**
 * <p>
 * This service enables you to read cost center master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/37/310ccbc01943d98e7d84dff3802537/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_COSTCENTER_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_COSTCENTER_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Cost Center</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CostCenterService extends BatchService<CostCenterServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_COSTCENTER_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CostCenterService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter CostCenter}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter CostCenter} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterFluentHelper getAllCostCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter CostCenter}
     * entity using key fields.
     *
     * @param costCenter
     *            Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityEndDate
     *            Valid To Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter CostCenter} entity using
     *         key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterByKeyFluentHelper getCostCenterByKey(
        final String controllingArea,
        final String costCenter,
        final LocalDateTime validityEndDate );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText
     * CostCenterText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText CostCenterText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterTextFluentHelper getAllCostCenterText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText
     * CostCenterText} entity using key fields.
     *
     * @param costCenter
     *            Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityEndDate
     *            Valid To Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText CostCenterText}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterTextByKeyFluentHelper getCostCenterTextByKey(
        final String costCenter,
        final String controllingArea,
        final String language,
        final LocalDateTime validityEndDate );

}
