/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.batch.CostCenterTestServiceBatch;

/**
 * <p>
 *
 * This service enables you to read cost center master data. Please note that this service uses a data model where the
 * cost center is defined per company code. This data model has been replaced with a data model where the cost center is
 * defined per controlling area. With this change also a new service reflecting the new data model has been created and
 * this service is deprecated. It is highly recommended to use the new service instead of this one..
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/FCO_PI_COST_CENTER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>FCO_PI_COST_CENTER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Employee Integration (SAP_COM_0001)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/JB1'>Core HR with SAP SuccessFactors Employee Central
 * (JB1)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2002 (FEB-2020). Please use the
 *             <a href="https://api.sap.com/api/API_COSTCENTER_SRV"> successor API</a> instead.
 */
@Deprecated
public interface CostCenterTestService extends BatchService<CostCenterTestServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/FCO_PI_COST_CENTER";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CostCenterTestService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterFluentHelper getAllCostCenter();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     * entity using key fields.
     *
     * @param companyCode
     *            The company code is an organizational unit within financial accounting.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param costCenterID
     *            A key that uniquely identifies a cost center.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param validityEndDate
     *            Date indicating up to when an entry is valid.
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterByKeyFluentHelper
        getCostCenterByKey( final String companyCode, final String costCenterID, final LocalDateTime validityEndDate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     * entity and save it to the S/4HANA system.
     *
     * @param costCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterCreateFluentHelper createCostCenter( @Nonnull final CostCenter costCenter );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter
     * CostCenter} entity and save it to the S/4HANA system.
     *
     * @param costCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterUpdateFluentHelper updateCostCenter( @Nonnull final CostCenter costCenter );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter
     * CostCenter} entity in the S/4HANA system.
     *
     * @param costCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterDeleteFluentHelper deleteCostCenter( @Nonnull final CostCenter costCenter );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     * CostCenterText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText CostCenterText}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterTextFluentHelper getAllCostCenterText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     * CostCenterText} entity using key fields.
     *
     * @param companyCode
     *            The company code is an organizational unit within financial accounting.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param costCenterID
     *            A key that uniquely identifies a cost center.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            SAP Language Key (2-letter code) for Unicode languages.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Date indicating up to when an entry is valid.
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText CostCenterText}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterTextByKeyFluentHelper getCostCenterTextByKey(
        final String companyCode,
        final String costCenterID,
        final LocalDateTime validityEndDate,
        final String language );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     * CostCenterText} entity and save it to the S/4HANA system.
     *
     * @param costCenterText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     *            CostCenterText} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText CostCenterText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterTextCreateFluentHelper createCostCenterText( @Nonnull final CostCenterText costCenterText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     * CostCenterText} entity and save it to the S/4HANA system.
     *
     * @param costCenterText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     *            CostCenterText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText CostCenterText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterTextUpdateFluentHelper updateCostCenterText( @Nonnull final CostCenterText costCenterText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     * CostCenterText} entity in the S/4HANA system.
     *
     * @param costCenterText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     *            CostCenterText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText CostCenterText}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostCenterTextDeleteFluentHelper deleteCostCenterText( @Nonnull final CostCenterText costCenterText );

}
