/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.ReverseFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.batch.CostControllingJournalEntryServiceBatch;

/**
 * <p>
 *
 * This service enables you to read, create, and reverse journal entries related to cost controlling. You can reassign a
 * high volume of primary and secondary costs and revenues when the allocation is incorrect..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/0a/13edf5bb9d4b9ea7dd89fe6cd5309c/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_COSTREVNREASSIGNMENT?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_COSTREVNREASSIGNMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.2.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Reassign Costs and Revenues Integration(SAP_COM_0754)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O54'>Overhead Cost Accounting(O54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Journal Entry</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CostControllingJournalEntryService extends BatchService<CostControllingJournalEntryServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_COSTREVNREASSIGNMENT";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CostControllingJournalEntryService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
     * CostRevenueReassignment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
     *         CostRevenueReassignment} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevenueReassignmentFluentHelper getAllCostRevenueReassignment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
     * CostRevenueReassignment} entity using key fields.
     *
     * @param referenceDocument
     *            Reference document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
     *         CostRevenueReassignment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevenueReassignmentByKeyFluentHelper getCostRevenueReassignmentByKey(
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
     * CostRevenueReassignment} entity and save it to the S/4HANA system.
     *
     * @param costRevenueReassignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
     *            CostRevenueReassignment} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
     *         CostRevenueReassignment} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevenueReassignmentCreateFluentHelper
        createCostRevenueReassignment( @Nonnull final CostRevenueReassignment costRevenueReassignment );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItem
     * CostRevenueReassignmentItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItem
     *         CostRevenueReassignmentItem} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevenueReassignmentItemFluentHelper getAllCostRevenueReassignmentItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItem
     * CostRevenueReassignmentItem} entity using key fields.
     *
     * @param companyCode
     *            Receiver Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param referenceDocumentItem
     *            Reference Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param referenceDocument
     *            Reference Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItem
     *         CostRevenueReassignmentItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevenueReassignmentItemByKeyFluentHelper getCostRevenueReassignmentItemByKey(
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea,
        final String companyCode,
        final String ledgerGLLineItem,
        final String referenceDocumentItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment
     * CostRevnRcvrPrftbltySegment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment
     *         CostRevnRcvrPrftbltySegment} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevnRcvrPrftbltySegmentFluentHelper getAllCostRevnRcvrPrftbltySegment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment
     * CostRevnRcvrPrftbltySegment} entity using key fields.
     *
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param referenceDocumentItem
     *            Reference Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param referenceDocument
     *            Reference Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment
     *         CostRevnRcvrPrftbltySegment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevnRcvrPrftbltySegmentByKeyFluentHelper getCostRevnRcvrPrftbltySegmentByKey(
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea,
        final String ledgerGLLineItem,
        final String referenceDocumentItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment
     * CostRevnSndrPrftbltySegment} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment
     *         CostRevnSndrPrftbltySegment} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegmentFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevnSndrPrftbltySegmentFluentHelper getAllCostRevnSndrPrftbltySegment();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment
     * CostRevnSndrPrftbltySegment} entity using key fields.
     *
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param referenceDocumentItem
     *            Reference Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param referenceDocument
     *            Reference Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment
     *         CostRevnSndrPrftbltySegment} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegmentByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CostRevnSndrPrftbltySegmentByKeyFluentHelper getCostRevnSndrPrftbltySegmentByKey(
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea,
        final String ledgerGLLineItem,
        final String referenceDocumentItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>Reverse</b> OData function import.
     * </p>
     *
     * @param documentDate
     *            Document Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentDate</b>
     *            </p>
     * @param accountingDocumentHeaderText
     *            Document Header Text
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AccountingDocumentHeaderText</b>
     *            </p>
     * @param warningsAreIgnored
     *            Ignore warning
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WarningsAreIgnored</b>
     *            </p>
     * @param referenceDocument
     *            Reference document
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReferenceDocument</b>
     *            </p>
     * @param fiscalPeriod
     *            Fiscal Period
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalPeriod</b>
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ControllingArea</b>
     *            </p>
     * @param postingDate
     *            Posting Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FiscalYear</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>Reverse</b> OData function import with the provided
     *         parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.ReverseFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReverseFluentHelper reverse(
        @Nonnull final String fiscalYear,
        @Nonnull final String referenceDocument,
        @Nonnull final String controllingArea,
        @Nullable final LocalDateTime documentDate,
        @Nullable final LocalDateTime postingDate,
        @Nullable final String fiscalPeriod,
        @Nullable final String accountingDocumentHeaderText,
        @Nullable final String warningsAreIgnored );

}
