/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.batch.CostRateServiceBatch;

/**
 * <p>
 *
 * This service contains plan cost rate, actual cost rate and service cost rate.
 *
 * For each type you can read a list of existing cost rates, create a new one, update or delete an existing one.
 *
 * During creation or update, the information is used to create a new cost rate or to update an existing one - including
 * all necessary checks for restricted values and authorizations.
 *
 * Created or updated cost rates are included in the response. An existing cost rate that needs to be modified or
 * deleted is identified by the mandatory parameter - AccountingCostRateUUID.
 *
 * If there are any issues, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/59/9a4093d9614191bbd357e97fa558eb/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FCO_COST_RATE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FCO_COST_RATE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Activity Type Integration(SAP_COM_0129)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Accounting Cost Rate</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CostRateService extends BatchService<CostRateServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_FCO_COST_RATE_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CostRateService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActualCostRateFluentHelper getAllActualCostRate();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     * entity using key fields.
     *
     * @param accountingCostRateUUID
     *            Cost Rate UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActualCostRateByKeyFluentHelper getActualCostRateByKey( final UUID accountingCostRateUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     * entity and save it to the S/4HANA system.
     *
     * @param actualCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActualCostRateCreateFluentHelper createActualCostRate( @Nonnull final ActualCostRate actualCostRate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate
     * ActualCostRate} entity and save it to the S/4HANA system.
     *
     * @param actualCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActualCostRateUpdateFluentHelper updateActualCostRate( @Nonnull final ActualCostRate actualCostRate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate
     * ActualCostRate} entity in the S/4HANA system.
     *
     * @param actualCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ActualCostRateDeleteFluentHelper deleteActualCostRate( @Nonnull final ActualCostRate actualCostRate );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate}
     * entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entities.
     *         This fluent helper allows methods which modify the underlying query to be called before executing the
     *         query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlanCostRateFluentHelper getAllPlanCostRate();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate}
     * entity using key fields.
     *
     * @param accountingCostRateUUID
     *            Cost Rate UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity
     *         using key fields. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlanCostRateByKeyFluentHelper getPlanCostRateByKey( final UUID accountingCostRateUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate}
     * entity and save it to the S/4HANA system.
     *
     * @param planCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity
     *            object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlanCostRateCreateFluentHelper createPlanCostRate( @Nonnull final PlanCostRate planCostRate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate}
     * entity and save it to the S/4HANA system.
     *
     * @param planCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity
     *            object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlanCostRateUpdateFluentHelper updatePlanCostRate( @Nonnull final PlanCostRate planCostRate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate
     * PlanCostRate} entity in the S/4HANA system.
     *
     * @param planCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity
     *            object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity. To
     *         perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PlanCostRateDeleteFluentHelper deletePlanCostRate( @Nonnull final PlanCostRate planCostRate );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate
     * ServiceCostRate} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceCostRateFluentHelper getAllServiceCostRate();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate
     * ServiceCostRate} entity using key fields.
     *
     * @param accountingCostRateUUID
     *            Cost Rate UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceCostRateByKeyFluentHelper getServiceCostRateByKey( final UUID accountingCostRateUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     * entity and save it to the S/4HANA system.
     *
     * @param serviceCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *            entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceCostRateCreateFluentHelper createServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate
     * ServiceCostRate} entity and save it to the S/4HANA system.
     *
     * @param serviceCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *            entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceCostRateUpdateFluentHelper updateServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate
     * ServiceCostRate} entity in the S/4HANA system.
     *
     * @param serviceCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *            entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRateDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ServiceCostRateDeleteFluentHelper deleteServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate );

}
