/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.batch.CreditManagementMasterDataServiceBatch;

/**
 * <p>
 *
 * This service uses the following nodes: Business Partners, Credit Mgmt: BP Collateral, Credit Mgmt: BP Credit
 * Insurance, Credit Mgmt: BP Negative Event, Credit Accounts, Credit Mgmt Account: Collateral and Credit Mgmt Account:
 * Credit Insurance.
 *
 * Use the Business Partner node to read, create and update data related to credit management for business partners in
 * the business partner role SAP Credit Management, such as risk class, limit rule, or check rule.
 *
 * Use the Credit Mgmt: BP Collateral node to read, create, change or delete the collateral in the general data of
 * business partners.
 *
 * Use the Credit Mgmt: BP Credit Insurance node to read, create, change or delete credit insurances in the general data
 * of business partners.
 *
 * Use the Credit Mgmt: BP Negative Event node to read, create, change or delete negative credit events in the general
 * data of business partners.
 *
 * Use the Credit Management Account node to read, create, update, and delete credit segment data, such as credit limit,
 * special attention flag, block reason, and others.
 *
 * Use the Credit Mgmt Account: Collateral subnode to read, create, change or delete the collateral for business
 * partners in a credit segment.
 *
 * Use the Credit Mgmt Account: Credit Insurance subnode to read, create, change or delete credit insurances for
 * business partners in a credit segment.
 *
 * If you want to create credit-management-related master data for an existing business partner, you send data for both
 * nodes in a post request as a payload. If it’s not already maintained, the SAP Credit Management role (UKM000) is
 * automatically added to the business partners.
 *
 * If you want to add or change credit-management-related master data, you may send requests addressing the related
 * entities directly.
 *
 * If there are any issues with the data passed, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/64/e8c928499341ffb0eaac517a882b7d/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CRDTMBUSINESSPARTNER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CRDTMBUSINESSPARTNER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Credit Management Master Data Integration(SAP_COM_0740)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1QM'>Advanced Credit Management(1QM)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Credit Management Business Partner</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CreditManagementMasterDataService extends BatchService<CreditManagementMasterDataServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CRDTMBUSINESSPARTNER";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CreditManagementMasterDataService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     * CrdtMAcctCollateral} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     *         CrdtMAcctCollateral} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMAcctCollateralFluentHelper getAllCrdtMAcctCollateral();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     * CrdtMAcctCollateral} entity using key fields.
     *
     * @param creditSegment
     *            Credit Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param additionalCreditDocSequence
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param crdtAcctInformationType
     *            Information Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param crdtAcctInformationCategory
     *            Information Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     *         CrdtMAcctCollateral} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMAcctCollateralByKeyFluentHelper getCrdtMAcctCollateralByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     * CrdtMAcctCollateral} entity and save it to the S/4HANA system.
     *
     * @param crdtMAcctCollateral
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     *            CrdtMAcctCollateral} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     *         CrdtMAcctCollateral} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMAcctCollateralUpdateFluentHelper
        updateCrdtMAcctCollateral( @Nonnull final CrdtMAcctCollateral crdtMAcctCollateral );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     * CrdtMAcctCollateral} entity in the S/4HANA system.
     *
     * @param crdtMAcctCollateral
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     *            CrdtMAcctCollateral} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     *         CrdtMAcctCollateral} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateralDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMAcctCollateralDeleteFluentHelper
        deleteCrdtMAcctCollateral( @Nonnull final CrdtMAcctCollateral crdtMAcctCollateral );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     * CrdtMAcctCrdtInsurance} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     *         CrdtMAcctCrdtInsurance} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMAcctCrdtInsuranceFluentHelper getAllCrdtMAcctCrdtInsurance();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     * CrdtMAcctCrdtInsurance} entity using key fields.
     *
     * @param creditSegment
     *            Credit Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param additionalCreditDocSequence
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param crdtAcctInformationType
     *            Information Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param crdtAcctInformationCategory
     *            Information Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     *         CrdtMAcctCrdtInsurance} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMAcctCrdtInsuranceByKeyFluentHelper getCrdtMAcctCrdtInsuranceByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     * CrdtMAcctCrdtInsurance} entity and save it to the S/4HANA system.
     *
     * @param crdtMAcctCrdtInsurance
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     *            CrdtMAcctCrdtInsurance} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     *         CrdtMAcctCrdtInsurance} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMAcctCrdtInsuranceUpdateFluentHelper
        updateCrdtMAcctCrdtInsurance( @Nonnull final CrdtMAcctCrdtInsurance crdtMAcctCrdtInsurance );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     * CrdtMAcctCrdtInsurance} entity in the S/4HANA system.
     *
     * @param crdtMAcctCrdtInsurance
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     *            CrdtMAcctCrdtInsurance} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     *         CrdtMAcctCrdtInsurance} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsuranceDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMAcctCrdtInsuranceDeleteFluentHelper
        deleteCrdtMAcctCrdtInsurance( @Nonnull final CrdtMAcctCrdtInsurance crdtMAcctCrdtInsurance );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     * CreditMgmtBusinessPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     *         CreditMgmtBusinessPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMgmtBusinessPartnerFluentHelper getAllCreditMgmtBusinessPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     * CreditMgmtBusinessPartner} entity using key fields.
     *
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     *         CreditMgmtBusinessPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMgmtBusinessPartnerByKeyFluentHelper getCreditMgmtBusinessPartnerByKey( final String businessPartner );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     * CreditMgmtBusinessPartner} entity and save it to the S/4HANA system.
     *
     * @param creditMgmtBusinessPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     *            CreditMgmtBusinessPartner} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     *         CreditMgmtBusinessPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMgmtBusinessPartnerCreateFluentHelper
        createCreditMgmtBusinessPartner( @Nonnull final CreditMgmtBusinessPartner creditMgmtBusinessPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     * CreditMgmtBusinessPartner} entity and save it to the S/4HANA system.
     *
     * @param creditMgmtBusinessPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     *            CreditMgmtBusinessPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     *         CreditMgmtBusinessPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMgmtBusinessPartnerUpdateFluentHelper
        updateCreditMgmtBusinessPartner( @Nonnull final CreditMgmtBusinessPartner creditMgmtBusinessPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     * CrdtMgmtBPCollateral} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     *         CrdtMgmtBPCollateral} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPCollateralFluentHelper getAllCrdtMgmtBPCollateral();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     * CrdtMgmtBPCollateral} entity using key fields.
     *
     * @param creditSegment
     *            Credit Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param additionalCreditDocSequence
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param crdtAcctInformationType
     *            Information Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param crdtAcctInformationCategory
     *            Information Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     *         CrdtMgmtBPCollateral} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPCollateralByKeyFluentHelper getCrdtMgmtBPCollateralByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     * CrdtMgmtBPCollateral} entity and save it to the S/4HANA system.
     *
     * @param crdtMgmtBPCollateral
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     *            CrdtMgmtBPCollateral} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     *         CrdtMgmtBPCollateral} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPCollateralUpdateFluentHelper
        updateCrdtMgmtBPCollateral( @Nonnull final CrdtMgmtBPCollateral crdtMgmtBPCollateral );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     * CrdtMgmtBPCollateral} entity in the S/4HANA system.
     *
     * @param crdtMgmtBPCollateral
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     *            CrdtMgmtBPCollateral} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     *         CrdtMgmtBPCollateral} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateralDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPCollateralDeleteFluentHelper
        deleteCrdtMgmtBPCollateral( @Nonnull final CrdtMgmtBPCollateral crdtMgmtBPCollateral );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     * CrdtMgmtBPCreditInsurance} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     *         CrdtMgmtBPCreditInsurance} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPCreditInsuranceFluentHelper getAllCrdtMgmtBPCreditInsurance();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     * CrdtMgmtBPCreditInsurance} entity using key fields.
     *
     * @param creditSegment
     *            Credit Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param additionalCreditDocSequence
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param crdtAcctInformationType
     *            Information Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param crdtAcctInformationCategory
     *            Information Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     *         CrdtMgmtBPCreditInsurance} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPCreditInsuranceByKeyFluentHelper getCrdtMgmtBPCreditInsuranceByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     * CrdtMgmtBPCreditInsurance} entity and save it to the S/4HANA system.
     *
     * @param crdtMgmtBPCreditInsurance
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     *            CrdtMgmtBPCreditInsurance} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     *         CrdtMgmtBPCreditInsurance} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPCreditInsuranceUpdateFluentHelper
        updateCrdtMgmtBPCreditInsurance( @Nonnull final CrdtMgmtBPCreditInsurance crdtMgmtBPCreditInsurance );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     * CrdtMgmtBPCreditInsurance} entity in the S/4HANA system.
     *
     * @param crdtMgmtBPCreditInsurance
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     *            CrdtMgmtBPCreditInsurance} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     *         CrdtMgmtBPCreditInsurance} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsuranceDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPCreditInsuranceDeleteFluentHelper
        deleteCrdtMgmtBPCreditInsurance( @Nonnull final CrdtMgmtBPCreditInsurance crdtMgmtBPCreditInsurance );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     * CrdtMgmtBPNegativeEvent} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     *         CrdtMgmtBPNegativeEvent} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPNegativeEventFluentHelper getAllCrdtMgmtBPNegativeEvent();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     * CrdtMgmtBPNegativeEvent} entity using key fields.
     *
     * @param creditSegment
     *            Credit Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param additionalCreditDocSequence
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param crdtAcctInformationType
     *            Information Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param crdtAcctInformationCategory
     *            Information Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     *         CrdtMgmtBPNegativeEvent} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPNegativeEventByKeyFluentHelper getCrdtMgmtBPNegativeEventByKey(
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     * CrdtMgmtBPNegativeEvent} entity and save it to the S/4HANA system.
     *
     * @param crdtMgmtBPNegativeEvent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     *            CrdtMgmtBPNegativeEvent} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     *         CrdtMgmtBPNegativeEvent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPNegativeEventUpdateFluentHelper
        updateCrdtMgmtBPNegativeEvent( @Nonnull final CrdtMgmtBPNegativeEvent crdtMgmtBPNegativeEvent );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     * CrdtMgmtBPNegativeEvent} entity in the S/4HANA system.
     *
     * @param crdtMgmtBPNegativeEvent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     *            CrdtMgmtBPNegativeEvent} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     *         CrdtMgmtBPNegativeEvent} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEventDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdtMgmtBPNegativeEventDeleteFluentHelper
        deleteCrdtMgmtBPNegativeEvent( @Nonnull final CrdtMgmtBPNegativeEvent crdtMgmtBPNegativeEvent );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     * CreditManagementAccount} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *         CreditManagementAccount} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditManagementAccountFluentHelper getAllCreditManagementAccount();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     * CreditManagementAccount} entity using key fields.
     *
     * @param creditSegment
     *            Credit Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *         CreditManagementAccount} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditManagementAccountByKeyFluentHelper
        getCreditManagementAccountByKey( final String businessPartner, final String creditSegment );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     * CreditManagementAccount} entity and save it to the S/4HANA system.
     *
     * @param creditManagementAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *            CreditManagementAccount} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *         CreditManagementAccount} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditManagementAccountCreateFluentHelper
        createCreditManagementAccount( @Nonnull final CreditManagementAccount creditManagementAccount );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     * CreditManagementAccount} entity and save it to the S/4HANA system.
     *
     * @param creditManagementAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *            CreditManagementAccount} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *         CreditManagementAccount} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditManagementAccountUpdateFluentHelper
        updateCreditManagementAccount( @Nonnull final CreditManagementAccount creditManagementAccount );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     * CreditManagementAccount} entity in the S/4HANA system.
     *
     * @param creditManagementAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *            CreditManagementAccount} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *         CreditManagementAccount} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccountDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditManagementAccountDeleteFluentHelper
        deleteCreditManagementAccount( @Nonnull final CreditManagementAccount creditManagementAccount );

}
