/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVHByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVHFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.batch.CreditMemoRequestServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire credit memo requests or only
 * parts of the data, using the provided filters. - You can create credit memo requests. Note that you must use “deep
 * insert” requests (a header plus the following entities: header partner, header pricing element, item, item partner,
 * and item pricing element). You cannot create entities without including any related entities. - For existing credit
 * memo requests, you can create new items. Note that you must use “deep insert” requests (with the following entities:
 * item partner and item pricing element). You cannot create entities without including any related entities. - For
 * existing credit memo requests, you can update the following entities (that is, you can change the content of their
 * properties): the header, header partner, header pricing element, item, item partner, and item pricing element. - For
 * existing credit memo requests, you can delete the header, header partner, header pricing element, item, item partner,
 * and item pricing element. - You can accept or deny approval requests for credit memo requests that cannot be
 * processed without the consent of an approver..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/19/1531b7e2e048d9bddffab772f1788b/frameset.htm?profile=20025561'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CREDIT_MEMO_REQUEST_SRV?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CREDIT_MEMO_REQUEST_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Credit Memo Request Integration(SAP_COM_0158)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1EZ'>Credit Memo Processing(1EZ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKL'>Invoice Correction Process with Credit Memo(BKL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OKL'>Invoice Correction Process with Credit Memo(OKL)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PEZ'>Credit Memo Processing(PEZ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Credit Memo Request</td>
 * </tr>
 * </table>
 *
 */
public interface CreditMemoRequestService extends BatchService<CreditMemoRequestServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CREDIT_MEMO_REQUEST_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CreditMemoRequestService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow
     * CrdMmReqItemSubsqntProcFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow
     *         CrdMmReqItemSubsqntProcFlow} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdMmReqItemSubsqntProcFlowFluentHelper getAllCrdMmReqItemSubsqntProcFlow();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow
     * CrdMmReqItemSubsqntProcFlow} entity using key fields.
     *
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param creditMemoRequest
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param creditMemoRequestItem
     *            Preceding Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlow
     *         CrdMmReqItemSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CrdMmReqItemSubsqntProcFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CrdMmReqItemSubsqntProcFlowByKeyFluentHelper getCrdMmReqItemSubsqntProcFlowByKey(
        final String creditMemoRequest,
        final String creditMemoRequestItem,
        final UUID docRelationshipUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     * CreditMemoReqItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     *         CreditMemoReqItemPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemPartnerFluentHelper getAllCreditMemoReqItemPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     * CreditMemoReqItemPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param creditMemoRequest
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param creditMemoRequestItem
     *            Item number of the SD document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     *         CreditMemoReqItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemPartnerByKeyFluentHelper getCreditMemoReqItemPartnerByKey(
        final String creditMemoRequest,
        final String creditMemoRequestItem,
        final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     * CreditMemoReqItemPartner} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     *            CreditMemoReqItemPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     *         CreditMemoReqItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemPartnerUpdateFluentHelper
        updateCreditMemoReqItemPartner( @Nonnull final CreditMemoReqItemPartner creditMemoReqItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     * CreditMemoReqItemPartner} entity in the S/4HANA system.
     *
     * @param creditMemoReqItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     *            CreditMemoReqItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartner
     *         CreditMemoReqItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemPartnerDeleteFluentHelper
        deleteCreditMemoReqItemPartner( @Nonnull final CreditMemoReqItemPartner creditMemoReqItemPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     * CreditMemoReqItemPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     *         CreditMemoReqItemPrcgElmnt} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemPrcgElmntFluentHelper getAllCreditMemoReqItemPrcgElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     * CreditMemoReqItemPrcgElmnt} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param creditMemoRequest
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param creditMemoRequestItem
     *            Condition item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     *         CreditMemoReqItemPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemPrcgElmntByKeyFluentHelper getCreditMemoReqItemPrcgElmntByKey(
        final String creditMemoRequest,
        final String creditMemoRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     * CreditMemoReqItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     *            CreditMemoReqItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     *         CreditMemoReqItemPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemPrcgElmntUpdateFluentHelper
        updateCreditMemoReqItemPrcgElmnt( @Nonnull final CreditMemoReqItemPrcgElmnt creditMemoReqItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     * CreditMemoReqItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param creditMemoReqItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     *            CreditMemoReqItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmnt
     *         CreditMemoReqItemPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemPrcgElmntDeleteFluentHelper
        deleteCreditMemoReqItemPrcgElmnt( @Nonnull final CreditMemoReqItemPrcgElmnt creditMemoReqItemPrcgElmnt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     * CreditMemoReqItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     *         CreditMemoReqItemText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemTextFluentHelper getAllCreditMemoReqItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     * CreditMemoReqItemText} entity using key fields.
     *
     * @param creditMemoRequest
     *            Credit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param creditMemoRequestItem
     *            Credit Memo Request Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     *         CreditMemoReqItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemTextByKeyFluentHelper getCreditMemoReqItemTextByKey(
        final String creditMemoRequest,
        final String creditMemoRequestItem,
        final String language,
        final String longTextID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     * CreditMemoReqItemText} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     *            CreditMemoReqItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     *         CreditMemoReqItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemTextUpdateFluentHelper
        updateCreditMemoReqItemText( @Nonnull final CreditMemoReqItemText creditMemoReqItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     * CreditMemoReqItemText} entity in the S/4HANA system.
     *
     * @param creditMemoReqItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     *            CreditMemoReqItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemText
     *         CreditMemoReqItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqItemTextDeleteFluentHelper
        deleteCreditMemoReqItemText( @Nonnull final CreditMemoReqItemText creditMemoReqItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     * CreditMemoReqPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     *         CreditMemoReqPartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqPartnerFluentHelper getAllCreditMemoReqPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     * CreditMemoReqPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param creditMemoRequest
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     *         CreditMemoReqPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqPartnerByKeyFluentHelper
        getCreditMemoReqPartnerByKey( final String creditMemoRequest, final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     * CreditMemoReqPartner} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     *            CreditMemoReqPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     *         CreditMemoReqPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqPartnerUpdateFluentHelper
        updateCreditMemoReqPartner( @Nonnull final CreditMemoReqPartner creditMemoReqPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     * CreditMemoReqPartner} entity in the S/4HANA system.
     *
     * @param creditMemoReqPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     *            CreditMemoReqPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartner
     *         CreditMemoReqPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqPartnerDeleteFluentHelper
        deleteCreditMemoReqPartner( @Nonnull final CreditMemoReqPartner creditMemoReqPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     * CreditMemoReqPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     *         CreditMemoReqPrcgElmnt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqPrcgElmntFluentHelper getAllCreditMemoReqPrcgElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     * CreditMemoReqPrcgElmnt} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param creditMemoRequest
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     *         CreditMemoReqPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqPrcgElmntByKeyFluentHelper getCreditMemoReqPrcgElmntByKey(
        final String creditMemoRequest,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     * CreditMemoReqPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     *            CreditMemoReqPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     *         CreditMemoReqPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqPrcgElmntUpdateFluentHelper
        updateCreditMemoReqPrcgElmnt( @Nonnull final CreditMemoReqPrcgElmnt creditMemoReqPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     * CreditMemoReqPrcgElmnt} entity in the S/4HANA system.
     *
     * @param creditMemoReqPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     *            CreditMemoReqPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmnt
     *         CreditMemoReqPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqPrcgElmntDeleteFluentHelper
        deleteCreditMemoReqPrcgElmnt( @Nonnull final CreditMemoReqPrcgElmnt creditMemoReqPrcgElmnt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow
     * CreditMemoReqSubsqntProcFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow
     *         CreditMemoReqSubsqntProcFlow} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqSubsqntProcFlowFluentHelper getAllCreditMemoReqSubsqntProcFlow();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow
     * CreditMemoReqSubsqntProcFlow} entity using key fields.
     *
     * @param creditMemoRequest
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subsequentDocument
     *            Subsequent Sales and Distribution Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlow
     *         CreditMemoReqSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqSubsqntProcFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqSubsqntProcFlowByKeyFluentHelper
        getCreditMemoReqSubsqntProcFlowByKey( final String creditMemoRequest, final String subsequentDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     * CreditMemoReqText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     *         CreditMemoReqText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqTextFluentHelper getAllCreditMemoReqText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     * CreditMemoReqText} entity using key fields.
     *
     * @param creditMemoRequest
     *            Credit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     *         CreditMemoReqText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqTextByKeyFluentHelper
        getCreditMemoReqTextByKey( final String creditMemoRequest, final String language, final String longTextID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     * CreditMemoReqText} entity and save it to the S/4HANA system.
     *
     * @param creditMemoReqText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     *            CreditMemoReqText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     *         CreditMemoReqText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqTextUpdateFluentHelper updateCreditMemoReqText( @Nonnull final CreditMemoReqText creditMemoReqText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText CreditMemoReqText}
     * entity in the S/4HANA system.
     *
     * @param creditMemoReqText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     *            CreditMemoReqText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqText
     *         CreditMemoReqText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoReqTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoReqTextDeleteFluentHelper deleteCreditMemoReqText( @Nonnull final CreditMemoReqText creditMemoReqText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     * CreditMemoRequest} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *         CreditMemoRequest} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestFluentHelper getAllCreditMemoRequest();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     * CreditMemoRequest} entity using key fields.
     *
     * @param creditMemoRequest
     *            Credit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *         CreditMemoRequest} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestByKeyFluentHelper getCreditMemoRequestByKey( final String creditMemoRequest );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     * CreditMemoRequest} entity and save it to the S/4HANA system.
     *
     * @param creditMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *            CreditMemoRequest} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *         CreditMemoRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestCreateFluentHelper createCreditMemoRequest( @Nonnull final CreditMemoRequest creditMemoRequest );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     * CreditMemoRequest} entity and save it to the S/4HANA system.
     *
     * @param creditMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *            CreditMemoRequest} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *         CreditMemoRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestUpdateFluentHelper updateCreditMemoRequest( @Nonnull final CreditMemoRequest creditMemoRequest );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest CreditMemoRequest}
     * entity in the S/4HANA system.
     *
     * @param creditMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *            CreditMemoRequest} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequest
     *         CreditMemoRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestDeleteFluentHelper deleteCreditMemoRequest( @Nonnull final CreditMemoRequest creditMemoRequest );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *         CreditMemoRequestItem} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestItemFluentHelper getAllCreditMemoRequestItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entity using key fields.
     *
     * @param creditMemoRequest
     *            Credit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param creditMemoRequestItem
     *            Credit Memo Request Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *         CreditMemoRequestItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestItemByKeyFluentHelper
        getCreditMemoRequestItemByKey( final String creditMemoRequest, final String creditMemoRequestItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entity and save it to the S/4HANA system.
     *
     * @param creditMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *            CreditMemoRequestItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *         CreditMemoRequestItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestItemCreateFluentHelper
        createCreditMemoRequestItem( @Nonnull final CreditMemoRequestItem creditMemoRequestItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entity and save it to the S/4HANA system.
     *
     * @param creditMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *            CreditMemoRequestItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *         CreditMemoRequestItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestItemUpdateFluentHelper
        updateCreditMemoRequestItem( @Nonnull final CreditMemoRequestItem creditMemoRequestItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     * CreditMemoRequestItem} entity in the S/4HANA system.
     *
     * @param creditMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *            CreditMemoRequestItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItem
     *         CreditMemoRequestItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditMemoRequestItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditMemoRequestItemDeleteFluentHelper
        deleteCreditMemoRequestItem( @Nonnull final CreditMemoRequestItem creditMemoRequestItem );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVH
     * BusinessAreaStdVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVH
     *         BusinessAreaStdVH} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessAreaStdVHFluentHelper getAllBusinessAreaStdVH();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVH
     * BusinessAreaStdVH} entity using key fields.
     *
     * @param businessArea
     *            Business Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVH
     *         BusinessAreaStdVH} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.BusinessAreaStdVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    BusinessAreaStdVHByKeyFluentHelper getBusinessAreaStdVHByKey( final String businessArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVH
     * CompanyCodeStdVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVH
     *         CompanyCodeStdVH} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompanyCodeStdVHFluentHelper getAllCompanyCodeStdVH();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVH
     * CompanyCodeStdVH} entity using key fields.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVH
     *         CompanyCodeStdVH} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CompanyCodeStdVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CompanyCodeStdVHByKeyFluentHelper getCompanyCodeStdVHByKey( final String companyCode );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVH
     * ControllingAreaStdVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVH
     *         ControllingAreaStdVH} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingAreaStdVHFluentHelper getAllControllingAreaStdVH();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVH
     * ControllingAreaStdVH} entity using key fields.
     *
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVH
     *         ControllingAreaStdVH} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingAreaStdVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingAreaStdVHByKeyFluentHelper getControllingAreaStdVHByKey( final String controllingArea );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH
     * ControllingObjectStdVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH
     *         ControllingObjectStdVH} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingObjectStdVHFluentHelper getAllControllingObjectStdVH();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH
     * ControllingObjectStdVH} entity using key fields.
     *
     * @param controllingObject
     *            Object Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 22
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVH
     *         ControllingObjectStdVH} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ControllingObjectStdVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ControllingObjectStdVHByKeyFluentHelper getControllingObjectStdVHByKey( final String controllingObject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVH
     * CreditControlAreaStdVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVH
     *         CreditControlAreaStdVH} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditControlAreaStdVHFluentHelper getAllCreditControlAreaStdVH();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVH
     * CreditControlAreaStdVH} entity using key fields.
     *
     * @param creditControlArea
     *            Credit Control Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVH
     *         CreditControlAreaStdVH} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.CreditControlAreaStdVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreditControlAreaStdVHByKeyFluentHelper getCreditControlAreaStdVHByKey( final String creditControlArea );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VH
     * Customer_VH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VH Customer_VH}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    Customer_VHFluentHelper getAllCustomer_VH();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VH
     * Customer_VH} entity using key fields.
     *
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VH Customer_VH}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.Customer_VHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    Customer_VHByKeyFluentHelper getCustomer_VHByKey( final String customer );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVH
     * MaterialStdVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVH MaterialStdVH}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialStdVHFluentHelper getAllMaterialStdVH();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVH
     * MaterialStdVH} entity using key fields.
     *
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVH MaterialStdVH}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.MaterialStdVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    MaterialStdVHByKeyFluentHelper getMaterialStdVHByKey( final String material );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVH
     * ProductStdVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVH ProductStdVH}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStdVHFluentHelper getAllProductStdVH();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVH
     * ProductStdVH} entity using key fields.
     *
     * @param product
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVH ProductStdVH}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ProductStdVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ProductStdVHByKeyFluentHelper getProductStdVHByKey( final String product );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVH
     * SalesDealStdVH} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVH
     *         SalesDealStdVH} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVHFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDealStdVHFluentHelper getAllSalesDealStdVH();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVH
     * SalesDealStdVH} entity using key fields.
     *
     * @param salesDeal
     *            Agreement (various conditions grouped together)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVH
     *         SalesDealStdVH} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.SalesDealStdVHByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SalesDealStdVHByKeyFluentHelper getSalesDealStdVHByKey( final String salesDeal );

    /**
     * <p>
     * Creates a fluent helper for the <b>releaseApprovalRequest</b> OData function import.
     * </p>
     *
     * @param creditMemoRequest
     *            Constraints: Not nullable, Maximum length: 11000
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CreditMemoRequest</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>releaseApprovalRequest</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.ReleaseApprovalRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String creditMemoRequest );

    /**
     * <p>
     * Creates a fluent helper for the <b>rejectApprovalRequest</b> OData function import.
     * </p>
     *
     * @param creditMemoRequest
     *            Constraints: Not nullable, Maximum length: 11000
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CreditMemoRequest</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>rejectApprovalRequest</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmemorequest.RejectApprovalRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String creditMemoRequest );

}
