/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFileByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFileFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.batch.CustomerDataReturnFileDownloadServiceBatch;

/**
 * <p>
 * This service can be consumed by external application to download all business data from SAP S/4HANA Cloud systems,
 * prepared using Customer Data Return - Extraction app, to a local machine or third party storage.
 *
 * You can use this service to: - Download prepared files in compressed format - Retrieve list of prepared files -
 * Retrieve download status details of files
 *
 * It returns an appropriate success or error response while performing the operations. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/10/6c356af8a341a694596b864967f8a3/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CDR_FILE_DOWNLOAD_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CDR_FILE_DOWNLOAD_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Customer Data Return Integration(SAP_COM_0589)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/5I9'>Customer Data Return(5I9)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CustomerDataReturnFileDownloadService extends BatchService<CustomerDataReturnFileDownloadServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CDR_FILE_DOWNLOAD_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CustomerDataReturnFileDownloadService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile
     * ListFile} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFile
     *         ListFile} entities. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.ListFileFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ListFileFluentHelper getAllListFile();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFile
     * DownloadFile} entity using key fields.
     *
     * @param fileName
     *            ZIP File Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 60
     *            </p>
     * @param packageName
     *            Package Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 32
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFile
     *         DownloadFile} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.DownloadFileByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DownloadFileByKeyFluentHelper getDownloadFileByKey( final String packageName, final String fileName );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus
     * FileDownloadStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatus
     *         FileDownloadStatus} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerdatareturnfiledownload.FileDownloadStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    FileDownloadStatusFluentHelper getAllFileDownloadStatus();

}
