/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.batch.CustomerMaterialServiceBatch;

/**
 * <p>
 * The service contains one entity only for customer material. If there are any issues when creating, reading, updating,
 * or deleting the customer material, the system displays error messages in the response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/52/9318c3a0014f1bb1911541546569a2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CUSTOMER_MATERIAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CUSTOMER_MATERIAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Customer Material Info Record Integration(SAP_COM_0134)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CustomerMaterialService extends BatchService<CustomerMaterialServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CUSTOMER_MATERIAL_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CustomerMaterialService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     * CustomerMaterial} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *         CustomerMaterial} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerMaterialFluentHelper getAllCustomerMaterial();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     * CustomerMaterial} entity using key fields.
     *
     * @param material
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param distributionChannel
     *            Distribution Channel
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param salesOrganization
     *            Sales Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customer
     *            Customer number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *         CustomerMaterial} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerMaterialByKeyFluentHelper getCustomerMaterialByKey(
        final String salesOrganization,
        final String distributionChannel,
        final String customer,
        final String material );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     * CustomerMaterial} entity and save it to the S/4HANA system.
     *
     * @param customerMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *            CustomerMaterial} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *         CustomerMaterial} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerMaterialCreateFluentHelper createCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     * CustomerMaterial} entity and save it to the S/4HANA system.
     *
     * @param customerMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *            CustomerMaterial} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *         CustomerMaterial} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerMaterialUpdateFluentHelper updateCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     * CustomerMaterial} entity in the S/4HANA system.
     *
     * @param customerMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *            CustomerMaterial} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterial
     *         CustomerMaterial} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customermaterial.CustomerMaterialDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerMaterialDeleteFluentHelper deleteCustomerMaterial( @Nonnull final CustomerMaterial customerMaterial );

}
