/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatusByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatusFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStepByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStepFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLineByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLineFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumberByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumberFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.RejectApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.ReleaseApprovalRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.batch.CustomerReturnServiceBatch;

/**
 * <p>
 * You can use this service to integrate external applications with customer return processing in SAP S/4HANA Cloud. In
 * every API call, you can make use of the following operations: - You can retrieve customer returns. Apply any of the
 * filters provided or retrieve all existing data. - You can create customer returns. Note that you must use “deep
 * insert” requests (a header plus the following entities: header partner, header pricing element, item, item partner,
 * and item pricing element). You cannot create entities without including any related entities. - For existing customer
 * returns, you can create new items. Note that you must use “deep insert” requests (with the following entities: item
 * partner and item pricing element). You cannot create entities without including any related entities. - For existing
 * customer returns, you can update the header, header partner, header pricing element, item, item partner, and item
 * pricing element. - For existing customer returns, you can delete the header, header partner, header pricing element,
 * item, item partner, and item pricing element..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/69/bd2e81cb394eb0b3d8eae85d6b4517/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CUSTOMER_RETURN_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CUSTOMER_RETURN_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Customer Return Integration(SAP_COM_0157)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1IU'>Customer Consignment(1IU)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1Z3'>Customer Returns with Direct Shipment from Customer to
 * Supplier(1Z3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer Return</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CustomerReturnService extends BatchService<CustomerReturnServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CUSTOMER_RETURN_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CustomerReturnService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     * CustomerReturn} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn CustomerReturn}
     *         entities. This fluent helper allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnFluentHelper getAllCustomerReturn();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     * CustomerReturn} entity using key fields.
     *
     * @param customerReturn
     *            Customer Return
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn CustomerReturn}
     *         entity using key fields. This fluent helper allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnByKeyFluentHelper getCustomerReturnByKey( final String customerReturn );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     * CustomerReturn} entity and save it to the S/4HANA system.
     *
     * @param customerReturn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     *            CustomerReturn} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn CustomerReturn}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnCreateFluentHelper createCustomerReturn( @Nonnull final CustomerReturn customerReturn );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     * CustomerReturn} entity and save it to the S/4HANA system.
     *
     * @param customerReturn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     *            CustomerReturn} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn CustomerReturn}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnUpdateFluentHelper updateCustomerReturn( @Nonnull final CustomerReturn customerReturn );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     * CustomerReturn} entity in the S/4HANA system.
     *
     * @param customerReturn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn
     *            CustomerReturn} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturn CustomerReturn}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnDeleteFluentHelper deleteCustomerReturn( @Nonnull final CustomerReturn customerReturn );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     * CustomerReturnItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *         CustomerReturnItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemFluentHelper getAllCustomerReturnItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     * CustomerReturnItem} entity using key fields.
     *
     * @param customerReturnItem
     *            Customer Return Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerReturn
     *            Customer Return
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *         CustomerReturnItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemByKeyFluentHelper
        getCustomerReturnItemByKey( final String customerReturn, final String customerReturnItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     * CustomerReturnItem} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *            CustomerReturnItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *         CustomerReturnItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemCreateFluentHelper
        createCustomerReturnItem( @Nonnull final CustomerReturnItem customerReturnItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     * CustomerReturnItem} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *            CustomerReturnItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *         CustomerReturnItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemUpdateFluentHelper
        updateCustomerReturnItem( @Nonnull final CustomerReturnItem customerReturnItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     * CustomerReturnItem} entity in the S/4HANA system.
     *
     * @param customerReturnItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *            CustomerReturnItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItem
     *         CustomerReturnItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemDeleteFluentHelper
        deleteCustomerReturnItem( @Nonnull final CustomerReturnItem customerReturnItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     * CustomerReturnItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     *         CustomerReturnItemPartner} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemPartnerFluentHelper getAllCustomerReturnItemPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     * CustomerReturnItemPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param customerReturnItem
     *            Item number of the SD document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerReturn
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     *         CustomerReturnItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemPartnerByKeyFluentHelper getCustomerReturnItemPartnerByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     * CustomerReturnItemPartner} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     *            CustomerReturnItemPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     *         CustomerReturnItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemPartnerUpdateFluentHelper
        updateCustomerReturnItemPartner( @Nonnull final CustomerReturnItemPartner customerReturnItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     * CustomerReturnItemPartner} entity in the S/4HANA system.
     *
     * @param customerReturnItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     *            CustomerReturnItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartner
     *         CustomerReturnItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemPartnerDeleteFluentHelper
        deleteCustomerReturnItemPartner( @Nonnull final CustomerReturnItemPartner customerReturnItemPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     * CustomerReturnItemPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     *         CustomerReturnItemPrcgElmnt} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemPrcgElmntFluentHelper getAllCustomerReturnItemPrcgElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     * CustomerReturnItemPrcgElmnt} entity using key fields.
     *
     * @param customerReturnItem
     *            Condition item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param customerReturn
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     *         CustomerReturnItemPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemPrcgElmntByKeyFluentHelper getCustomerReturnItemPrcgElmntByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     * CustomerReturnItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     *            CustomerReturnItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     *         CustomerReturnItemPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemPrcgElmntUpdateFluentHelper
        updateCustomerReturnItemPrcgElmnt( @Nonnull final CustomerReturnItemPrcgElmnt customerReturnItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     * CustomerReturnItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param customerReturnItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     *            CustomerReturnItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmnt
     *         CustomerReturnItemPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemPrcgElmntDeleteFluentHelper
        deleteCustomerReturnItemPrcgElmnt( @Nonnull final CustomerReturnItemPrcgElmnt customerReturnItemPrcgElmnt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     * CustomerReturnItemRelatedObj} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     *         CustomerReturnItemRelatedObj} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemRelatedObjFluentHelper getAllCustomerReturnItemRelatedObj();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     * CustomerReturnItemRelatedObj} entity using key fields.
     *
     * @param customerReturnItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param sDDocRelatedObjectSequenceNmbr
     *            Sequence Number of the Related Object of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customerReturn
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     *         CustomerReturnItemRelatedObj} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemRelatedObjByKeyFluentHelper getCustomerReturnItemRelatedObjByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String sDDocRelatedObjectSequenceNmbr );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     * CustomerReturnItemRelatedObj} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItemRelatedObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     *            CustomerReturnItemRelatedObj} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     *         CustomerReturnItemRelatedObj} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemRelatedObjCreateFluentHelper
        createCustomerReturnItemRelatedObj( @Nonnull final CustomerReturnItemRelatedObj customerReturnItemRelatedObj );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     * CustomerReturnItemRelatedObj} entity in the S/4HANA system.
     *
     * @param customerReturnItemRelatedObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     *            CustomerReturnItemRelatedObj} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObj
     *         CustomerReturnItemRelatedObj} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemRelatedObjDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemRelatedObjDeleteFluentHelper
        deleteCustomerReturnItemRelatedObj( @Nonnull final CustomerReturnItemRelatedObj customerReturnItemRelatedObj );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     * CustomerReturnItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     *         CustomerReturnItemText} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemTextFluentHelper getAllCustomerReturnItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     * CustomerReturnItemText} entity using key fields.
     *
     * @param customerReturnItem
     *            Customer Return Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customerReturn
     *            Customer Return
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     *         CustomerReturnItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemTextByKeyFluentHelper getCustomerReturnItemTextByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String language,
        final String longTextID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     * CustomerReturnItemText} entity and save it to the S/4HANA system.
     *
     * @param customerReturnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     *            CustomerReturnItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     *         CustomerReturnItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemTextUpdateFluentHelper
        updateCustomerReturnItemText( @Nonnull final CustomerReturnItemText customerReturnItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     * CustomerReturnItemText} entity in the S/4HANA system.
     *
     * @param customerReturnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     *            CustomerReturnItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemText
     *         CustomerReturnItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnItemTextDeleteFluentHelper
        deleteCustomerReturnItemText( @Nonnull final CustomerReturnItemText customerReturnItemText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus
     * CustomerReturnOverviewStatus} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus
     *         CustomerReturnOverviewStatus} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatusFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnOverviewStatusFluentHelper getAllCustomerReturnOverviewStatus();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus
     * CustomerReturnOverviewStatus} entity using key fields.
     *
     * @param retsMgmtProcess
     *            Process Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatus
     *         CustomerReturnOverviewStatus} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnOverviewStatusByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnOverviewStatusByKeyFluentHelper getCustomerReturnOverviewStatusByKey( final String retsMgmtProcess );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     * CustomerReturnPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     *         CustomerReturnPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnPartnerFluentHelper getAllCustomerReturnPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     * CustomerReturnPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param customerReturn
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     *         CustomerReturnPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnPartnerByKeyFluentHelper
        getCustomerReturnPartnerByKey( final String customerReturn, final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     * CustomerReturnPartner} entity and save it to the S/4HANA system.
     *
     * @param customerReturnPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     *            CustomerReturnPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     *         CustomerReturnPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnPartnerUpdateFluentHelper
        updateCustomerReturnPartner( @Nonnull final CustomerReturnPartner customerReturnPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     * CustomerReturnPartner} entity in the S/4HANA system.
     *
     * @param customerReturnPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     *            CustomerReturnPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartner
     *         CustomerReturnPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnPartnerDeleteFluentHelper
        deleteCustomerReturnPartner( @Nonnull final CustomerReturnPartner customerReturnPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     * CustomerReturnPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     *         CustomerReturnPrcgElmnt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnPrcgElmntFluentHelper getAllCustomerReturnPrcgElmnt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     * CustomerReturnPrcgElmnt} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param customerReturn
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     *         CustomerReturnPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnPrcgElmntByKeyFluentHelper getCustomerReturnPrcgElmntByKey(
        final String customerReturn,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     * CustomerReturnPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param customerReturnPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     *            CustomerReturnPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     *         CustomerReturnPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnPrcgElmntUpdateFluentHelper
        updateCustomerReturnPrcgElmnt( @Nonnull final CustomerReturnPrcgElmnt customerReturnPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     * CustomerReturnPrcgElmnt} entity in the S/4HANA system.
     *
     * @param customerReturnPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     *            CustomerReturnPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmnt
     *         CustomerReturnPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnPrcgElmntDeleteFluentHelper
        deleteCustomerReturnPrcgElmnt( @Nonnull final CustomerReturnPrcgElmnt customerReturnPrcgElmnt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep
     * CustomerReturnProcessStep} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep
     *         CustomerReturnProcessStep} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStepFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnProcessStepFluentHelper getAllCustomerReturnProcessStep();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep
     * CustomerReturnProcessStep} entity using key fields.
     *
     * @param returnsDocumentType
     *            Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param retsMgmtProcessStep
     *            Step ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param returnsDocumentItem
     *            Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param retsMgmtProcess
     *            Process Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param retsMgmtProcessItem
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param retsMgmtProcItmQtySplit
     *            Split Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param returnsDocument
     *            Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStep
     *         CustomerReturnProcessStep} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnProcessStepByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnProcessStepByKeyFluentHelper getCustomerReturnProcessStepByKey(
        final String retsMgmtProcess,
        final String retsMgmtProcessItem,
        final String retsMgmtProcItmQtySplit,
        final String retsMgmtProcessStep,
        final String returnsDocumentType,
        final String returnsDocument,
        final String returnsDocumentItem );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     * CustomerReturnRelatedObject} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     *         CustomerReturnRelatedObject} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnRelatedObjectFluentHelper getAllCustomerReturnRelatedObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     * CustomerReturnRelatedObject} entity using key fields.
     *
     * @param sDDocRelatedObjectSequenceNmbr
     *            Sequence Number of the Related Object of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customerReturn
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     *         CustomerReturnRelatedObject} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnRelatedObjectByKeyFluentHelper
        getCustomerReturnRelatedObjectByKey( final String customerReturn, final String sDDocRelatedObjectSequenceNmbr );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     * CustomerReturnRelatedObject} entity and save it to the S/4HANA system.
     *
     * @param customerReturnRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     *            CustomerReturnRelatedObject} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     *         CustomerReturnRelatedObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnRelatedObjectCreateFluentHelper
        createCustomerReturnRelatedObject( @Nonnull final CustomerReturnRelatedObject customerReturnRelatedObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     * CustomerReturnRelatedObject} entity in the S/4HANA system.
     *
     * @param customerReturnRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     *            CustomerReturnRelatedObject} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObject
     *         CustomerReturnRelatedObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnRelatedObjectDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnRelatedObjectDeleteFluentHelper
        deleteCustomerReturnRelatedObject( @Nonnull final CustomerReturnRelatedObject customerReturnRelatedObject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLine
     * CustomerReturnScheduleLine} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLine
     *         CustomerReturnScheduleLine} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLineFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnScheduleLineFluentHelper getAllCustomerReturnScheduleLine();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLine
     * CustomerReturnScheduleLine} entity using key fields.
     *
     * @param customerReturnItem
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param scheduleLine
     *            Schedule Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customerReturn
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLine
     *         CustomerReturnScheduleLine} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnScheduleLineByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnScheduleLineByKeyFluentHelper getCustomerReturnScheduleLineByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String scheduleLine );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumber
     * CustomerReturnSerialNumber} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumber
     *         CustomerReturnSerialNumber} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumberFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnSerialNumberFluentHelper getAllCustomerReturnSerialNumber();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumber
     * CustomerReturnSerialNumber} entity using key fields.
     *
     * @param customerReturnItem
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serialNumber
     *            Serial Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param customerReturn
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumber
     *         CustomerReturnSerialNumber} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnSerialNumberByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnSerialNumberByKeyFluentHelper getCustomerReturnSerialNumberByKey(
        final String customerReturn,
        final String customerReturnItem,
        final String serialNumber );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     * CustomerReturnText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     *         CustomerReturnText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnTextFluentHelper getAllCustomerReturnText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     * CustomerReturnText} entity using key fields.
     *
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param customerReturn
     *            Customer Return
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     *         CustomerReturnText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnTextByKeyFluentHelper
        getCustomerReturnTextByKey( final String customerReturn, final String language, final String longTextID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     * CustomerReturnText} entity and save it to the S/4HANA system.
     *
     * @param customerReturnText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     *            CustomerReturnText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     *         CustomerReturnText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnTextUpdateFluentHelper
        updateCustomerReturnText( @Nonnull final CustomerReturnText customerReturnText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     * CustomerReturnText} entity in the S/4HANA system.
     *
     * @param customerReturnText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     *            CustomerReturnText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnText
     *         CustomerReturnText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.CustomerReturnTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CustomerReturnTextDeleteFluentHelper
        deleteCustomerReturnText( @Nonnull final CustomerReturnText customerReturnText );

    /**
     * <p>
     * Creates a fluent helper for the <b>rejectApprovalRequest</b> OData function import.
     * </p>
     *
     * @param customerReturn
     *            Constraints: Not nullable, Maximum length: 11
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CustomerReturn</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>rejectApprovalRequest</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.RejectApprovalRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    RejectApprovalRequestFluentHelper rejectApprovalRequest( @Nonnull final String customerReturn );

    /**
     * <p>
     * Creates a fluent helper for the <b>releaseApprovalRequest</b> OData function import.
     * </p>
     *
     * @param customerReturn
     *            Constraints: Not nullable, Maximum length: 11
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CustomerReturn</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>releaseApprovalRequest</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturn.ReleaseApprovalRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReleaseApprovalRequestFluentHelper releaseApprovalRequest( @Nonnull final String customerReturn );

}
