/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ConfirmPutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ConfirmPutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.CreateBatchSplitItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PostGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayAllItemsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemWithSalesQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlowUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliverySrlNmbrByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReverseGoodsReceiptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.SetPutawayQuantityWithBaseQuantityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.batch.CustomerReturnsDeliveryV2ServiceBatch;

/**
 * <p>
 * This synchronous inbound service enables you to read, create, update, and delete customer returns deliveries. It can
 * be consumed in Fiori apps and on other user interfaces.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/80/7fa67fc625453bad4756e4832f42f5/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CUSTOMER_RETURNS_DELIVERY_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CUSTOMER_RETURNS_DELIVERY_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Delivery Processing Integration(SAP_COM_0106)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2TX'>Direct Procurement with Inbound Delivery(2TX)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BD9'>Sell from Stock(BD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDD'>Lean Customer Returns(BDD)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OD9'>Sell from Stock(OD9)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MI'>Delivery Processing without Order Reference(1MI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDA'>Free of Charge Delivery(BDA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BKP'>Customer Returns(BKP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Customer Returns Delivery</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface CustomerReturnsDeliveryV2Service extends BatchService<CustomerReturnsDeliveryV2ServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_CUSTOMER_RETURNS_DELIVERY_SRV;v=0002";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CustomerReturnsDeliveryV2Service withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow
     * ReturnsDeliveryDocFlow} entity using key fields.
     *
     * @param precedingDocument
     *            Preceding Doc.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param precedingDocumentItem
     *            Preceding Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param subsequentDocumentCategory
     *            Subs.Doc.Categ.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow
     *         ReturnsDeliveryDocFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryDocFlowByKeyFluentHelper getReturnsDeliveryDocFlowByKey(
        final String precedingDocument,
        final String precedingDocumentItem,
        final String subsequentDocumentCategory );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow
     * ReturnsDeliveryDocFlow} entity and save it to the S/4HANA system.
     *
     * @param returnsDeliveryDocFlow
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow
     *            ReturnsDeliveryDocFlow} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlow
     *         ReturnsDeliveryDocFlow} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryDocFlowUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryDocFlowUpdateFluentHelper
        updateReturnsDeliveryDocFlow( @Nonnull final ReturnsDeliveryDocFlow returnsDeliveryDocFlow );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     * ReturnsDeliveryHeader} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *         ReturnsDeliveryHeader} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryHeaderFluentHelper getAllReturnsDeliveryHeader();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     * ReturnsDeliveryHeader} entity using key fields.
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *         ReturnsDeliveryHeader} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryHeaderByKeyFluentHelper getReturnsDeliveryHeaderByKey( final String deliveryDocument );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     * ReturnsDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param returnsDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *            ReturnsDeliveryHeader} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *         ReturnsDeliveryHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryHeaderCreateFluentHelper
        createReturnsDeliveryHeader( @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     * ReturnsDeliveryHeader} entity and save it to the S/4HANA system.
     *
     * @param returnsDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *            ReturnsDeliveryHeader} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *         ReturnsDeliveryHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryHeaderUpdateFluentHelper
        updateReturnsDeliveryHeader( @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     * ReturnsDeliveryHeader} entity in the S/4HANA system.
     *
     * @param returnsDeliveryHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *            ReturnsDeliveryHeader} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeader
     *         ReturnsDeliveryHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryHeaderDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryHeaderDeleteFluentHelper
        deleteReturnsDeliveryHeader( @Nonnull final ReturnsDeliveryHeader returnsDeliveryHeader );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     * ReturnsDeliveryItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     *         ReturnsDeliveryItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryItemFluentHelper getAllReturnsDeliveryItem();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     * ReturnsDeliveryItem} entity using key fields.
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     *         ReturnsDeliveryItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryItemByKeyFluentHelper
        getReturnsDeliveryItemByKey( final String deliveryDocument, final String deliveryDocumentItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     * ReturnsDeliveryItem} entity and save it to the S/4HANA system.
     *
     * @param returnsDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     *            ReturnsDeliveryItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     *         ReturnsDeliveryItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryItemUpdateFluentHelper
        updateReturnsDeliveryItem( @Nonnull final ReturnsDeliveryItem returnsDeliveryItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     * ReturnsDeliveryItem} entity in the S/4HANA system.
     *
     * @param returnsDeliveryItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     *            ReturnsDeliveryItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItem
     *         ReturnsDeliveryItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryItemDeleteFluentHelper
        deleteReturnsDeliveryItem( @Nonnull final ReturnsDeliveryItem returnsDeliveryItem );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner
     * ReturnsDeliveryPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Functn
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param sDDocument
     *            SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartner
     *         ReturnsDeliveryPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliveryPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliveryPartnerByKeyFluentHelper
        getReturnsDeliveryPartnerByKey( final String partnerFunction, final String sDDocument );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliverySrlNmbr
     * ReturnsDeliverySrlNmbr} entity using key fields.
     *
     * @param maintenanceItemObjectList
     *            Object list
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliverySrlNmbr
     *         ReturnsDeliverySrlNmbr} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReturnsDeliverySrlNmbrByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReturnsDeliverySrlNmbrByKeyFluentHelper getReturnsDeliverySrlNmbrByKey( final Long maintenanceItemObjectList );

    /**
     * <p>
     * Creates a fluent helper for the <b>ReverseGoodsReceipt</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualGoodsMovementDate
     *            Actual GI Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualGoodsMovementDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ReverseGoodsReceipt</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ReverseGoodsReceiptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ReverseGoodsReceiptFluentHelper reverseGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nonnull final LocalDateTime actualGoodsMovementDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>PostGoodsReceipt</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PostGoodsReceipt</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PostGoodsReceiptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostGoodsReceiptFluentHelper postGoodsReceipt( @Nonnull final String deliveryDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>PostGoodsReceipt</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualGoodsMovementDate
     *            Actual GI Date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualGoodsMovementDate</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PostGoodsReceipt</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PostGoodsReceiptFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PostGoodsReceiptFluentHelper postGoodsReceipt(
        @Nonnull final String deliveryDocument,
        @Nullable final LocalDateTime actualGoodsMovementDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConfirmPutawayAllItems</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConfirmPutawayAllItems</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ConfirmPutawayAllItemsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConfirmPutawayAllItemsFluentHelper confirmPutawayAllItems( @Nonnull final String deliveryDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>ConfirmPutawayOneItem</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>ConfirmPutawayOneItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.ConfirmPutawayOneItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    ConfirmPutawayOneItemFluentHelper
        confirmPutawayOneItem( @Nonnull final String deliveryDocumentItem, @Nonnull final String deliveryDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>PutawayAllItems</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PutawayAllItems</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayAllItemsFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PutawayAllItemsFluentHelper putawayAllItems( @Nonnull final String deliveryDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>PutawayOneItem</b> OData function import.
     * </p>
     *
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PutawayOneItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PutawayOneItemFluentHelper
        putawayOneItem( @Nonnull final String deliveryDocumentItem, @Nonnull final String deliveryDocument );

    /**
     * <p>
     * Creates a fluent helper for the <b>CreateBatchSplitItem</b> OData function import.
     * </p>
     *
     * @param shelfLifeExpirationDate
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ShelfLifeExpirationDate</b>
     *            </p>
     * @param deliveryDocument
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param deliveryQuantityUnit
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     *            </p>
     * @param pickQuantityInSalesUOM
     *            Constraints: Nullable, Precision: 3, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PickQuantityInSalesUOM</b>
     *            </p>
     * @param batch
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Batch</b>
     *            </p>
     * @param manufactureDate
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ManufactureDate</b>
     *            </p>
     * @param actualDeliveryQuantity
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveryQuantity</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Constraints: Not nullable, Maximum length: 6
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>CreateBatchSplitItem</b> OData function import with the
     *         provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.CreateBatchSplitItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    CreateBatchSplitItemFluentHelper createBatchSplitItem(
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String batch,
        @Nonnull final String deliveryDocument,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryQuantityUnit,
        @Nullable final BigDecimal pickQuantityInSalesUOM,
        @Nullable final LocalDateTime manufactureDate,
        @Nullable final LocalDateTime shelfLifeExpirationDate );

    /**
     * <p>
     * Creates a fluent helper for the <b>SetPutawayQuantityWithBaseQuantity</b> OData function import.
     * </p>
     *
     * @param baseUnit
     *            Base Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BaseUnit</b>
     *            </p>
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualDeliveredQtyInBaseUnit
     *            Qty (stckp.unt)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveredQtyInBaseUnit</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>SetPutawayQuantityWithBaseQuantity</b> OData function
     *         import with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.SetPutawayQuantityWithBaseQuantityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    SetPutawayQuantityWithBaseQuantityFluentHelper setPutawayQuantityWithBaseQuantity(
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument,
        @Nonnull final String baseUnit,
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit );

    /**
     * <p>
     * Creates a fluent helper for the <b>PutawayOneItemWithBaseQuantity</b> OData function import.
     * </p>
     *
     * @param baseUnit
     *            Base Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BaseUnit</b>
     *            </p>
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualDeliveredQtyInBaseUnit
     *            Qty (stckp.unt)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveredQtyInBaseUnit</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PutawayOneItemWithBaseQuantity</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemWithBaseQuantityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PutawayOneItemWithBaseQuantityFluentHelper putawayOneItemWithBaseQuantity(
        @Nonnull final String deliveryDocument,
        @Nonnull final String baseUnit,
        @Nonnull final BigDecimal actualDeliveredQtyInBaseUnit,
        @Nonnull final String deliveryDocumentItem );

    /**
     * <p>
     * Creates a fluent helper for the <b>PutawayOneItemWithSalesQuantity</b> OData function import.
     * </p>
     *
     * @param deliveryQuantityUnit
     *            Sales Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryQuantityUnit</b>
     *            </p>
     * @param deliveryDocument
     *            Delivery
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocument</b>
     *            </p>
     * @param actualDeliveryQuantity
     *            Delivery qty
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 3, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActualDeliveryQuantity</b>
     *            </p>
     * @param deliveryDocumentItem
     *            Item
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDocumentItem</b>
     *            </p>
     * @return A fluent helper object that will execute the <b>PutawayOneItemWithSalesQuantity</b> OData function import
     *         with the provided parameters. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.customerreturnsdeliveryv2.PutawayOneItemWithSalesQuantityFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    PutawayOneItemWithSalesQuantityFluentHelper putawayOneItemWithSalesQuantity(
        @Nonnull final BigDecimal actualDeliveryQuantity,
        @Nonnull final String deliveryQuantityUnit,
        @Nonnull final String deliveryDocumentItem,
        @Nonnull final String deliveryDocument );

}
