/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlowByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlowFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.batch.DebitMemoRequestServiceBatch;

/**
 * <p>
 * In every API call, you can make use of the following operations: - You can read entire debit memo requests or only
 * parts of the data, using the provided filters. - You can create debit memo requests. Note that you must use “deep
 * insert” requests (a header plus the following entities: header partner, header pricing element, header text, item,
 * item partner, item pricing element, and item text). You cannot create entities without including any related
 * entities. - For existing debit memo requests, you can create new items. Note that you must use “deep insert” requests
 * (with the following entities: item partner, item pricing element, and item text). You cannot create entities without
 * including any related entities. - For existing debit memo requests, you can update the following entities (that is,
 * you can change the content of their properties): header, header partner, header pricing element, header text, item,
 * item partner, item pricing element, and item text. - For existing debit memo requests, you can delete the header,
 * header partner, header pricing element, header text, item, item partner, item pricing element, and item text. - You
 * can accept or deny approval requests for debit memo requests that cannot be processed without the consent of an
 * approver..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/e7/f50d9ea49d49c7a428da494fce2c44/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_DEBIT_MEMO_REQUEST_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_DEBIT_MEMO_REQUEST_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Debit Memo Request Integration(SAP_COM_0159)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1F1'>Debit Memo Processing(1F1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDQ'>Invoice Correction Process with Debit Memo(BDQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ODQ'>Invoice Correction Process with Debit Memo(ODQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OF1'>Debit Memo Processing(OF1)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Debit Memo Request</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface DebitMemoRequestService extends BatchService<DebitMemoRequestServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_DEBIT_MEMO_REQUEST_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    DebitMemoRequestService withServicePath( @Nonnull final String servicePath );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow
     * DbtMemoReqItmSubsqntProcFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow
     *         DbtMemoReqItmSubsqntProcFlow} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DbtMemoReqItmSubsqntProcFlowFluentHelper getAllDbtMemoReqItmSubsqntProcFlow();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow
     * DbtMemoReqItmSubsqntProcFlow} entity using key fields.
     *
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param debitMemoRequestItem
     *            Preceding Item of an SD Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param debitMemoRequest
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlow
     *         DbtMemoReqItmSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DbtMemoReqItmSubsqntProcFlowByKeyFluentHelper getDbtMemoReqItmSubsqntProcFlowByKey(
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final UUID docRelationshipUUID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     * DebitMemoReqItemPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     *         DebitMemoReqItemPartner} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemPartnerFluentHelper getAllDebitMemoReqItemPartner();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     * DebitMemoReqItemPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param debitMemoRequestItem
     *            Item number of the SD document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param debitMemoRequest
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     *         DebitMemoReqItemPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemPartnerByKeyFluentHelper getDebitMemoReqItemPartnerByKey(
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     * DebitMemoReqItemPartner} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     *            DebitMemoReqItemPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     *         DebitMemoReqItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemPartnerUpdateFluentHelper
        updateDebitMemoReqItemPartner( @Nonnull final DebitMemoReqItemPartner debitMemoReqItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     * DebitMemoReqItemPartner} entity in the S/4HANA system.
     *
     * @param debitMemoReqItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     *            DebitMemoReqItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartner
     *         DebitMemoReqItemPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemPartnerDeleteFluentHelper
        deleteDebitMemoReqItemPartner( @Nonnull final DebitMemoReqItemPartner debitMemoReqItemPartner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     * DebitMemoReqItemPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     *         DebitMemoReqItemPrcgElmnt} entities. This fluent helper allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemPrcgElmntFluentHelper getAllDebitMemoReqItemPrcgElmnt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     * DebitMemoReqItemPrcgElmnt} entity using key fields.
     *
     * @param debitMemoRequestItem
     *            Condition item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param debitMemoRequest
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     *         DebitMemoReqItemPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemPrcgElmntByKeyFluentHelper getDebitMemoReqItemPrcgElmntByKey(
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     * DebitMemoReqItemPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     *            DebitMemoReqItemPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     *         DebitMemoReqItemPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemPrcgElmntUpdateFluentHelper
        updateDebitMemoReqItemPrcgElmnt( @Nonnull final DebitMemoReqItemPrcgElmnt debitMemoReqItemPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     * DebitMemoReqItemPrcgElmnt} entity in the S/4HANA system.
     *
     * @param debitMemoReqItemPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     *            DebitMemoReqItemPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmnt
     *         DebitMemoReqItemPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemPrcgElmntDeleteFluentHelper
        deleteDebitMemoReqItemPrcgElmnt( @Nonnull final DebitMemoReqItemPrcgElmnt debitMemoReqItemPrcgElmnt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     * DebitMemoReqItemText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     *         DebitMemoReqItemText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemTextFluentHelper getAllDebitMemoReqItemText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     * DebitMemoReqItemText} entity using key fields.
     *
     * @param debitMemoRequestItem
     *            Debit Memo Request Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param debitMemoRequest
     *            Debit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     *         DebitMemoReqItemText} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemTextByKeyFluentHelper getDebitMemoReqItemTextByKey(
        final String debitMemoRequest,
        final String debitMemoRequestItem,
        final String language,
        final String longTextID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     * DebitMemoReqItemText} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     *            DebitMemoReqItemText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     *         DebitMemoReqItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemTextUpdateFluentHelper
        updateDebitMemoReqItemText( @Nonnull final DebitMemoReqItemText debitMemoReqItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     * DebitMemoReqItemText} entity in the S/4HANA system.
     *
     * @param debitMemoReqItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     *            DebitMemoReqItemText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemText
     *         DebitMemoReqItemText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqItemTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqItemTextDeleteFluentHelper
        deleteDebitMemoReqItemText( @Nonnull final DebitMemoReqItemText debitMemoReqItemText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     * DebitMemoReqPartner} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     *         DebitMemoReqPartner} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqPartnerFluentHelper getAllDebitMemoReqPartner();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     * DebitMemoReqPartner} entity using key fields.
     *
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param debitMemoRequest
     *            Sales and Distribution Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     *         DebitMemoReqPartner} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqPartnerByKeyFluentHelper
        getDebitMemoReqPartnerByKey( final String debitMemoRequest, final String partnerFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     * DebitMemoReqPartner} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     *            DebitMemoReqPartner} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     *         DebitMemoReqPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqPartnerUpdateFluentHelper
        updateDebitMemoReqPartner( @Nonnull final DebitMemoReqPartner debitMemoReqPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     * DebitMemoReqPartner} entity in the S/4HANA system.
     *
     * @param debitMemoReqPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     *            DebitMemoReqPartner} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartner
     *         DebitMemoReqPartner} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPartnerDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqPartnerDeleteFluentHelper
        deleteDebitMemoReqPartner( @Nonnull final DebitMemoReqPartner debitMemoReqPartner );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     * DebitMemoReqPrcgElmnt} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     *         DebitMemoReqPrcgElmnt} entities. This fluent helper allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqPrcgElmntFluentHelper getAllDebitMemoReqPrcgElmnt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     * DebitMemoReqPrcgElmnt} entity using key fields.
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param debitMemoRequest
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     *         DebitMemoReqPrcgElmnt} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqPrcgElmntByKeyFluentHelper getDebitMemoReqPrcgElmntByKey(
        final String debitMemoRequest,
        final String pricingProcedureStep,
        final String pricingProcedureCounter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     * DebitMemoReqPrcgElmnt} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     *            DebitMemoReqPrcgElmnt} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     *         DebitMemoReqPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqPrcgElmntUpdateFluentHelper
        updateDebitMemoReqPrcgElmnt( @Nonnull final DebitMemoReqPrcgElmnt debitMemoReqPrcgElmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     * DebitMemoReqPrcgElmnt} entity in the S/4HANA system.
     *
     * @param debitMemoReqPrcgElmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     *            DebitMemoReqPrcgElmnt} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmnt
     *         DebitMemoReqPrcgElmnt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqPrcgElmntDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqPrcgElmntDeleteFluentHelper
        deleteDebitMemoReqPrcgElmnt( @Nonnull final DebitMemoReqPrcgElmnt debitMemoReqPrcgElmnt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlow
     * DebitMemoReqSubsqntProcFlow} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlow
     *         DebitMemoReqSubsqntProcFlow} entities. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlowFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqSubsqntProcFlowFluentHelper getAllDebitMemoReqSubsqntProcFlow();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlow
     * DebitMemoReqSubsqntProcFlow} entity using key fields.
     *
     * @param debitMemoRequest
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param subsequentDocument
     *            Subsequent Sales and Distribution Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlow
     *         DebitMemoReqSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqSubsqntProcFlowByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqSubsqntProcFlowByKeyFluentHelper
        getDebitMemoReqSubsqntProcFlowByKey( final String debitMemoRequest, final String subsequentDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     * DebitMemoReqText} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     *         DebitMemoReqText} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqTextFluentHelper getAllDebitMemoReqText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     * DebitMemoReqText} entity using key fields.
     *
     * @param debitMemoRequest
     *            Debit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param longTextID
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     *         DebitMemoReqText} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqTextByKeyFluentHelper
        getDebitMemoReqTextByKey( final String debitMemoRequest, final String language, final String longTextID );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     * DebitMemoReqText} entity and save it to the S/4HANA system.
     *
     * @param debitMemoReqText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     *            DebitMemoReqText} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     *         DebitMemoReqText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqTextUpdateFluentHelper updateDebitMemoReqText( @Nonnull final DebitMemoReqText debitMemoReqText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     * DebitMemoReqText} entity in the S/4HANA system.
     *
     * @param debitMemoReqText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     *            DebitMemoReqText} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqText
     *         DebitMemoReqText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoReqTextDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoReqTextDeleteFluentHelper deleteDebitMemoReqText( @Nonnull final DebitMemoReqText debitMemoReqText );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     * DebitMemoRequest} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *         DebitMemoRequest} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestFluentHelper getAllDebitMemoRequest();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     * DebitMemoRequest} entity using key fields.
     *
     * @param debitMemoRequest
     *            Debit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *         DebitMemoRequest} entity using key fields. This fluent helper allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestByKeyFluentHelper getDebitMemoRequestByKey( final String debitMemoRequest );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     * DebitMemoRequest} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *            DebitMemoRequest} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *         DebitMemoRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestCreateFluentHelper createDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     * DebitMemoRequest} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *            DebitMemoRequest} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *         DebitMemoRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestUpdateFluentHelper updateDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     * DebitMemoRequest} entity in the S/4HANA system.
     *
     * @param debitMemoRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *            DebitMemoRequest} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequest
     *         DebitMemoRequest} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestDeleteFluentHelper deleteDebitMemoRequest( @Nonnull final DebitMemoRequest debitMemoRequest );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     * DebitMemoRequestItem} entities.
     *
     * @return A fluent helper to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *         DebitMemoRequestItem} entities. This fluent helper allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestItemFluentHelper getAllDebitMemoRequestItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     * DebitMemoRequestItem} entity using key fields.
     *
     * @param debitMemoRequestItem
     *            Debit Memo Request Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param debitMemoRequest
     *            Debit Memo Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A fluent helper to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *         DebitMemoRequestItem} entity using key fields. This fluent helper allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemByKeyFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestItemByKeyFluentHelper
        getDebitMemoRequestItemByKey( final String debitMemoRequest, final String debitMemoRequestItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     * DebitMemoRequestItem} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *            DebitMemoRequestItem} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *         DebitMemoRequestItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestItemCreateFluentHelper
        createDebitMemoRequestItem( @Nonnull final DebitMemoRequestItem debitMemoRequestItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     * DebitMemoRequestItem} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *            DebitMemoRequestItem} entity object that will be updated in the S/4HANA system.
     * @return A fluent helper to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *         DebitMemoRequestItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemUpdateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestItemUpdateFluentHelper
        updateDebitMemoRequestItem( @Nonnull final DebitMemoRequestItem debitMemoRequestItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     * DebitMemoRequestItem} entity in the S/4HANA system.
     *
     * @param debitMemoRequestItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *            DebitMemoRequestItem} entity object that will be deleted in the S/4HANA system.
     * @return A fluent helper to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItem
     *         DebitMemoRequestItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequest.DebitMemoRequestItemDeleteFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestItemDeleteFluentHelper
        deleteDebitMemoRequestItem( @Nonnull final DebitMemoRequestItem debitMemoRequestItem );

}
