/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulationCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.batch.DebitMemoRequestSimulateServiceBatch;

/**
 * <p>
 * The API gives you information about debit memo request data, business partners, and pricing elements. The response is
 * provided synchronously. The simulated debit memo request is not saved.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2b/5cfb29c8f14d63b8c8b9781a5c9da0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CE_API_DEBIT_MEMO_REQ_SIMLN_SRV_0001?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CE_API_DEBIT_MEMO_REQ_SIMLN_SRV_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Debit Memo Request Integration(SAP_COM_0159)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1F1'>Debit Memo Processing(1F1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BDQ'>Invoice Correction Process with Debit Memo(BDQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/ODQ'>Invoice Correction Process with Debit Memo(ODQ)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OF1'>Debit Memo Processing(OF1)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Debit Memo Request</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Deprecated
public interface DebitMemoRequestSimulateService extends BatchService<DebitMemoRequestSimulateServiceBatch>
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     *
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata/sap/API_DEBIT_MEMO_REQ_SIMULATION_SRV";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     *
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    DebitMemoRequestSimulateService withServicePath( @Nonnull final String servicePath );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation
     * DebitMemoRequestSimulation} entity and save it to the S/4HANA system.
     *
     * @param debitMemoRequestSimulation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation
     *            DebitMemoRequestSimulation} entity object that will be created in the S/4HANA system.
     * @return A fluent helper to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulation
     *         DebitMemoRequestSimulation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.debitmemorequestsimulate.DebitMemoRequestSimulationCreateFluentHelper#execute
     *         execute} method on the fluent helper object.
     */
    @Nonnull
    DebitMemoRequestSimulationCreateFluentHelper
        createDebitMemoRequestSimulation( @Nonnull final DebitMemoRequestSimulation debitMemoRequestSimulation );

}
