/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityTypeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityTypeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityTypeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.CostCenterActivityTypeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.activitytype.batch.DefaultActivityTypeServiceBatch;

/**
 * <p>
 *
 * This service enables you to read cost center activity type master data in an API call. It is based on the OData
 * protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/07/0e6944acef42388576bf11240e4699/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_COSTCENTERACTIVITYTYPE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_COSTCENTERACTIVITYTYPE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics
 * Cloud(1YB)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Cost Center Activity Type</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultActivityTypeService" )
@Deprecated
public class DefaultActivityTypeService implements ActivityTypeService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link ActivityTypeService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultActivityTypeService()
    {
        servicePath = ActivityTypeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultActivityTypeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultActivityTypeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultActivityTypeService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultActivityTypeServiceBatch batch()
    {
        return new DefaultActivityTypeServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeFluentHelper getAllCostCenterActivityType()
    {
        return new CostCenterActivityTypeFluentHelper(servicePath, "A_CostCenterActivityType");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeByKeyFluentHelper getCostCenterActivityTypeByKey(
        final String controllingArea,
        final String costCtrActivityType,
        final LocalDateTime validityEndDate )
    {
        return new CostCenterActivityTypeByKeyFluentHelper(
            servicePath,
            "A_CostCenterActivityType",
            controllingArea,
            costCtrActivityType,
            validityEndDate);
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeTextFluentHelper getAllCostCenterActivityTypeText()
    {
        return new CostCenterActivityTypeTextFluentHelper(servicePath, "A_CostCenterActivityTypeText");
    }

    @Override
    @Nonnull
    public CostCenterActivityTypeTextByKeyFluentHelper getCostCenterActivityTypeTextByKey(
        final LocalDateTime validityEndDate,
        final String controllingArea,
        final String costCtrActivityType,
        final String language )
    {
        return new CostCenterActivityTypeTextByKeyFluentHelper(
            servicePath,
            "A_CostCenterActivityTypeText",
            validityEndDate,
            controllingArea,
            costCtrActivityType,
            language);
    }

}
