/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.AllowlistByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.AllowlistFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.allowlistintercompanyposting.batch.DefaultAllowlistIntercompanyPostingServiceBatch;

/**
 * <p>
 *
 * The service returns allowlist of sender/receiver company code combinations for intercompany postings. Filters,
 * sorting, and other OData operations can be used..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2f/23aff8bdcc449ebd2cba390d360527/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_FCO_ICO_RESTRICTION?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_FCO_ICO_RESTRICTION</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Block Intercompany Postings Integration(SAP_COM_0745)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J54'>Overhead Cost Accounting(J54)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O54'>Overhead Cost Accounting(O54)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Company Code</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultAllowlistIntercompanyPostingService" )
@Deprecated
public class DefaultAllowlistIntercompanyPostingService implements AllowlistIntercompanyPostingService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link AllowlistIntercompanyPostingService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultAllowlistIntercompanyPostingService()
    {
        servicePath = AllowlistIntercompanyPostingService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultAllowlistIntercompanyPostingService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultAllowlistIntercompanyPostingService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultAllowlistIntercompanyPostingService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultAllowlistIntercompanyPostingServiceBatch batch()
    {
        return new DefaultAllowlistIntercompanyPostingServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public AllowlistFluentHelper getAllAllowlist()
    {
        return new AllowlistFluentHelper(servicePath, "Allowlist");
    }

    @Override
    @Nonnull
    public
        AllowlistByKeyFluentHelper
        getAllowlistByKey( final String senderCompanyCode, final String receiverCompanyCode )
    {
        return new AllowlistByKeyFluentHelper(servicePath, "Allowlist", senderCompanyCode, receiverCompanyCode);
    }

}
