/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetailByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.BankDetailFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankdetail.batch.DefaultBankDetailServiceBatch;

/**
 * <p>
 *
 * The service contains bank country, bank key, bank name, SWIFT code, bank group, bank number, region, street name,
 * city, and branch. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/34/c80bfa05f740bca57c17b941bc28bf/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BANKDETAIL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BANKDETAIL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Bank Integration(SAP_COM_0127), Employee Central Financial Master Data Integration(SAP_COM_0441)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J77'>Advanced Bank Account Management(J77)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/O77'>Advanced Bank Account Management(O77)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/JB1'>Core HR with SAP SuccessFactors Employee Central(JB1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4AJ'>Financial Master Data for SAP SuccessFactors Employee
 * Central(4AJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bank</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBankDetailService" )
@Deprecated
public class DefaultBankDetailService implements BankDetailService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BankDetailService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBankDetailService()
    {
        servicePath = BankDetailService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBankDetailService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBankDetailService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBankDetailService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBankDetailServiceBatch batch()
    {
        return new DefaultBankDetailServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BankDetailFluentHelper getAllBankDetail()
    {
        return new BankDetailFluentHelper(servicePath, "A_BankDetail");
    }

    @Override
    @Nonnull
    public BankDetailByKeyFluentHelper getBankDetailByKey( final String bankCountry, final String bankInternalID )
    {
        return new BankDetailByKeyFluentHelper(servicePath, "A_BankDetail", bankCountry, bankInternalID);
    }

}
