/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatementByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankReconciliationStatementFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.BankStatementItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.JournalEntryItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.StartReconcileFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bankreconciliationstatement.batch.DefaultBankReconciliationStatementServiceBatch;

/**
 * <p>
 *
 * The service contains bank reconciliation items, bank reconciliation statements, journal entry items and bank
 * statement items. The bank reconciliation items provide the G/L account balance, bank account balance and
 * reconciliation status of all house bank accounts. The “StartReconcile” operation can start automatic reconciliation
 * and generate bank reconciliation statement in the backend. If there are any issues when the bank reconciliation
 * statement is created, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c5/b27deb56a04ff98e944a737ea0c890/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CN_BANK_RECONCILIAITON_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CN_BANK_RECONCILIAITON_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Bank Reconciliation Integration(SAP_COM_0388)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1EG'>Bank Integration with File Interface(1EG)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bank Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBankReconciliationStatementService" )
@Deprecated
public class DefaultBankReconciliationStatementService implements BankReconciliationStatementService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BankReconciliationStatementService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBankReconciliationStatementService()
    {
        servicePath = BankReconciliationStatementService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBankReconciliationStatementService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBankReconciliationStatementService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBankReconciliationStatementService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBankReconciliationStatementServiceBatch batch()
    {
        return new DefaultBankReconciliationStatementServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BankStatementItemFluentHelper getAllBankStatementItem()
    {
        return new BankStatementItemFluentHelper(servicePath, "BankStatementItemSet");
    }

    @Override
    @Nonnull
    public BankStatementItemByKeyFluentHelper getBankStatementItemByKey(
        final String companyCode,
        final String houseBank,
        final String houseBankAccount,
        final LocalDateTime bankReconciliationDate,
        final String bankStatementShortID,
        final String bankStatementItem )
    {
        return new BankStatementItemByKeyFluentHelper(
            servicePath,
            "BankStatementItemSet",
            companyCode,
            houseBank,
            houseBankAccount,
            bankReconciliationDate,
            bankStatementShortID,
            bankStatementItem);
    }

    @Override
    @Nonnull
    public BankReconciliationItemFluentHelper getAllBankReconciliationItem()
    {
        return new BankReconciliationItemFluentHelper(servicePath, "BankReconciliationItemSet");
    }

    @Override
    @Nonnull
    public BankReconciliationItemByKeyFluentHelper getBankReconciliationItemByKey(
        final String companyCode,
        final String houseBank,
        final String houseBankAccount,
        final LocalDateTime bankReconciliationDate )
    {
        return new BankReconciliationItemByKeyFluentHelper(
            servicePath,
            "BankReconciliationItemSet",
            companyCode,
            houseBank,
            houseBankAccount,
            bankReconciliationDate);
    }

    @Override
    @Nonnull
    public BankReconciliationStatementFluentHelper getAllBankReconciliationStatement()
    {
        return new BankReconciliationStatementFluentHelper(servicePath, "BankReconciliationStatementSet");
    }

    @Override
    @Nonnull
    public BankReconciliationStatementByKeyFluentHelper getBankReconciliationStatementByKey(
        final String companyCode,
        final String houseBank,
        final String houseBankAccount,
        final LocalDateTime bankReconciliationDate )
    {
        return new BankReconciliationStatementByKeyFluentHelper(
            servicePath,
            "BankReconciliationStatementSet",
            companyCode,
            houseBank,
            houseBankAccount,
            bankReconciliationDate);
    }

    @Override
    @Nonnull
    public JournalEntryItemFluentHelper getAllJournalEntryItem()
    {
        return new JournalEntryItemFluentHelper(servicePath, "JournalEntryItemSet");
    }

    @Override
    @Nonnull
    public JournalEntryItemByKeyFluentHelper getJournalEntryItemByKey(
        final String companyCode,
        final String houseBank,
        final String houseBankAccount,
        final LocalDateTime bankReconciliationDate,
        final String fiscalYear,
        final String accountingDocument,
        final String accountingDocumentItem )
    {
        return new JournalEntryItemByKeyFluentHelper(
            servicePath,
            "JournalEntryItemSet",
            companyCode,
            houseBank,
            houseBankAccount,
            bankReconciliationDate,
            fiscalYear,
            accountingDocument,
            accountingDocumentItem);
    }

    @Override
    @Nonnull
    public StartReconcileFluentHelper startReconcile(
        @Nonnull final String companyCode,
        @Nonnull final String houseBank,
        @Nonnull final String houseBankAccount,
        @Nonnull final LocalDateTime bankReconciliationDate )
    {
        return new StartReconcileFluentHelper(
            servicePath,
            companyCode,
            houseBank,
            houseBankAccount,
            bankReconciliationDate);
    }

}
