/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.ZonedDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.CalculateAvailabilityTimeseriesFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.DetermineAvailabilityAtFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.DetermineAvailabilityOfFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.basicproductavailabilityinformation.batch.DefaultBasicProductAvailabilityInformationServiceBatch;

/**
 * <p>
 * The availability information calculated by the service could, for example, be used by webshops to display up-to-date
 * product availability information to increase the chance of customers placing orders or by suppliers to inform their
 * customers when required products will be available and in which quantities.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/ba/15d698dd474a57ad340f9acff13b99/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_PRODUCT_AVAILY_INFO_BASIC?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_PRODUCT_AVAILY_INFO_BASIC</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Availability Information Integration(SAP_COM_0115)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JW'>Advanced Available-to-Promise Processing(1JW)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2LN'>Basic Available-to-Promise Processing(2LN)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Available To Promise</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBasicProductAvailabilityInformationService" )
@Deprecated
public class DefaultBasicProductAvailabilityInformationService implements BasicProductAvailabilityInformationService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BasicProductAvailabilityInformationService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     *
     */
    public DefaultBasicProductAvailabilityInformationService()
    {
        servicePath = BasicProductAvailabilityInformationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBasicProductAvailabilityInformationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBasicProductAvailabilityInformationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBasicProductAvailabilityInformationService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBasicProductAvailabilityInformationServiceBatch batch()
    {
        return new DefaultBasicProductAvailabilityInformationServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DetermineAvailabilityAtFluentHelper determineAvailabilityAt(
        @Nonnull final String supplyingPlant,
        @Nonnull final String material,
        @Nonnull final String aTPCheckingRule,
        @Nonnull final ZonedDateTime requestedUTCDateTime )
    {
        return new DetermineAvailabilityAtFluentHelper(
            servicePath,
            supplyingPlant,
            material,
            aTPCheckingRule,
            requestedUTCDateTime);
    }

    @Override
    @Nonnull
    public DetermineAvailabilityOfFluentHelper determineAvailabilityOf(
        @Nonnull final BigDecimal requestedQuantityInBaseUnit,
        @Nonnull final String material,
        @Nonnull final String supplyingPlant,
        @Nonnull final String aTPCheckingRule )
    {
        return new DetermineAvailabilityOfFluentHelper(
            servicePath,
            requestedQuantityInBaseUnit,
            material,
            supplyingPlant,
            aTPCheckingRule);
    }

    @Override
    @Nonnull
    public CalculateAvailabilityTimeseriesFluentHelper calculateAvailabilityTimeseries(
        @Nonnull final String aTPCheckingRule,
        @Nonnull final String material,
        @Nonnull final String supplyingPlant )
    {
        return new CalculateAvailabilityTimeseriesFluentHelper(servicePath, aTPCheckingRule, material, supplyingPlant);
    }

}
