/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.Batch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCharcValueUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchClassFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchPlantUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.BatchUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.batch.batch.DefaultBatchServiceBatch;

/**
 * <p>
 *
 * This synchronous inbound API enables you to read, create and change batches. Additionally, it is possible to retrieve
 * and to edit the related classification data. The service is based on the OData protocol, and can be consumed by
 * external systems and user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/48/b3c2ac60154137bb1d6411c7047e16/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BATCH_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BATCH_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Batch Management OData Integration(SAP_COM_0337), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BLF'>Batch Management(BLF)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Batch</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBatchService" )
@Deprecated
public class DefaultBatchService implements BatchService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BatchService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBatchService()
    {
        servicePath = BatchService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBatchService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBatchService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBatchService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBatchServiceBatch batch()
    {
        return new DefaultBatchServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BatchFluentHelper getAllBatch()
    {
        return new BatchFluentHelper(servicePath, "Batch");
    }

    @Override
    @Nonnull
    public
        BatchByKeyFluentHelper
        getBatchByKey( final String material, final String batchIdentifyingPlant, final String batch )
    {
        return new BatchByKeyFluentHelper(servicePath, "Batch", material, batchIdentifyingPlant, batch);
    }

    @Override
    @Nonnull
    public BatchCreateFluentHelper createBatch( @Nonnull final Batch batch )
    {
        return new BatchCreateFluentHelper(servicePath, batch, "Batch");
    }

    @Override
    @Nonnull
    public BatchUpdateFluentHelper updateBatch( @Nonnull final Batch batch )
    {
        return new BatchUpdateFluentHelper(servicePath, batch, "Batch");
    }

    @Override
    @Nonnull
    public BatchCharcFluentHelper getAllBatchCharc()
    {
        return new BatchCharcFluentHelper(servicePath, "BatchCharc");
    }

    @Override
    @Nonnull
    public BatchCharcByKeyFluentHelper getBatchCharcByKey(
        final String material,
        final String batchIdentifyingPlant,
        final String batch,
        final String charcInternalID )
    {
        return new BatchCharcByKeyFluentHelper(
            servicePath,
            "BatchCharc",
            material,
            batchIdentifyingPlant,
            batch,
            charcInternalID);
    }

    @Override
    @Nonnull
    public BatchCharcCreateFluentHelper createBatchCharc( @Nonnull final BatchCharc batchCharc )
    {
        return new BatchCharcCreateFluentHelper(servicePath, batchCharc, "BatchCharc");
    }

    @Override
    @Nonnull
    public BatchCharcValueFluentHelper getAllBatchCharcValue()
    {
        return new BatchCharcValueFluentHelper(servicePath, "BatchCharcValue");
    }

    @Override
    @Nonnull
    public BatchCharcValueByKeyFluentHelper getBatchCharcValueByKey(
        final String material,
        final String batchIdentifyingPlant,
        final String batch,
        final String charcInternalID,
        final String charcValuePositionNumber )
    {
        return new BatchCharcValueByKeyFluentHelper(
            servicePath,
            "BatchCharcValue",
            material,
            batchIdentifyingPlant,
            batch,
            charcInternalID,
            charcValuePositionNumber);
    }

    @Override
    @Nonnull
    public BatchCharcValueCreateFluentHelper createBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue )
    {
        return new BatchCharcValueCreateFluentHelper(servicePath, batchCharcValue, "BatchCharcValue");
    }

    @Override
    @Nonnull
    public BatchCharcValueUpdateFluentHelper updateBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue )
    {
        return new BatchCharcValueUpdateFluentHelper(servicePath, batchCharcValue, "BatchCharcValue");
    }

    @Override
    @Nonnull
    public BatchCharcValueDeleteFluentHelper deleteBatchCharcValue( @Nonnull final BatchCharcValue batchCharcValue )
    {
        return new BatchCharcValueDeleteFluentHelper(servicePath, batchCharcValue, "BatchCharcValue");
    }

    @Override
    @Nonnull
    public BatchClassFluentHelper getAllBatchClass()
    {
        return new BatchClassFluentHelper(servicePath, "BatchClass");
    }

    @Override
    @Nonnull
    public
        BatchClassByKeyFluentHelper
        getBatchClassByKey( final String material, final String batchIdentifyingPlant, final String batch )
    {
        return new BatchClassByKeyFluentHelper(servicePath, "BatchClass", material, batchIdentifyingPlant, batch);
    }

    @Override
    @Nonnull
    public BatchClassCreateFluentHelper createBatchClass( @Nonnull final BatchClass batchClass )
    {
        return new BatchClassCreateFluentHelper(servicePath, batchClass, "BatchClass");
    }

    @Override
    @Nonnull
    public BatchClassDeleteFluentHelper deleteBatchClass( @Nonnull final BatchClass batchClass )
    {
        return new BatchClassDeleteFluentHelper(servicePath, batchClass, "BatchClass");
    }

    @Override
    @Nonnull
    public BatchPlantFluentHelper getAllBatchPlant()
    {
        return new BatchPlantFluentHelper(servicePath, "BatchPlant");
    }

    @Override
    @Nonnull
    public
        BatchPlantByKeyFluentHelper
        getBatchPlantByKey( final String material, final String batch, final String plant )
    {
        return new BatchPlantByKeyFluentHelper(servicePath, "BatchPlant", material, batch, plant);
    }

    @Override
    @Nonnull
    public BatchPlantUpdateFluentHelper updateBatchPlant( @Nonnull final BatchPlant batchPlant )
    {
        return new BatchPlantUpdateFluentHelper(servicePath, batchPlant, "BatchPlant");
    }

    @Override
    @Nonnull
    public BatchTextFluentHelper getAllBatchText()
    {
        return new BatchTextFluentHelper(servicePath, "BatchText");
    }

    @Override
    @Nonnull
    public BatchTextByKeyFluentHelper getBatchTextByKey(
        final String material,
        final String batchIdentifyingPlant,
        final String batch,
        final String language )
    {
        return new BatchTextByKeyFluentHelper(
            servicePath,
            "BatchText",
            material,
            batchIdentifyingPlant,
            batch,
            language);
    }

    @Override
    @Nonnull
    public BatchTextUpdateFluentHelper updateBatchText( @Nonnull final BatchText batchText )
    {
        return new BatchTextUpdateFluentHelper(servicePath, batchText, "BatchText");
    }

    @Override
    @Nonnull
    public BatchTextDeleteFluentHelper deleteBatchText( @Nonnull final BatchText batchText )
    {
        return new BatchTextDeleteFluentHelper(servicePath, batchText, "BatchText");
    }

}
