/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.BOMComparisonFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResultByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResultFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.batch.DefaultBillOfMaterialComparisonServiceBatch;

/**
 * <p>
 *
 * This service enables you to compare two bills of material (BOMs) by comparing their BOM item attributes..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/48/9007ed0e07467bb9efbf1f5616b36e/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILLOFMATERIAL_COMPARISON_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILLOFMATERIAL_COMPARISON_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBillOfMaterialComparisonService" )
@Deprecated
public class DefaultBillOfMaterialComparisonService implements BillOfMaterialComparisonService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BillOfMaterialComparisonService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBillOfMaterialComparisonService()
    {
        servicePath = BillOfMaterialComparisonService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBillOfMaterialComparisonService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBillOfMaterialComparisonService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBillOfMaterialComparisonService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBillOfMaterialComparisonServiceBatch batch()
    {
        return new DefaultBillOfMaterialComparisonServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ComparisonResultFluentHelper getAllComparisonResult()
    {
        return new ComparisonResultFluentHelper(servicePath, "ComparisonResultSet");
    }

    @Override
    @Nonnull
    public ComparisonResultByKeyFluentHelper getComparisonResultByKey( final byte[] bOMComparisonUUID )
    {
        return new ComparisonResultByKeyFluentHelper(servicePath, "ComparisonResultSet", bOMComparisonUUID);
    }

    @Override
    @Nonnull
    public BOMComparisonFluentHelper bOMComparison(
        @Nonnull final LocalDateTime bOMValidityDateSecondary,
        @Nonnull final String bOMVersionSecondary,
        @Nonnull final String bOMVariantSecondary,
        @Nonnull final String bOMVariantUsageSecondary,
        @Nonnull final String plantSecondary,
        @Nonnull final String materialSecondary,
        @Nonnull final String changeNumberPrimary,
        @Nonnull final LocalDateTime bOMValidityDatePrimary,
        @Nonnull final String bOMVersionPrimary,
        @Nonnull final String bOMVariantPrimary,
        @Nonnull final String bOMVariantUsagePrimary,
        @Nonnull final String plantPrimary,
        @Nonnull final String materialPrimary,
        @Nonnull final Boolean isBOMItemNumber,
        @Nonnull final Boolean isBOMItemDescription,
        @Nonnull final Boolean isBOMItemCategory,
        @Nonnull final String changeNumberSecondary,
        @Nonnull final Boolean isBOMItemQuantity )
    {
        return new BOMComparisonFluentHelper(
            servicePath,
            bOMValidityDateSecondary,
            bOMVersionSecondary,
            bOMVariantSecondary,
            bOMVariantUsageSecondary,
            plantSecondary,
            materialSecondary,
            changeNumberPrimary,
            bOMValidityDatePrimary,
            bOMVersionPrimary,
            bOMVariantPrimary,
            bOMVariantUsagePrimary,
            plantPrimary,
            materialPrimary,
            isBOMItemNumber,
            isBOMItemDescription,
            isBOMItemCategory,
            changeNumberSecondary,
            isBOMItemQuantity);
    }

}
