/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsageTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.ExplodeBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.ReleaseVersionBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.batch.DefaultBillOfMaterialsServiceBatch;

/**
 * <p>
 *
 * The service enables you to read, create, and update bills of material with and without version. The service is based
 * on the OData protocol and can be consumed in SAP Fiori apps and on other user interfaces.
 *
 * The service contains either no header, one header, or multiple headers for the specified material and none or more
 * items for each header. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2208.latest/EN/15/3a455816dda007e10000000a441470/frameset.htm?profile=20020833'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILL_OF_MATERIAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILL_OF_MATERIAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2208</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions Management(1NR)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master Management(1R3)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated as of release 2105 (May 2021). Please use the
 *             odata generator to generate the VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBillOfMaterialsService" )
@Deprecated
public class DefaultBillOfMaterialsService implements BillOfMaterialsService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BillOfMaterialsService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBillOfMaterialsService()
    {
        servicePath = BillOfMaterialsService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBillOfMaterialsService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBillOfMaterialsService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBillOfMaterialsService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBillOfMaterialsServiceBatch batch()
    {
        return new DefaultBillOfMaterialsServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BillOfMaterialFluentHelper getAllBillOfMaterial()
    {
        return new BillOfMaterialFluentHelper(servicePath, "A_BillOfMaterial");
    }

    @Override
    @Nonnull
    public BillOfMaterialByKeyFluentHelper getBillOfMaterialByKey( final UUID billOfMaterialHeaderUUID )
    {
        return new BillOfMaterialByKeyFluentHelper(servicePath, "A_BillOfMaterial", billOfMaterialHeaderUUID);
    }

    @Override
    @Nonnull
    public BillOfMaterialCreateFluentHelper createBillOfMaterial( @Nonnull final BillOfMaterial billOfMaterial )
    {
        return new BillOfMaterialCreateFluentHelper(servicePath, billOfMaterial, "A_BillOfMaterial");
    }

    @Override
    @Nonnull
    public BillOfMaterialUpdateFluentHelper updateBillOfMaterial( @Nonnull final BillOfMaterial billOfMaterial )
    {
        return new BillOfMaterialUpdateFluentHelper(servicePath, billOfMaterial, "A_BillOfMaterial");
    }

    @Override
    @Nonnull
    public BillOfMaterialItemFluentHelper getAllBillOfMaterialItem()
    {
        return new BillOfMaterialItemFluentHelper(servicePath, "A_BillOfMaterialItem");
    }

    @Override
    @Nonnull
    public BillOfMaterialItemByKeyFluentHelper getBillOfMaterialItemByKey( final UUID billOfMaterialItemUUID )
    {
        return new BillOfMaterialItemByKeyFluentHelper(servicePath, "A_BillOfMaterialItem", billOfMaterialItemUUID);
    }

    @Override
    @Nonnull
    public BillOfMaterialItemCreateFluentHelper createBillOfMaterialItem(
        @Nonnull final BillOfMaterialItem billOfMaterialItem )
    {
        return new BillOfMaterialItemCreateFluentHelper(servicePath, billOfMaterialItem, "A_BillOfMaterialItem");
    }

    @Override
    @Nonnull
    public BillOfMaterialItemUpdateFluentHelper updateBillOfMaterialItem(
        @Nonnull final BillOfMaterialItem billOfMaterialItem )
    {
        return new BillOfMaterialItemUpdateFluentHelper(servicePath, billOfMaterialItem, "A_BillOfMaterialItem");
    }

    @Override
    @Nonnull
    public BillOfMaterialUsageFluentHelper getAllBillOfMaterialUsage()
    {
        return new BillOfMaterialUsageFluentHelper(servicePath, "A_BillOfMaterialUsage");
    }

    @Override
    @Nonnull
    public BillOfMaterialUsageByKeyFluentHelper getBillOfMaterialUsageByKey( final String billOfMaterialVariantUsage )
    {
        return new BillOfMaterialUsageByKeyFluentHelper(
            servicePath,
            "A_BillOfMaterialUsage",
            billOfMaterialVariantUsage);
    }

    @Override
    @Nonnull
    public BillOfMaterialUsageTextFluentHelper getAllBillOfMaterialUsageText()
    {
        return new BillOfMaterialUsageTextFluentHelper(servicePath, "A_BillOfMaterialUsageText");
    }

    @Override
    @Nonnull
    public
        BillOfMaterialUsageTextByKeyFluentHelper
        getBillOfMaterialUsageTextByKey( final String language, final String billOfMaterialVariantUsage )
    {
        return new BillOfMaterialUsageTextByKeyFluentHelper(
            servicePath,
            "A_BillOfMaterialUsageText",
            language,
            billOfMaterialVariantUsage);
    }

    @Override
    @Nonnull
    public BOMItemCategoryFluentHelper getAllBOMItemCategory()
    {
        return new BOMItemCategoryFluentHelper(servicePath, "A_BOMItemCategory");
    }

    @Override
    @Nonnull
    public BOMItemCategoryByKeyFluentHelper getBOMItemCategoryByKey( final String billOfMaterialItemCategory )
    {
        return new BOMItemCategoryByKeyFluentHelper(servicePath, "A_BOMItemCategory", billOfMaterialItemCategory);
    }

    @Override
    @Nonnull
    public BOMItemCategoryTextFluentHelper getAllBOMItemCategoryText()
    {
        return new BOMItemCategoryTextFluentHelper(servicePath, "A_BOMItemCategoryText");
    }

    @Override
    @Nonnull
    public
        BOMItemCategoryTextByKeyFluentHelper
        getBOMItemCategoryTextByKey( final String language, final String billOfMaterialItemCategory )
    {
        return new BOMItemCategoryTextByKeyFluentHelper(
            servicePath,
            "A_BOMItemCategoryText",
            language,
            billOfMaterialItemCategory);
    }

    @Override
    @Nonnull
    public ExplodeBOMFluentHelper explodeBOM(
        @Nonnull final UUID billOfMaterialHeaderUUID,
        @Nullable final String material,
        @Nullable final String plant,
        @Nullable final String billOfMaterialVariant,
        @Nullable final String bOMExplosionApplication,
        @Nullable final BigDecimal requiredQuantity,
        @Nullable final String engineeringChangeDocument,
        @Nullable final Boolean bOMExplosionIsLimited,
        @Nullable final String bOMItmQtyIsScrapRelevant,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String bOMExplosionAssembly,
        @Nullable final LocalDateTime bOMExplosionDate,
        @Nullable final BigDecimal bOMExplosionLevel,
        @Nullable final Boolean bOMExplosionIsMultilevel,
        @Nullable final String materialProvisionFltrType,
        @Nullable final String sparePartFltrType )
    {
        return new ExplodeBOMFluentHelper(
            servicePath,
            billOfMaterialHeaderUUID,
            material,
            plant,
            billOfMaterialVariant,
            bOMExplosionApplication,
            requiredQuantity,
            engineeringChangeDocument,
            bOMExplosionIsLimited,
            bOMItmQtyIsScrapRelevant,
            billOfMaterialItemCategory,
            bOMExplosionAssembly,
            bOMExplosionDate,
            bOMExplosionLevel,
            bOMExplosionIsMultilevel,
            materialProvisionFltrType,
            sparePartFltrType);
    }

    @Override
    @Nonnull
    public ReleaseVersionBOMFluentHelper releaseVersionBOM(
        @Nonnull final UUID billOfMaterialHeaderUUID,
        @Nullable final String stlnr,
        @Nullable final String stlty,
        @Nullable final String stlal,
        @Nullable final String bomVersn,
        @Nullable final String versnst,
        @Nullable final Boolean versnlastind )
    {
        return new ReleaseVersionBOMFluentHelper(
            servicePath,
            billOfMaterialHeaderUUID,
            stlnr,
            stlty,
            stlal,
            bomVersn,
            versnst,
            versnlastind);
    }

}
