/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BOMItemCategoryTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ConvertItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.DeleteBOMHeaderWithECNFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.DeleteBOMItemWithECNFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ExplodeBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignmentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.ReleaseVersionBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.UpdateBOMItemWithECNFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.batch.DefaultBillOfMaterialsV2ServiceBatch;

/**
 * <p>
 *
 * The service enables you to read, create, update, and delete bills of material with and without version. The service
 * is based on the OData protocol and can be consumed in SAP Fiori apps and on other user interfaces.
 *
 * The service contains either no header, one header, or multiple headers for the specified material and none or more
 * items for each header..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8a/8b08aab6cd47f4a3e35e8bd8d86ca2/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILL_OF_MATERIAL_SRV_0002?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILL_OF_MATERIAL_SRV_0002</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>2.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBillOfMaterialsV2Service" )
@Deprecated
public class DefaultBillOfMaterialsV2Service implements BillOfMaterialsV2Service
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BillOfMaterialsV2Service#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBillOfMaterialsV2Service()
    {
        servicePath = BillOfMaterialsV2Service.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBillOfMaterialsV2Service( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBillOfMaterialsV2Service withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBillOfMaterialsV2Service(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBillOfMaterialsV2ServiceBatch batch()
    {
        return new DefaultBillOfMaterialsV2ServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public MaterialBOMItemFluentHelper getAllMaterialBOMItem()
    {
        return new MaterialBOMItemFluentHelper(servicePath, "MaterialBOMItem");
    }

    @Override
    @Nonnull
    public MaterialBOMItemByKeyFluentHelper getMaterialBOMItemByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String billOfMaterialItemNodeNumber,
        final String headerChangeDocument,
        final String material,
        final String plant )
    {
        return new MaterialBOMItemByKeyFluentHelper(
            servicePath,
            "MaterialBOMItem",
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            billOfMaterialItemNodeNumber,
            headerChangeDocument,
            material,
            plant);
    }

    @Override
    @Nonnull
    public MaterialBOMItemCreateFluentHelper createMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem )
    {
        return new MaterialBOMItemCreateFluentHelper(servicePath, materialBOMItem, "MaterialBOMItem");
    }

    @Override
    @Nonnull
    public MaterialBOMItemUpdateFluentHelper updateMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem )
    {
        return new MaterialBOMItemUpdateFluentHelper(servicePath, materialBOMItem, "MaterialBOMItem");
    }

    @Override
    @Nonnull
    public MaterialBOMItemDeleteFluentHelper deleteMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem )
    {
        return new MaterialBOMItemDeleteFluentHelper(servicePath, materialBOMItem, "MaterialBOMItem");
    }

    @Override
    @Nonnull
    public MaterialBOMSubItemFluentHelper getAllMaterialBOMSubItem()
    {
        return new MaterialBOMSubItemFluentHelper(servicePath, "MaterialBOMSubItem");
    }

    @Override
    @Nonnull
    public MaterialBOMSubItemByKeyFluentHelper getMaterialBOMSubItemByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String billOfMaterialItemNodeNumber,
        final String headerChangeDocument,
        final String material,
        final String plant,
        final String bOMItemInternalChangeCount,
        final String bOMSubItemNumberValue )
    {
        return new MaterialBOMSubItemByKeyFluentHelper(
            servicePath,
            "MaterialBOMSubItem",
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            billOfMaterialItemNodeNumber,
            headerChangeDocument,
            material,
            plant,
            bOMItemInternalChangeCount,
            bOMSubItemNumberValue);
    }

    @Override
    @Nonnull
    public MaterialBOMSubItemCreateFluentHelper createMaterialBOMSubItem(
        @Nonnull final MaterialBOMSubItem materialBOMSubItem )
    {
        return new MaterialBOMSubItemCreateFluentHelper(servicePath, materialBOMSubItem, "MaterialBOMSubItem");
    }

    @Override
    @Nonnull
    public MaterialBOMSubItemUpdateFluentHelper updateMaterialBOMSubItem(
        @Nonnull final MaterialBOMSubItem materialBOMSubItem )
    {
        return new MaterialBOMSubItemUpdateFluentHelper(servicePath, materialBOMSubItem, "MaterialBOMSubItem");
    }

    @Override
    @Nonnull
    public MaterialBOMSubItemDeleteFluentHelper deleteMaterialBOMSubItem(
        @Nonnull final MaterialBOMSubItem materialBOMSubItem )
    {
        return new MaterialBOMSubItemDeleteFluentHelper(servicePath, materialBOMSubItem, "MaterialBOMSubItem");
    }

    @Override
    @Nonnull
    public BillOfMaterialUsageFluentHelper getAllBillOfMaterialUsage()
    {
        return new BillOfMaterialUsageFluentHelper(servicePath, "A_BillOfMaterialUsage");
    }

    @Override
    @Nonnull
    public BillOfMaterialUsageByKeyFluentHelper getBillOfMaterialUsageByKey( final String billOfMaterialVariantUsage )
    {
        return new BillOfMaterialUsageByKeyFluentHelper(
            servicePath,
            "A_BillOfMaterialUsage",
            billOfMaterialVariantUsage);
    }

    @Override
    @Nonnull
    public BillOfMaterialUsageTextFluentHelper getAllBillOfMaterialUsageText()
    {
        return new BillOfMaterialUsageTextFluentHelper(servicePath, "A_BillOfMaterialUsageText");
    }

    @Override
    @Nonnull
    public
        BillOfMaterialUsageTextByKeyFluentHelper
        getBillOfMaterialUsageTextByKey( final String language, final String billOfMaterialVariantUsage )
    {
        return new BillOfMaterialUsageTextByKeyFluentHelper(
            servicePath,
            "A_BillOfMaterialUsageText",
            language,
            billOfMaterialVariantUsage);
    }

    @Override
    @Nonnull
    public MaterialBOMFluentHelper getAllMaterialBOM()
    {
        return new MaterialBOMFluentHelper(servicePath, "MaterialBOM");
    }

    @Override
    @Nonnull
    public MaterialBOMByKeyFluentHelper getMaterialBOMByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String engineeringChangeDocument,
        final String material,
        final String plant )
    {
        return new MaterialBOMByKeyFluentHelper(
            servicePath,
            "MaterialBOM",
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            engineeringChangeDocument,
            material,
            plant);
    }

    @Override
    @Nonnull
    public MaterialBOMCreateFluentHelper createMaterialBOM( @Nonnull final MaterialBOM materialBOM )
    {
        return new MaterialBOMCreateFluentHelper(servicePath, materialBOM, "MaterialBOM");
    }

    @Override
    @Nonnull
    public MaterialBOMUpdateFluentHelper updateMaterialBOM( @Nonnull final MaterialBOM materialBOM )
    {
        return new MaterialBOMUpdateFluentHelper(servicePath, materialBOM, "MaterialBOM");
    }

    @Override
    @Nonnull
    public MaterialBOMDeleteFluentHelper deleteMaterialBOM( @Nonnull final MaterialBOM materialBOM )
    {
        return new MaterialBOMDeleteFluentHelper(servicePath, materialBOM, "MaterialBOM");
    }

    @Override
    @Nonnull
    public BOMItemCategoryFluentHelper getAllBOMItemCategory()
    {
        return new BOMItemCategoryFluentHelper(servicePath, "A_BOMItemCategory");
    }

    @Override
    @Nonnull
    public BOMItemCategoryByKeyFluentHelper getBOMItemCategoryByKey( final String billOfMaterialItemCategory )
    {
        return new BOMItemCategoryByKeyFluentHelper(servicePath, "A_BOMItemCategory", billOfMaterialItemCategory);
    }

    @Override
    @Nonnull
    public BOMItemCategoryTextFluentHelper getAllBOMItemCategoryText()
    {
        return new BOMItemCategoryTextFluentHelper(servicePath, "A_BOMItemCategoryText");
    }

    @Override
    @Nonnull
    public
        BOMItemCategoryTextByKeyFluentHelper
        getBOMItemCategoryTextByKey( final String language, final String billOfMaterialItemCategory )
    {
        return new BOMItemCategoryTextByKeyFluentHelper(
            servicePath,
            "A_BOMItemCategoryText",
            language,
            billOfMaterialItemCategory);
    }

    @Override
    @Nonnull
    public MBOMItmObjDpnAssignmentFluentHelper getAllMBOMItmObjDpnAssignment()
    {
        return new MBOMItmObjDpnAssignmentFluentHelper(servicePath, "MBOMItmObjDpnAssignment");
    }

    @Override
    @Nonnull
    public MBOMItmObjDpnAssignmentByKeyFluentHelper getMBOMItmObjDpnAssignmentByKey(
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String headerChangeDocument,
        final String material,
        final String plant,
        final String billOfMaterialItemNodeNumber,
        final String objectDependencyName )
    {
        return new MBOMItmObjDpnAssignmentByKeyFluentHelper(
            servicePath,
            "MBOMItmObjDpnAssignment",
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            headerChangeDocument,
            material,
            plant,
            billOfMaterialItemNodeNumber,
            objectDependencyName);
    }

    @Override
    @Nonnull
    public MBOMItmObjDpnAssignmentUpdateFluentHelper updateMBOMItmObjDpnAssignment(
        @Nonnull final MBOMItmObjDpnAssignment mBOMItmObjDpnAssignment )
    {
        return new MBOMItmObjDpnAssignmentUpdateFluentHelper(
            servicePath,
            mBOMItmObjDpnAssignment,
            "MBOMItmObjDpnAssignment");
    }

    @Override
    @Nonnull
    public MBOMItmObjDpnAssignmentDeleteFluentHelper deleteMBOMItmObjDpnAssignment(
        @Nonnull final MBOMItmObjDpnAssignment mBOMItmObjDpnAssignment )
    {
        return new MBOMItmObjDpnAssignmentDeleteFluentHelper(
            servicePath,
            mBOMItmObjDpnAssignment,
            "MBOMItmObjDpnAssignment");
    }

    @Override
    @Nonnull
    public ConvertItemFluentHelper convertItem(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String billOfMaterialComponent,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String bOMItemDescription,
        @Nullable final String purchasingGroup,
        @Nullable final String materialGroup,
        @Nullable final BigDecimal materialPriceUnitQty,
        @Nullable final String currency,
        @Nullable final BigDecimal materialComponentPrice )
    {
        return new ConvertItemFluentHelper(
            servicePath,
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            billOfMaterialItemNodeNumber,
            headerChangeDocument,
            material,
            plant,
            billOfMaterialComponent,
            billOfMaterialItemCategory,
            bOMItemDescription,
            purchasingGroup,
            materialGroup,
            materialPriceUnitQty,
            currency,
            materialComponentPrice);
    }

    @Override
    @Nonnull
    public DeleteBOMItemWithECNFluentHelper deleteBOMItemWithECN(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String engineeringChangeDocForEdit )
    {
        return new DeleteBOMItemWithECNFluentHelper(
            servicePath,
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            billOfMaterialItemNodeNumber,
            headerChangeDocument,
            material,
            plant,
            engineeringChangeDocForEdit);
    }

    @Override
    @Nonnull
    public UpdateBOMItemWithECNFluentHelper updateBOMItemWithECN(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final UUID billOfMaterialItemUUID,
        @Nullable final String bOMItemInternalChangeCount,
        @Nullable final LocalDateTime validityStartDate,
        @Nullable final LocalDateTime validityEndDate,
        @Nullable final String engineeringChangeDocForEdit,
        @Nullable final String engineeringChangeDocument,
        @Nullable final String chgToEngineeringChgDocument,
        @Nullable final String inheritedNodeNumberForBOMItem,
        @Nullable final LocalDateTime bOMItemRecordCreationDate,
        @Nullable final String bOMItemCreatedByUser,
        @Nullable final LocalDateTime bOMItemLastChangeDate,
        @Nullable final String bOMItemLastChangedByUser,
        @Nullable final String billOfMaterialComponent,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String billOfMaterialItemNumber,
        @Nullable final String billOfMaterialItemUnit,
        @Nullable final BigDecimal billOfMaterialItemQuantity,
        @Nullable final String isAssembly,
        @Nullable final Boolean isSubItem,
        @Nullable final String bOMItemSorter,
        @Nullable final Boolean bOMItemHasFixedQuantity,
        @Nullable final String purchasingGroup,
        @Nullable final String currency,
        @Nullable final BigDecimal materialComponentPrice,
        @Nullable final String identifierBOMItem,
        @Nullable final BigDecimal materialPriceUnitQty,
        @Nullable final BigDecimal componentScrapInPercent,
        @Nullable final BigDecimal operationScrapInPercent,
        @Nullable final Boolean isNetScrap,
        @Nullable final BigDecimal variableSizeItemQuantity,
        @Nullable final String variableSizeCompUnitOfMeasure,
        @Nullable final BigDecimal quantityVariableSizeItem,
        @Nullable final String formulaKey,
        @Nullable final String componentDescription,
        @Nullable final String bOMItemDescription,
        @Nullable final String bOMItemText2,
        @Nullable final String materialGroup,
        @Nullable final String documentType,
        @Nullable final String docNumber,
        @Nullable final String documentVersion,
        @Nullable final String documentPart,
        @Nullable final String classNumber,
        @Nullable final String classType,
        @Nullable final String resultingItemCategory,
        @Nullable final String dependencyObjectNumber,
        @Nullable final String billOfMaterialItemObjectType,
        @Nullable final Boolean isClassificationRelevant,
        @Nullable final Boolean isBulkMaterial,
        @Nullable final String bOMItemIsSparePart,
        @Nullable final String bOMItemIsSalesRelevant,
        @Nullable final Boolean isProductionRelevant,
        @Nullable final Boolean bOMItemIsPlantMaintRelevant,
        @Nullable final String bOMItemIsCostingRelevant,
        @Nullable final Boolean isEngineeringRelevant,
        @Nullable final String specialProcurementType,
        @Nullable final Boolean isBOMRecursiveAllowed,
        @Nullable final BigDecimal operationLeadTimeOffset,
        @Nullable final String opsLeadTimeOffsetUnit,
        @Nullable final String isMaterialProvision,
        @Nullable final Boolean bOMIsRecursive,
        @Nullable final Boolean documentIsCreatedByCAD,
        @Nullable final String distrKeyCompConsumption,
        @Nullable final BigDecimal deliveryDurationInDays,
        @Nullable final String creditor,
        @Nullable final String costElement,
        @Nullable final BigDecimal size1,
        @Nullable final BigDecimal size2,
        @Nullable final BigDecimal size3,
        @Nullable final String unitOfMeasureForSize1To3,
        @Nullable final BigDecimal goodsReceiptDuration,
        @Nullable final String purchasingOrganization,
        @Nullable final Boolean requiredComponent,
        @Nullable final Boolean multipleSelectionAllowed,
        @Nullable final String prodOrderIssueLocation,
        @Nullable final Boolean materialIsCoProduct,
        @Nullable final String explosionType,
        @Nullable final String alternativeItemGroup,
        @Nullable final String alternativeItemPriority,
        @Nullable final String alternativeItemStrategy,
        @Nullable final BigDecimal usageProbabilityPercent,
        @Nullable final String followUpGroup,
        @Nullable final String discontinuationGroup,
        @Nullable final String isConfigurableBOM,
        @Nullable final String referencePoint,
        @Nullable final BigDecimal leadTimeOffset,
        @Nullable final String productionSupplyArea,
        @Nullable final Boolean isDeleted,
        @Nullable final Boolean isALE,
        @Nullable final ZonedDateTime lastChangeDateTime,
        @Nullable final String preliminaryComponent )
    {
        return new UpdateBOMItemWithECNFluentHelper(
            servicePath,
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            billOfMaterialItemNodeNumber,
            headerChangeDocument,
            material,
            plant,
            billOfMaterialItemUUID,
            bOMItemInternalChangeCount,
            validityStartDate,
            validityEndDate,
            engineeringChangeDocForEdit,
            engineeringChangeDocument,
            chgToEngineeringChgDocument,
            inheritedNodeNumberForBOMItem,
            bOMItemRecordCreationDate,
            bOMItemCreatedByUser,
            bOMItemLastChangeDate,
            bOMItemLastChangedByUser,
            billOfMaterialComponent,
            billOfMaterialItemCategory,
            billOfMaterialItemNumber,
            billOfMaterialItemUnit,
            billOfMaterialItemQuantity,
            isAssembly,
            isSubItem,
            bOMItemSorter,
            bOMItemHasFixedQuantity,
            purchasingGroup,
            currency,
            materialComponentPrice,
            identifierBOMItem,
            materialPriceUnitQty,
            componentScrapInPercent,
            operationScrapInPercent,
            isNetScrap,
            variableSizeItemQuantity,
            variableSizeCompUnitOfMeasure,
            quantityVariableSizeItem,
            formulaKey,
            componentDescription,
            bOMItemDescription,
            bOMItemText2,
            materialGroup,
            documentType,
            docNumber,
            documentVersion,
            documentPart,
            classNumber,
            classType,
            resultingItemCategory,
            dependencyObjectNumber,
            billOfMaterialItemObjectType,
            isClassificationRelevant,
            isBulkMaterial,
            bOMItemIsSparePart,
            bOMItemIsSalesRelevant,
            isProductionRelevant,
            bOMItemIsPlantMaintRelevant,
            bOMItemIsCostingRelevant,
            isEngineeringRelevant,
            specialProcurementType,
            isBOMRecursiveAllowed,
            operationLeadTimeOffset,
            opsLeadTimeOffsetUnit,
            isMaterialProvision,
            bOMIsRecursive,
            documentIsCreatedByCAD,
            distrKeyCompConsumption,
            deliveryDurationInDays,
            creditor,
            costElement,
            size1,
            size2,
            size3,
            unitOfMeasureForSize1To3,
            goodsReceiptDuration,
            purchasingOrganization,
            requiredComponent,
            multipleSelectionAllowed,
            prodOrderIssueLocation,
            materialIsCoProduct,
            explosionType,
            alternativeItemGroup,
            alternativeItemPriority,
            alternativeItemStrategy,
            usageProbabilityPercent,
            followUpGroup,
            discontinuationGroup,
            isConfigurableBOM,
            referencePoint,
            leadTimeOffset,
            productionSupplyArea,
            isDeleted,
            isALE,
            lastChangeDateTime,
            preliminaryComponent);
    }

    @Override
    @Nonnull
    public DeleteBOMHeaderWithECNFluentHelper deleteBOMHeaderWithECN(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String engineeringChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String engineeringChangeDocForEdit )
    {
        return new DeleteBOMHeaderWithECNFluentHelper(
            servicePath,
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            engineeringChangeDocument,
            material,
            plant,
            engineeringChangeDocForEdit);
    }

    @Override
    @Nonnull
    public ExplodeBOMFluentHelper explodeBOM(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String engineeringChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final String bOMExplosionApplication,
        @Nullable final BigDecimal requiredQuantity,
        @Nullable final Boolean bOMExplosionIsLimited,
        @Nullable final String bOMItmQtyIsScrapRelevant,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String bOMExplosionAssembly,
        @Nullable final LocalDateTime bOMExplosionDate,
        @Nullable final BigDecimal bOMExplosionLevel,
        @Nullable final Boolean bOMExplosionIsMultilevel,
        @Nullable final String materialProvisionFltrType,
        @Nullable final String sparePartFltrType,
        @Nullable final String bOMHeaderBaseUnit,
        @Nullable final Boolean finalPriceIndicator,
        @Nullable final Boolean bOMExplosionIsAlternatePrio )
    {
        return new ExplodeBOMFluentHelper(
            servicePath,
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            engineeringChangeDocument,
            material,
            plant,
            bOMExplosionApplication,
            requiredQuantity,
            bOMExplosionIsLimited,
            bOMItmQtyIsScrapRelevant,
            billOfMaterialItemCategory,
            bOMExplosionAssembly,
            bOMExplosionDate,
            bOMExplosionLevel,
            bOMExplosionIsMultilevel,
            materialProvisionFltrType,
            sparePartFltrType,
            bOMHeaderBaseUnit,
            finalPriceIndicator,
            bOMExplosionIsAlternatePrio);
    }

    @Override
    @Nonnull
    public ReleaseVersionBOMFluentHelper releaseVersionBOM(
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String engineeringChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant )
    {
        return new ReleaseVersionBOMFluentHelper(
            servicePath,
            billOfMaterial,
            billOfMaterialCategory,
            billOfMaterialVariant,
            billOfMaterialVersion,
            engineeringChangeDocument,
            material,
            plant);
    }

}
