/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequest;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.RejectFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.batch.DefaultBillingDocumentRequestServiceBatch;

/**
 * <p>
 *
 * Consumers of this inbound service can read, reject, and delete billing document requests inside your system by
 * sending OData requests. The service makes billing document request data available through its header, item, business
 * partner, and pricing element entities. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/dd/cccb0282774476869bc499812cf793/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILLING_DOCUMENT_REQUEST_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILLING_DOCUMENT_REQUEST_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>External Billing Document Request Integration(SAP_COM_0176)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J14'>Sales Order Processing - Project-Based Services(J14)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1MC'>Omnichannel Convergent Billing(1MC)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/PMC'>Convergent Billing(PMC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Billing Document Request</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBillingDocumentRequestService" )
@Deprecated
public class DefaultBillingDocumentRequestService implements BillingDocumentRequestService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BillingDocumentRequestService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBillingDocumentRequestService()
    {
        servicePath = BillingDocumentRequestService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBillingDocumentRequestService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBillingDocumentRequestService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBillingDocumentRequestService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBillingDocumentRequestServiceBatch batch()
    {
        return new DefaultBillingDocumentRequestServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BillingDocReqItemPartnerFluentHelper getAllBillingDocReqItemPartner()
    {
        return new BillingDocReqItemPartnerFluentHelper(servicePath, "A_BillingDocReqItemPartner");
    }

    @Override
    @Nonnull
    public BillingDocReqItemPartnerByKeyFluentHelper getBillingDocReqItemPartnerByKey(
        final String billingDocumentRequest,
        final String billingDocumentRequestItem,
        final String partnerFunction )
    {
        return new BillingDocReqItemPartnerByKeyFluentHelper(
            servicePath,
            "A_BillingDocReqItemPartner",
            billingDocumentRequest,
            billingDocumentRequestItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public BillingDocReqItemPrcgElmntFluentHelper getAllBillingDocReqItemPrcgElmnt()
    {
        return new BillingDocReqItemPrcgElmntFluentHelper(servicePath, "A_BillingDocReqItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public BillingDocReqItemPrcgElmntByKeyFluentHelper getBillingDocReqItemPrcgElmntByKey(
        final String billingDocumentRequest,
        final String billingDocumentRequestItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new BillingDocReqItemPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_BillingDocReqItemPrcgElmnt",
            billingDocumentRequest,
            billingDocumentRequestItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public BillingDocReqPartnerFluentHelper getAllBillingDocReqPartner()
    {
        return new BillingDocReqPartnerFluentHelper(servicePath, "A_BillingDocReqPartner");
    }

    @Override
    @Nonnull
    public
        BillingDocReqPartnerByKeyFluentHelper
        getBillingDocReqPartnerByKey( final String billingDocumentRequest, final String partnerFunction )
    {
        return new BillingDocReqPartnerByKeyFluentHelper(
            servicePath,
            "A_BillingDocReqPartner",
            billingDocumentRequest,
            partnerFunction);
    }

    @Override
    @Nonnull
    public BillingDocReqPrcgElmntFluentHelper getAllBillingDocReqPrcgElmnt()
    {
        return new BillingDocReqPrcgElmntFluentHelper(servicePath, "A_BillingDocReqPrcgElmnt");
    }

    @Override
    @Nonnull
    public BillingDocReqPrcgElmntByKeyFluentHelper getBillingDocReqPrcgElmntByKey(
        final String billingDocumentRequest,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new BillingDocReqPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_BillingDocReqPrcgElmnt",
            billingDocumentRequest,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public BillingDocumentRequestFluentHelper getAllBillingDocumentRequest()
    {
        return new BillingDocumentRequestFluentHelper(servicePath, "A_BillingDocumentRequest");
    }

    @Override
    @Nonnull
    public BillingDocumentRequestByKeyFluentHelper getBillingDocumentRequestByKey( final String billingDocumentRequest )
    {
        return new BillingDocumentRequestByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentRequest",
            billingDocumentRequest);
    }

    @Override
    @Nonnull
    public BillingDocumentRequestDeleteFluentHelper deleteBillingDocumentRequest(
        @Nonnull final BillingDocumentRequest billingDocumentRequest )
    {
        return new BillingDocumentRequestDeleteFluentHelper(
            servicePath,
            billingDocumentRequest,
            "A_BillingDocumentRequest");
    }

    @Override
    @Nonnull
    public BillingDocumentRequestItemFluentHelper getAllBillingDocumentRequestItem()
    {
        return new BillingDocumentRequestItemFluentHelper(servicePath, "A_BillingDocumentRequestItem");
    }

    @Override
    @Nonnull
    public BillingDocumentRequestItemByKeyFluentHelper getBillingDocumentRequestItemByKey(
        final String billingDocumentRequest,
        final String billingDocumentRequestItem )
    {
        return new BillingDocumentRequestItemByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentRequestItem",
            billingDocumentRequest,
            billingDocumentRequestItem);
    }

    @Override
    @Nonnull
    public RejectFluentHelper reject( @Nonnull final String billingDocumentRequest )
    {
        return new RejectFluentHelper(servicePath, billingDocumentRequest);
    }

}
