/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmntByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentPrcgElmntFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.BillingDocumentTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.CancelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.GetPDFFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocument.batch.DefaultBillingDocumentServiceBatch;

/**
 * <p>
 *
 * Consumers of this inbound service can read and cancel billing documents inside your system by sending OData requests.
 * In addition, they can request entire billing documents in PDF format. The service makes billing document data
 * available through its header, item, business partner, and pricing element entities..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fe/6f3eda2f914d81b512493fd79e9769/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BILLING_DOCUMENT_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BILLING_DOCUMENT_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Billing Integration(SAP_COM_0120), Excise Tax Integration(SAP_COM_0568)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Z6'>External Billing(1Z6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/OZ6'>External Billing(OZ6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4LO'>Enablement of SAP Excise Tax Management(4LO)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Billing Document</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBillingDocumentService" )
@Deprecated
public class DefaultBillingDocumentService implements BillingDocumentService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BillingDocumentService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBillingDocumentService()
    {
        servicePath = BillingDocumentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBillingDocumentService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBillingDocumentService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBillingDocumentService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBillingDocumentServiceBatch batch()
    {
        return new DefaultBillingDocumentServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BillingDocumentFluentHelper getAllBillingDocument()
    {
        return new BillingDocumentFluentHelper(servicePath, "A_BillingDocument");
    }

    @Override
    @Nonnull
    public BillingDocumentByKeyFluentHelper getBillingDocumentByKey( final String billingDocument )
    {
        return new BillingDocumentByKeyFluentHelper(servicePath, "A_BillingDocument", billingDocument);
    }

    @Override
    @Nonnull
    public BillingDocumentItemFluentHelper getAllBillingDocumentItem()
    {
        return new BillingDocumentItemFluentHelper(servicePath, "A_BillingDocumentItem");
    }

    @Override
    @Nonnull
    public
        BillingDocumentItemByKeyFluentHelper
        getBillingDocumentItemByKey( final String billingDocument, final String billingDocumentItem )
    {
        return new BillingDocumentItemByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentItem",
            billingDocument,
            billingDocumentItem);
    }

    @Override
    @Nonnull
    public BillingDocumentItemPartnerFluentHelper getAllBillingDocumentItemPartner()
    {
        return new BillingDocumentItemPartnerFluentHelper(servicePath, "A_BillingDocumentItemPartner");
    }

    @Override
    @Nonnull
    public BillingDocumentItemPartnerByKeyFluentHelper getBillingDocumentItemPartnerByKey(
        final String billingDocument,
        final String billingDocumentItem,
        final String partnerFunction )
    {
        return new BillingDocumentItemPartnerByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentItemPartner",
            billingDocument,
            billingDocumentItem,
            partnerFunction);
    }

    @Override
    @Nonnull
    public BillingDocumentItemPrcgElmntFluentHelper getAllBillingDocumentItemPrcgElmnt()
    {
        return new BillingDocumentItemPrcgElmntFluentHelper(servicePath, "A_BillingDocumentItemPrcgElmnt");
    }

    @Override
    @Nonnull
    public BillingDocumentItemPrcgElmntByKeyFluentHelper getBillingDocumentItemPrcgElmntByKey(
        final String billingDocument,
        final String billingDocumentItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new BillingDocumentItemPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentItemPrcgElmnt",
            billingDocument,
            billingDocumentItem,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public BillingDocumentItemTextFluentHelper getAllBillingDocumentItemText()
    {
        return new BillingDocumentItemTextFluentHelper(servicePath, "A_BillingDocumentItemText");
    }

    @Override
    @Nonnull
    public BillingDocumentItemTextByKeyFluentHelper getBillingDocumentItemTextByKey(
        final String billingDocument,
        final String billingDocumentItem,
        final String language,
        final String longTextID )
    {
        return new BillingDocumentItemTextByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentItemText",
            billingDocument,
            billingDocumentItem,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public BillingDocumentPartnerFluentHelper getAllBillingDocumentPartner()
    {
        return new BillingDocumentPartnerFluentHelper(servicePath, "A_BillingDocumentPartner");
    }

    @Override
    @Nonnull
    public
        BillingDocumentPartnerByKeyFluentHelper
        getBillingDocumentPartnerByKey( final String billingDocument, final String partnerFunction )
    {
        return new BillingDocumentPartnerByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentPartner",
            billingDocument,
            partnerFunction);
    }

    @Override
    @Nonnull
    public BillingDocumentPrcgElmntFluentHelper getAllBillingDocumentPrcgElmnt()
    {
        return new BillingDocumentPrcgElmntFluentHelper(servicePath, "A_BillingDocumentPrcgElmnt");
    }

    @Override
    @Nonnull
    public BillingDocumentPrcgElmntByKeyFluentHelper getBillingDocumentPrcgElmntByKey(
        final String billingDocument,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        return new BillingDocumentPrcgElmntByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentPrcgElmnt",
            billingDocument,
            pricingProcedureStep,
            pricingProcedureCounter);
    }

    @Override
    @Nonnull
    public BillingDocumentTextFluentHelper getAllBillingDocumentText()
    {
        return new BillingDocumentTextFluentHelper(servicePath, "A_BillingDocumentText");
    }

    @Override
    @Nonnull
    public
        BillingDocumentTextByKeyFluentHelper
        getBillingDocumentTextByKey( final String billingDocument, final String language, final String longTextID )
    {
        return new BillingDocumentTextByKeyFluentHelper(
            servicePath,
            "A_BillingDocumentText",
            billingDocument,
            language,
            longTextID);
    }

    @Override
    @Nonnull
    public CancelFluentHelper cancel( @Nonnull final String billingDocument )
    {
        return new CancelFluentHelper(servicePath, billingDocument);
    }

    @Override
    @Nonnull
    public GetPDFFluentHelper getPDF( @Nonnull final String billingDocument )
    {
        return new GetPDFFluentHelper(servicePath, billingDocument);
    }

}
