/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsedByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsedFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.batch.DefaultBillsOfMaterialWhereUsedListServiceBatch;

/**
 * <p>
 *
 * The service contains either no header, one header or multiple headers, and an item. When you search for a component,
 * a list of the headers in which the component is used is displayed.
 *
 * The service is based on the OData protocol and can be consumed in SAP Fiori apps and on other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/64/39c6e13fd049f79dfac15e99dc1f24/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BOM_WHERE_USED_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BOM_WHERE_USED_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Lifecycle Management - Master Data Integration(SAP_COM_0105)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/BJE'>Make-to-Order Production - Finished Goods Sales and Final
 * Assembly(BJE)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1NR'>Engineering Bill of Material - Versions
 * Management(1NR)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/1R3'>Engineering Bill of Material - Change Master
 * Management(1R3)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LO'>Change Manufacturing Bill of Material for
 * Production(3LO)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/3LP'>Mass Change Manufacturing Bill of Material
 * for Production(3LP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Bill Of Material</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBillsOfMaterialWhereUsedListService" )
@Deprecated
public class DefaultBillsOfMaterialWhereUsedListService implements BillsOfMaterialWhereUsedListService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BillsOfMaterialWhereUsedListService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBillsOfMaterialWhereUsedListService()
    {
        servicePath = BillsOfMaterialWhereUsedListService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBillsOfMaterialWhereUsedListService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBillsOfMaterialWhereUsedListService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBillsOfMaterialWhereUsedListService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBillsOfMaterialWhereUsedListServiceBatch batch()
    {
        return new DefaultBillsOfMaterialWhereUsedListServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BOMWhereUsedFluentHelper getAllBOMWhereUsed()
    {
        return new BOMWhereUsedFluentHelper(servicePath, "A_BOMWhereUsed");
    }

    @Override
    @Nonnull
    public BOMWhereUsedByKeyFluentHelper getBOMWhereUsedByKey( final UUID billOfMaterialItemUUID )
    {
        return new BOMWhereUsedByKeyFluentHelper(servicePath, "A_BOMWhereUsed", billOfMaterialItemUUID);
    }

}
