/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlaceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.batch.DefaultBrazilBusinessPlaceServiceBatch;

/**
 * <p>
 * This service is based on the OData protocol and can be consumed in Brazilian integration scenarios. Once the business
 * place and company code numbers have been informed, the system returns business place data such as address, tax
 * jurisdiction, telephone, CNPJ number, and municipal tax number.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/59/5d6255f1d54e2ba285b37705548e1f/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LOGBR_BUSINESS_PLACE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LOGBR_BUSINESS_PLACE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Brazil Business Place Detail Integration(SAP_COM_0365)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1J5'>Invoice, Taxes and Complementary Postings(1J5)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>BR_BusinessPlace</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the
 *             <a href="https://api.sap.com/api/API_GLO_BUSINESSPLACE_SRV"> successor API</a> instead.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBrazilBusinessPlaceService" )
@Deprecated
public class DefaultBrazilBusinessPlaceService implements BrazilBusinessPlaceService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BrazilBusinessPlaceService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBrazilBusinessPlaceService()
    {
        servicePath = BrazilBusinessPlaceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBrazilBusinessPlaceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBrazilBusinessPlaceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBrazilBusinessPlaceService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBrazilBusinessPlaceServiceBatch batch()
    {
        return new DefaultBrazilBusinessPlaceServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BusinessPlaceByKeyFluentHelper getBusinessPlaceByKey( final String branch, final String companyCode )
    {
        return new BusinessPlaceByKeyFluentHelper(servicePath, "BusinessPlaceSet", branch, companyCode);
    }

}
