/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionImportDocUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFAdditionalInformationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReference;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentReferenceUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFDocumentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclaration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDeclarationUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFExportDocumentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuel;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicator;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelOriginIndicatorUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFFuelUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFHeaderTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFImportDocumentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemAdditionalInfoUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVE;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemNVEUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFItemUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFPartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcess;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFReferencedProcessUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneDeductibleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupply;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFSugarCaneSupplyUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAX;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTAXUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNote;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTradeNoteUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTrailerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolume;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFTransportedVolumeUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFVehicleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePayment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePaymentUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceutical;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFePharmaceuticalUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceability;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_NFeProductTraceabilityUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_OneTimePartnerUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.BR_TechnicalResponsibleUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilnotafiscal.batch.DefaultBrazilNotaFiscalServiceBatch;

/**
 * <p>
 * This service is based on the OData and can be consumed in Brazilian integration scenarios. To create a nota fiscal
 * document, enter the nota fiscal data - the system generates the nota fiscal and returns the document number. To
 * update a nota fiscal document, enter the document number and the data to be changed - the system updates the nota
 * fiscal accordingly.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/6a/7e35da2f4e45ee9a0be69b61bf7765/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_LOGBR_NOTAFISCAL_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_LOGBR_NOTAFISCAL_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Brazil Nota Fiscal Integration(SAP_COM_0387)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2RP'>Electronic Documents(2RP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Nota Fiscal</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBrazilNotaFiscalService" )
@Deprecated
public class DefaultBrazilNotaFiscalService implements BrazilNotaFiscalService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BrazilNotaFiscalService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBrazilNotaFiscalService()
    {
        servicePath = BrazilNotaFiscalService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBrazilNotaFiscalService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBrazilNotaFiscalService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBrazilNotaFiscalService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBrazilNotaFiscalServiceBatch batch()
    {
        return new DefaultBrazilNotaFiscalServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BR_NFAdditionalInformationFluentHelper getAllBR_NFAdditionalInformation()
    {
        return new BR_NFAdditionalInformationFluentHelper(servicePath, "A_BR_NFAdditionalInformation");
    }

    @Override
    @Nonnull
    public BR_NFAdditionalInformationByKeyFluentHelper getBR_NFAdditionalInformationByKey(
        final String bR_NotaFiscal,
        final String bR_NFInfoFieldUsage,
        final String bR_NFAdditionalInformationID )
    {
        return new BR_NFAdditionalInformationByKeyFluentHelper(
            servicePath,
            "A_BR_NFAdditionalInformation",
            bR_NotaFiscal,
            bR_NFInfoFieldUsage,
            bR_NFAdditionalInformationID);
    }

    @Override
    @Nonnull
    public BR_NFAdditionalInformationUpdateFluentHelper updateBR_NFAdditionalInformation(
        @Nonnull final BR_NFAdditionalInformation bR_NFAdditionalInformation )
    {
        return new BR_NFAdditionalInformationUpdateFluentHelper(
            servicePath,
            bR_NFAdditionalInformation,
            "A_BR_NFAdditionalInformation");
    }

    @Override
    @Nonnull
    public BR_NFAdditionImportDocFluentHelper getAllBR_NFAdditionImportDoc()
    {
        return new BR_NFAdditionImportDocFluentHelper(servicePath, "A_BR_NFAdditionImportDoc");
    }

    @Override
    @Nonnull
    public BR_NFAdditionImportDocByKeyFluentHelper getBR_NFAdditionImportDocByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFImportDocument,
        final String bR_NFAddition,
        final String bR_NFItemSequenceNumber )
    {
        return new BR_NFAdditionImportDocByKeyFluentHelper(
            servicePath,
            "A_BR_NFAdditionImportDoc",
            bR_NotaFiscal,
            bR_NotaFiscalItem,
            bR_NFImportDocument,
            bR_NFAddition,
            bR_NFItemSequenceNumber);
    }

    @Override
    @Nonnull
    public BR_NFAdditionImportDocUpdateFluentHelper updateBR_NFAdditionImportDoc(
        @Nonnull final BR_NFAdditionImportDoc bR_NFAdditionImportDoc )
    {
        return new BR_NFAdditionImportDocUpdateFluentHelper(
            servicePath,
            bR_NFAdditionImportDoc,
            "A_BR_NFAdditionImportDoc");
    }

    @Override
    @Nonnull
    public BR_NFDocumentFluentHelper getAllBR_NFDocument()
    {
        return new BR_NFDocumentFluentHelper(servicePath, "A_BR_NFDocument");
    }

    @Override
    @Nonnull
    public BR_NFDocumentByKeyFluentHelper getBR_NFDocumentByKey( final String bR_NotaFiscal )
    {
        return new BR_NFDocumentByKeyFluentHelper(servicePath, "A_BR_NFDocument", bR_NotaFiscal);
    }

    @Override
    @Nonnull
    public BR_NFDocumentCreateFluentHelper createBR_NFDocument( @Nonnull final BR_NFDocument bR_NFDocument )
    {
        return new BR_NFDocumentCreateFluentHelper(servicePath, bR_NFDocument, "A_BR_NFDocument");
    }

    @Override
    @Nonnull
    public BR_NFDocumentUpdateFluentHelper updateBR_NFDocument( @Nonnull final BR_NFDocument bR_NFDocument )
    {
        return new BR_NFDocumentUpdateFluentHelper(servicePath, bR_NFDocument, "A_BR_NFDocument");
    }

    @Override
    @Nonnull
    public BR_NFDocumentReferenceFluentHelper getAllBR_NFDocumentReference()
    {
        return new BR_NFDocumentReferenceFluentHelper(servicePath, "A_BR_NFDocumentReference");
    }

    @Override
    @Nonnull
    public
        BR_NFDocumentReferenceByKeyFluentHelper
        getBR_NFDocumentReferenceByKey( final String bR_NotaFiscal, final String bR_NFDocRefSequenceNumber )
    {
        return new BR_NFDocumentReferenceByKeyFluentHelper(
            servicePath,
            "A_BR_NFDocumentReference",
            bR_NotaFiscal,
            bR_NFDocRefSequenceNumber);
    }

    @Override
    @Nonnull
    public BR_NFDocumentReferenceUpdateFluentHelper updateBR_NFDocumentReference(
        @Nonnull final BR_NFDocumentReference bR_NFDocumentReference )
    {
        return new BR_NFDocumentReferenceUpdateFluentHelper(
            servicePath,
            bR_NFDocumentReference,
            "A_BR_NFDocumentReference");
    }

    @Override
    @Nonnull
    public BR_NFePaymentFluentHelper getAllBR_NFePayment()
    {
        return new BR_NFePaymentFluentHelper(servicePath, "A_BR_NFePayment");
    }

    @Override
    @Nonnull
    public
        BR_NFePaymentByKeyFluentHelper
        getBR_NFePaymentByKey( final String bR_NotaFiscal, final String sequenceNumber )
    {
        return new BR_NFePaymentByKeyFluentHelper(servicePath, "A_BR_NFePayment", bR_NotaFiscal, sequenceNumber);
    }

    @Override
    @Nonnull
    public BR_NFePaymentUpdateFluentHelper updateBR_NFePayment( @Nonnull final BR_NFePayment bR_NFePayment )
    {
        return new BR_NFePaymentUpdateFluentHelper(servicePath, bR_NFePayment, "A_BR_NFePayment");
    }

    @Override
    @Nonnull
    public BR_NFePharmaceuticalFluentHelper getAllBR_NFePharmaceutical()
    {
        return new BR_NFePharmaceuticalFluentHelper(servicePath, "A_BR_NFePharmaceutical");
    }

    @Override
    @Nonnull
    public
        BR_NFePharmaceuticalByKeyFluentHelper
        getBR_NFePharmaceuticalByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem )
    {
        return new BR_NFePharmaceuticalByKeyFluentHelper(
            servicePath,
            "A_BR_NFePharmaceutical",
            bR_NotaFiscal,
            bR_NotaFiscalItem);
    }

    @Override
    @Nonnull
    public BR_NFePharmaceuticalUpdateFluentHelper updateBR_NFePharmaceutical(
        @Nonnull final BR_NFePharmaceutical bR_NFePharmaceutical )
    {
        return new BR_NFePharmaceuticalUpdateFluentHelper(servicePath, bR_NFePharmaceutical, "A_BR_NFePharmaceutical");
    }

    @Override
    @Nonnull
    public BR_NFeProductTraceabilityFluentHelper getAllBR_NFeProductTraceability()
    {
        return new BR_NFeProductTraceabilityFluentHelper(servicePath, "A_BR_NFeProductTraceability");
    }

    @Override
    @Nonnull
    public BR_NFeProductTraceabilityByKeyFluentHelper getBR_NFeProductTraceabilityByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String sequenceNumber )
    {
        return new BR_NFeProductTraceabilityByKeyFluentHelper(
            servicePath,
            "A_BR_NFeProductTraceability",
            bR_NotaFiscal,
            bR_NotaFiscalItem,
            sequenceNumber);
    }

    @Override
    @Nonnull
    public BR_NFeProductTraceabilityUpdateFluentHelper updateBR_NFeProductTraceability(
        @Nonnull final BR_NFeProductTraceability bR_NFeProductTraceability )
    {
        return new BR_NFeProductTraceabilityUpdateFluentHelper(
            servicePath,
            bR_NFeProductTraceability,
            "A_BR_NFeProductTraceability");
    }

    @Override
    @Nonnull
    public BR_NFExportDeclarationFluentHelper getAllBR_NFExportDeclaration()
    {
        return new BR_NFExportDeclarationFluentHelper(servicePath, "A_BR_NFExportDeclaration");
    }

    @Override
    @Nonnull
    public BR_NFExportDeclarationByKeyFluentHelper getBR_NFExportDeclarationByKey( final String bR_NotaFiscal )
    {
        return new BR_NFExportDeclarationByKeyFluentHelper(servicePath, "A_BR_NFExportDeclaration", bR_NotaFiscal);
    }

    @Override
    @Nonnull
    public BR_NFExportDeclarationUpdateFluentHelper updateBR_NFExportDeclaration(
        @Nonnull final BR_NFExportDeclaration bR_NFExportDeclaration )
    {
        return new BR_NFExportDeclarationUpdateFluentHelper(
            servicePath,
            bR_NFExportDeclaration,
            "A_BR_NFExportDeclaration");
    }

    @Override
    @Nonnull
    public BR_NFExportDocumentFluentHelper getAllBR_NFExportDocument()
    {
        return new BR_NFExportDocumentFluentHelper(servicePath, "A_BR_NFExportDocument");
    }

    @Override
    @Nonnull
    public BR_NFExportDocumentByKeyFluentHelper getBR_NFExportDocumentByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFItemExprtSqncNumber )
    {
        return new BR_NFExportDocumentByKeyFluentHelper(
            servicePath,
            "A_BR_NFExportDocument",
            bR_NotaFiscal,
            bR_NotaFiscalItem,
            bR_NFItemExprtSqncNumber);
    }

    @Override
    @Nonnull
    public BR_NFExportDocumentUpdateFluentHelper updateBR_NFExportDocument(
        @Nonnull final BR_NFExportDocument bR_NFExportDocument )
    {
        return new BR_NFExportDocumentUpdateFluentHelper(servicePath, bR_NFExportDocument, "A_BR_NFExportDocument");
    }

    @Override
    @Nonnull
    public BR_NFFuelFluentHelper getAllBR_NFFuel()
    {
        return new BR_NFFuelFluentHelper(servicePath, "A_BR_NFFuel");
    }

    @Override
    @Nonnull
    public BR_NFFuelByKeyFluentHelper getBR_NFFuelByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem )
    {
        return new BR_NFFuelByKeyFluentHelper(servicePath, "A_BR_NFFuel", bR_NotaFiscal, bR_NotaFiscalItem);
    }

    @Override
    @Nonnull
    public BR_NFFuelUpdateFluentHelper updateBR_NFFuel( @Nonnull final BR_NFFuel bR_NFFuel )
    {
        return new BR_NFFuelUpdateFluentHelper(servicePath, bR_NFFuel, "A_BR_NFFuel");
    }

    @Override
    @Nonnull
    public BR_NFFuelOriginIndicatorFluentHelper getAllBR_NFFuelOriginIndicator()
    {
        return new BR_NFFuelOriginIndicatorFluentHelper(servicePath, "A_BR_NFFuelOriginIndicator");
    }

    @Override
    @Nonnull
    public BR_NFFuelOriginIndicatorByKeyFluentHelper getBR_NFFuelOriginIndicatorByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFImportIndicatorFuelOrigin,
        final String bR_NFOriginRegion )
    {
        return new BR_NFFuelOriginIndicatorByKeyFluentHelper(
            servicePath,
            "A_BR_NFFuelOriginIndicator",
            bR_NotaFiscal,
            bR_NotaFiscalItem,
            bR_NFImportIndicatorFuelOrigin,
            bR_NFOriginRegion);
    }

    @Override
    @Nonnull
    public BR_NFFuelOriginIndicatorUpdateFluentHelper updateBR_NFFuelOriginIndicator(
        @Nonnull final BR_NFFuelOriginIndicator bR_NFFuelOriginIndicator )
    {
        return new BR_NFFuelOriginIndicatorUpdateFluentHelper(
            servicePath,
            bR_NFFuelOriginIndicator,
            "A_BR_NFFuelOriginIndicator");
    }

    @Override
    @Nonnull
    public BR_NFHeaderTextFluentHelper getAllBR_NFHeaderText()
    {
        return new BR_NFHeaderTextFluentHelper(servicePath, "A_BR_NFHeaderText");
    }

    @Override
    @Nonnull
    public BR_NFHeaderTextByKeyFluentHelper getBR_NFHeaderTextByKey(
        final String bR_NotaFiscal,
        final String bR_NFTextType,
        final String bR_NFTextSequenceNumber )
    {
        return new BR_NFHeaderTextByKeyFluentHelper(
            servicePath,
            "A_BR_NFHeaderText",
            bR_NotaFiscal,
            bR_NFTextType,
            bR_NFTextSequenceNumber);
    }

    @Override
    @Nonnull
    public BR_NFHeaderTextUpdateFluentHelper updateBR_NFHeaderText( @Nonnull final BR_NFHeaderText bR_NFHeaderText )
    {
        return new BR_NFHeaderTextUpdateFluentHelper(servicePath, bR_NFHeaderText, "A_BR_NFHeaderText");
    }

    @Override
    @Nonnull
    public BR_NFImportDocumentFluentHelper getAllBR_NFImportDocument()
    {
        return new BR_NFImportDocumentFluentHelper(servicePath, "A_BR_NFImportDocument");
    }

    @Override
    @Nonnull
    public
        BR_NFImportDocumentByKeyFluentHelper
        getBR_NFImportDocumentByKey( final String bR_NotaFiscal, final String bR_NFImportDocument )
    {
        return new BR_NFImportDocumentByKeyFluentHelper(
            servicePath,
            "A_BR_NFImportDocument",
            bR_NotaFiscal,
            bR_NFImportDocument);
    }

    @Override
    @Nonnull
    public BR_NFImportDocumentUpdateFluentHelper updateBR_NFImportDocument(
        @Nonnull final BR_NFImportDocument bR_NFImportDocument )
    {
        return new BR_NFImportDocumentUpdateFluentHelper(servicePath, bR_NFImportDocument, "A_BR_NFImportDocument");
    }

    @Override
    @Nonnull
    public BR_NFItemFluentHelper getAllBR_NFItem()
    {
        return new BR_NFItemFluentHelper(servicePath, "A_BR_NFItem");
    }

    @Override
    @Nonnull
    public BR_NFItemByKeyFluentHelper getBR_NFItemByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem )
    {
        return new BR_NFItemByKeyFluentHelper(servicePath, "A_BR_NFItem", bR_NotaFiscal, bR_NotaFiscalItem);
    }

    @Override
    @Nonnull
    public BR_NFItemUpdateFluentHelper updateBR_NFItem( @Nonnull final BR_NFItem bR_NFItem )
    {
        return new BR_NFItemUpdateFluentHelper(servicePath, bR_NFItem, "A_BR_NFItem");
    }

    @Override
    @Nonnull
    public BR_NFItemAdditionalInfoFluentHelper getAllBR_NFItemAdditionalInfo()
    {
        return new BR_NFItemAdditionalInfoFluentHelper(servicePath, "A_BR_NFItemAdditionalInfo");
    }

    @Override
    @Nonnull
    public BR_NFItemAdditionalInfoByKeyFluentHelper getBR_NFItemAdditionalInfoByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFInfoFieldUsage )
    {
        return new BR_NFItemAdditionalInfoByKeyFluentHelper(
            servicePath,
            "A_BR_NFItemAdditionalInfo",
            bR_NotaFiscal,
            bR_NotaFiscalItem,
            bR_NFInfoFieldUsage);
    }

    @Override
    @Nonnull
    public BR_NFItemAdditionalInfoUpdateFluentHelper updateBR_NFItemAdditionalInfo(
        @Nonnull final BR_NFItemAdditionalInfo bR_NFItemAdditionalInfo )
    {
        return new BR_NFItemAdditionalInfoUpdateFluentHelper(
            servicePath,
            bR_NFItemAdditionalInfo,
            "A_BR_NFItemAdditionalInfo");
    }

    @Override
    @Nonnull
    public BR_NFItemNVEFluentHelper getAllBR_NFItemNVE()
    {
        return new BR_NFItemNVEFluentHelper(servicePath, "A_BR_NFItemNVE");
    }

    @Override
    @Nonnull
    public
        BR_NFItemNVEByKeyFluentHelper
        getBR_NFItemNVEByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem, final String bR_NVECode )
    {
        return new BR_NFItemNVEByKeyFluentHelper(
            servicePath,
            "A_BR_NFItemNVE",
            bR_NotaFiscal,
            bR_NotaFiscalItem,
            bR_NVECode);
    }

    @Override
    @Nonnull
    public BR_NFItemNVEUpdateFluentHelper updateBR_NFItemNVE( @Nonnull final BR_NFItemNVE bR_NFItemNVE )
    {
        return new BR_NFItemNVEUpdateFluentHelper(servicePath, bR_NFItemNVE, "A_BR_NFItemNVE");
    }

    @Override
    @Nonnull
    public BR_NFItemTextFluentHelper getAllBR_NFItemText()
    {
        return new BR_NFItemTextFluentHelper(servicePath, "A_BR_NFItemText");
    }

    @Override
    @Nonnull
    public BR_NFItemTextByKeyFluentHelper getBR_NFItemTextByKey(
        final String bR_NotaFiscal,
        final String bR_NotaFiscalItem,
        final String bR_NFTextType,
        final String bR_NFTextSequenceNumber )
    {
        return new BR_NFItemTextByKeyFluentHelper(
            servicePath,
            "A_BR_NFItemText",
            bR_NotaFiscal,
            bR_NotaFiscalItem,
            bR_NFTextType,
            bR_NFTextSequenceNumber);
    }

    @Override
    @Nonnull
    public BR_NFItemTextUpdateFluentHelper updateBR_NFItemText( @Nonnull final BR_NFItemText bR_NFItemText )
    {
        return new BR_NFItemTextUpdateFluentHelper(servicePath, bR_NFItemText, "A_BR_NFItemText");
    }

    @Override
    @Nonnull
    public BR_NFPartnerFluentHelper getAllBR_NFPartner()
    {
        return new BR_NFPartnerFluentHelper(servicePath, "A_BR_NFPartner");
    }

    @Override
    @Nonnull
    public
        BR_NFPartnerByKeyFluentHelper
        getBR_NFPartnerByKey( final String bR_NotaFiscal, final String bR_NFPartnerFunction )
    {
        return new BR_NFPartnerByKeyFluentHelper(servicePath, "A_BR_NFPartner", bR_NotaFiscal, bR_NFPartnerFunction);
    }

    @Override
    @Nonnull
    public BR_NFPartnerUpdateFluentHelper updateBR_NFPartner( @Nonnull final BR_NFPartner bR_NFPartner )
    {
        return new BR_NFPartnerUpdateFluentHelper(servicePath, bR_NFPartner, "A_BR_NFPartner");
    }

    @Override
    @Nonnull
    public BR_NFReferencedProcessFluentHelper getAllBR_NFReferencedProcess()
    {
        return new BR_NFReferencedProcessFluentHelper(servicePath, "A_BR_NFReferencedProcess");
    }

    @Override
    @Nonnull
    public
        BR_NFReferencedProcessByKeyFluentHelper
        getBR_NFReferencedProcessByKey( final String bR_NotaFiscal, final String bR_NFReferencedProcessSqncNmbr )
    {
        return new BR_NFReferencedProcessByKeyFluentHelper(
            servicePath,
            "A_BR_NFReferencedProcess",
            bR_NotaFiscal,
            bR_NFReferencedProcessSqncNmbr);
    }

    @Override
    @Nonnull
    public BR_NFReferencedProcessUpdateFluentHelper updateBR_NFReferencedProcess(
        @Nonnull final BR_NFReferencedProcess bR_NFReferencedProcess )
    {
        return new BR_NFReferencedProcessUpdateFluentHelper(
            servicePath,
            bR_NFReferencedProcess,
            "A_BR_NFReferencedProcess");
    }

    @Override
    @Nonnull
    public BR_NFSugarCaneDeductibleFluentHelper getAllBR_NFSugarCaneDeductible()
    {
        return new BR_NFSugarCaneDeductibleFluentHelper(servicePath, "A_BR_NFSugarCaneDeductible");
    }

    @Override
    @Nonnull
    public
        BR_NFSugarCaneDeductibleByKeyFluentHelper
        getBR_NFSugarCaneDeductibleByKey( final String bR_NotaFiscal, final String sugarcaneDcblSqncNmbr )
    {
        return new BR_NFSugarCaneDeductibleByKeyFluentHelper(
            servicePath,
            "A_BR_NFSugarCaneDeductible",
            bR_NotaFiscal,
            sugarcaneDcblSqncNmbr);
    }

    @Override
    @Nonnull
    public BR_NFSugarCaneDeductibleUpdateFluentHelper updateBR_NFSugarCaneDeductible(
        @Nonnull final BR_NFSugarCaneDeductible bR_NFSugarCaneDeductible )
    {
        return new BR_NFSugarCaneDeductibleUpdateFluentHelper(
            servicePath,
            bR_NFSugarCaneDeductible,
            "A_BR_NFSugarCaneDeductible");
    }

    @Override
    @Nonnull
    public BR_NFSugarCaneSupplyFluentHelper getAllBR_NFSugarCaneSupply()
    {
        return new BR_NFSugarCaneSupplyFluentHelper(servicePath, "A_BR_NFSugarCaneSupply");
    }

    @Override
    @Nonnull
    public
        BR_NFSugarCaneSupplyByKeyFluentHelper
        getBR_NFSugarCaneSupplyByKey( final String bR_NotaFiscal, final String sugarcaneDayOfCurrentMnth )
    {
        return new BR_NFSugarCaneSupplyByKeyFluentHelper(
            servicePath,
            "A_BR_NFSugarCaneSupply",
            bR_NotaFiscal,
            sugarcaneDayOfCurrentMnth);
    }

    @Override
    @Nonnull
    public BR_NFSugarCaneSupplyUpdateFluentHelper updateBR_NFSugarCaneSupply(
        @Nonnull final BR_NFSugarCaneSupply bR_NFSugarCaneSupply )
    {
        return new BR_NFSugarCaneSupplyUpdateFluentHelper(servicePath, bR_NFSugarCaneSupply, "A_BR_NFSugarCaneSupply");
    }

    @Override
    @Nonnull
    public BR_NFTAXFluentHelper getAllBR_NFTAX()
    {
        return new BR_NFTAXFluentHelper(servicePath, "A_BR_NFTAX");
    }

    @Override
    @Nonnull
    public
        BR_NFTAXByKeyFluentHelper
        getBR_NFTAXByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem, final String bR_TaxType )
    {
        return new BR_NFTAXByKeyFluentHelper(servicePath, "A_BR_NFTAX", bR_NotaFiscal, bR_NotaFiscalItem, bR_TaxType);
    }

    @Override
    @Nonnull
    public BR_NFTAXUpdateFluentHelper updateBR_NFTAX( @Nonnull final BR_NFTAX bR_NFTAX )
    {
        return new BR_NFTAXUpdateFluentHelper(servicePath, bR_NFTAX, "A_BR_NFTAX");
    }

    @Override
    @Nonnull
    public BR_NFTradeNoteFluentHelper getAllBR_NFTradeNote()
    {
        return new BR_NFTradeNoteFluentHelper(servicePath, "A_BR_NFTradeNote");
    }

    @Override
    @Nonnull
    public
        BR_NFTradeNoteByKeyFluentHelper
        getBR_NFTradeNoteByKey( final String bR_NotaFiscal, final String bR_NFTradeNoteSequenceNumber )
    {
        return new BR_NFTradeNoteByKeyFluentHelper(
            servicePath,
            "A_BR_NFTradeNote",
            bR_NotaFiscal,
            bR_NFTradeNoteSequenceNumber);
    }

    @Override
    @Nonnull
    public BR_NFTradeNoteUpdateFluentHelper updateBR_NFTradeNote( @Nonnull final BR_NFTradeNote bR_NFTradeNote )
    {
        return new BR_NFTradeNoteUpdateFluentHelper(servicePath, bR_NFTradeNote, "A_BR_NFTradeNote");
    }

    @Override
    @Nonnull
    public BR_NFTrailerFluentHelper getAllBR_NFTrailer()
    {
        return new BR_NFTrailerFluentHelper(servicePath, "A_BR_NFTrailer");
    }

    @Override
    @Nonnull
    public BR_NFTrailerByKeyFluentHelper getBR_NFTrailerByKey( final String bR_NotaFiscal, final String trailerID )
    {
        return new BR_NFTrailerByKeyFluentHelper(servicePath, "A_BR_NFTrailer", bR_NotaFiscal, trailerID);
    }

    @Override
    @Nonnull
    public BR_NFTrailerUpdateFluentHelper updateBR_NFTrailer( @Nonnull final BR_NFTrailer bR_NFTrailer )
    {
        return new BR_NFTrailerUpdateFluentHelper(servicePath, bR_NFTrailer, "A_BR_NFTrailer");
    }

    @Override
    @Nonnull
    public BR_NFTransportedVolumeFluentHelper getAllBR_NFTransportedVolume()
    {
        return new BR_NFTransportedVolumeFluentHelper(servicePath, "A_BR_NFTransportedVolume");
    }

    @Override
    @Nonnull
    public
        BR_NFTransportedVolumeByKeyFluentHelper
        getBR_NFTransportedVolumeByKey( final String bR_NotaFiscal, final String bR_NFTransptVolumesSequence )
    {
        return new BR_NFTransportedVolumeByKeyFluentHelper(
            servicePath,
            "A_BR_NFTransportedVolume",
            bR_NotaFiscal,
            bR_NFTransptVolumesSequence);
    }

    @Override
    @Nonnull
    public BR_NFTransportedVolumeUpdateFluentHelper updateBR_NFTransportedVolume(
        @Nonnull final BR_NFTransportedVolume bR_NFTransportedVolume )
    {
        return new BR_NFTransportedVolumeUpdateFluentHelper(
            servicePath,
            bR_NFTransportedVolume,
            "A_BR_NFTransportedVolume");
    }

    @Override
    @Nonnull
    public BR_NFVehicleFluentHelper getAllBR_NFVehicle()
    {
        return new BR_NFVehicleFluentHelper(servicePath, "A_BR_NFVehicle");
    }

    @Override
    @Nonnull
    public
        BR_NFVehicleByKeyFluentHelper
        getBR_NFVehicleByKey( final String bR_NotaFiscal, final String bR_NotaFiscalItem )
    {
        return new BR_NFVehicleByKeyFluentHelper(servicePath, "A_BR_NFVehicle", bR_NotaFiscal, bR_NotaFiscalItem);
    }

    @Override
    @Nonnull
    public BR_NFVehicleUpdateFluentHelper updateBR_NFVehicle( @Nonnull final BR_NFVehicle bR_NFVehicle )
    {
        return new BR_NFVehicleUpdateFluentHelper(servicePath, bR_NFVehicle, "A_BR_NFVehicle");
    }

    @Override
    @Nonnull
    public BR_OneTimePartnerFluentHelper getAllBR_OneTimePartner()
    {
        return new BR_OneTimePartnerFluentHelper(servicePath, "A_BR_OneTimePartner");
    }

    @Override
    @Nonnull
    public
        BR_OneTimePartnerByKeyFluentHelper
        getBR_OneTimePartnerByKey( final String bR_NotaFiscal, final String bR_PartnerFunction )
    {
        return new BR_OneTimePartnerByKeyFluentHelper(
            servicePath,
            "A_BR_OneTimePartner",
            bR_NotaFiscal,
            bR_PartnerFunction);
    }

    @Override
    @Nonnull
    public BR_OneTimePartnerUpdateFluentHelper updateBR_OneTimePartner(
        @Nonnull final BR_OneTimePartner bR_OneTimePartner )
    {
        return new BR_OneTimePartnerUpdateFluentHelper(servicePath, bR_OneTimePartner, "A_BR_OneTimePartner");
    }

    @Override
    @Nonnull
    public BR_TechnicalResponsibleFluentHelper getAllBR_TechnicalResponsible()
    {
        return new BR_TechnicalResponsibleFluentHelper(servicePath, "A_BR_TechnicalResponsible");
    }

    @Override
    @Nonnull
    public BR_TechnicalResponsibleByKeyFluentHelper getBR_TechnicalResponsibleByKey( final String bR_NotaFiscal )
    {
        return new BR_TechnicalResponsibleByKeyFluentHelper(servicePath, "A_BR_TechnicalResponsible", bR_NotaFiscal);
    }

    @Override
    @Nonnull
    public BR_TechnicalResponsibleUpdateFluentHelper updateBR_TechnicalResponsible(
        @Nonnull final BR_TechnicalResponsible bR_TechnicalResponsible )
    {
        return new BR_TechnicalResponsibleUpdateFluentHelper(
            servicePath,
            bR_TechnicalResponsible,
            "A_BR_TechnicalResponsible");
    }

}
