/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetAccountCoreHierarchyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.BudgetPeriodCoreHierarchyNodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccounthierarchy.batch.DefaultBudgetAccountHierarchyServiceBatch;

/**
 * <p>
 *
 * This service enables you to read the budget account hierarchy data from SAP S/4HANA Cloud system. This service is
 * based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/2b/1dc384dd064cd68a7af9b60ce19ba9/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUDGETACCOUNTCOREHIER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUDGETACCOUNTCOREHIER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>General Ledger Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBudgetAccountHierarchyService" )
@Deprecated
public class DefaultBudgetAccountHierarchyService implements BudgetAccountHierarchyService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BudgetAccountHierarchyService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBudgetAccountHierarchyService()
    {
        servicePath = BudgetAccountHierarchyService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBudgetAccountHierarchyService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBudgetAccountHierarchyService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBudgetAccountHierarchyService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBudgetAccountHierarchyServiceBatch batch()
    {
        return new DefaultBudgetAccountHierarchyServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BudgetAccountCoreHierarchyFluentHelper getAllBudgetAccountCoreHierarchy()
    {
        return new BudgetAccountCoreHierarchyFluentHelper(servicePath, "BudgetAccountHierarchy");
    }

    @Override
    @Nonnull
    public
        BudgetAccountCoreHierarchyByKeyFluentHelper
        getBudgetAccountCoreHierarchyByKey( final String budgetAccountHierarchy, final LocalDateTime validityEndDate )
    {
        return new BudgetAccountCoreHierarchyByKeyFluentHelper(
            servicePath,
            "BudgetAccountHierarchy",
            budgetAccountHierarchy,
            validityEndDate);
    }

    @Override
    @Nonnull
    public BudgetAccountCoreHierarchyTextFluentHelper getAllBudgetAccountCoreHierarchyText()
    {
        return new BudgetAccountCoreHierarchyTextFluentHelper(servicePath, "BudgetAccountHierarchyText");
    }

    @Override
    @Nonnull
    public BudgetAccountCoreHierarchyTextByKeyFluentHelper getBudgetAccountCoreHierarchyTextByKey(
        final String budgetAccountHierarchy,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new BudgetAccountCoreHierarchyTextByKeyFluentHelper(
            servicePath,
            "BudgetAccountHierarchyText",
            budgetAccountHierarchy,
            validityEndDate,
            language);
    }

    @Override
    @Nonnull
    public BudgetAccountCoreHierNodeFluentHelper getAllBudgetAccountCoreHierNode()
    {
        return new BudgetAccountCoreHierNodeFluentHelper(servicePath, "BudgetAccountHierarchyNode");
    }

    @Override
    @Nonnull
    public BudgetAccountCoreHierNodeByKeyFluentHelper getBudgetAccountCoreHierNodeByKey(
        final String budgetAccountHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate )
    {
        return new BudgetAccountCoreHierNodeByKeyFluentHelper(
            servicePath,
            "BudgetAccountHierarchyNode",
            budgetAccountHierarchy,
            hierarchyNode,
            validityEndDate);
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierarchyNodeTextFluentHelper getAllBudgetPeriodCoreHierarchyNodeText()
    {
        return new BudgetPeriodCoreHierarchyNodeTextFluentHelper(servicePath, "BudgetAccountHierarchyNodeText");
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper getBudgetPeriodCoreHierarchyNodeTextByKey(
        final String budgetAccountHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper(
            servicePath,
            "BudgetAccountHierarchyNodeText",
            budgetAccountHierarchy,
            hierarchyNode,
            validityEndDate,
            language);
    }

}
