/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.BudgetAccountCoreTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetaccount.batch.DefaultBudgetAccountServiceBatch;

/**
 * <p>
 * This service enables you to read the budget account master data from SAP S/4HANA Cloud system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/fe/2e1ab0627041989ff48a2edad5ea3a/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUDGETACCOUNTCORE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUDGETACCOUNTCORE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.2</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>General Ledger Account</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBudgetAccountService" )
@Deprecated
public class DefaultBudgetAccountService implements BudgetAccountService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BudgetAccountService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBudgetAccountService()
    {
        servicePath = BudgetAccountService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBudgetAccountService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBudgetAccountService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBudgetAccountService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBudgetAccountServiceBatch batch()
    {
        return new DefaultBudgetAccountServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BudgetAccountCoreFluentHelper getAllBudgetAccountCore()
    {
        return new BudgetAccountCoreFluentHelper(servicePath, "BudgetAccount");
    }

    @Override
    @Nonnull
    public
        BudgetAccountCoreByKeyFluentHelper
        getBudgetAccountCoreByKey( final String pubSecBudgetAccount, final String pubSecBudgetAccountCoCode )
    {
        return new BudgetAccountCoreByKeyFluentHelper(
            servicePath,
            "BudgetAccount",
            pubSecBudgetAccount,
            pubSecBudgetAccountCoCode);
    }

    @Override
    @Nonnull
    public BudgetAccountCoreTextFluentHelper getAllBudgetAccountCoreText()
    {
        return new BudgetAccountCoreTextFluentHelper(servicePath, "BudgetAccountText");
    }

    @Override
    @Nonnull
    public BudgetAccountCoreTextByKeyFluentHelper getBudgetAccountCoreTextByKey(
        final String pubSecBudgetAccount,
        final String pubSecBudgetAccountCoCode,
        final String language )
    {
        return new BudgetAccountCoreTextByKeyFluentHelper(
            servicePath,
            "BudgetAccountText",
            pubSecBudgetAccount,
            pubSecBudgetAccountCoCode,
            language);
    }

}
