/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNodeByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierNodeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyNodeTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.BudgetPeriodCoreHierarchyTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiodhierarchy.batch.DefaultBudgetPeriodHierarchyServiceBatch;

/**
 * <p>
 *
 * This service enables you to read the budget period hierarchy data from SAP S/4HANA Cloud system. This service is
 * based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/6a/b585980a7b4885a8ea01280ab218f0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUDGETPERIODCOREHIER?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUDGETPERIODCOREHIER</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.1</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Budget Period</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBudgetPeriodHierarchyService" )
@Deprecated
public class DefaultBudgetPeriodHierarchyService implements BudgetPeriodHierarchyService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BudgetPeriodHierarchyService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBudgetPeriodHierarchyService()
    {
        servicePath = BudgetPeriodHierarchyService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBudgetPeriodHierarchyService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBudgetPeriodHierarchyService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBudgetPeriodHierarchyService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBudgetPeriodHierarchyServiceBatch batch()
    {
        return new DefaultBudgetPeriodHierarchyServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierarchyFluentHelper getAllBudgetPeriodCoreHierarchy()
    {
        return new BudgetPeriodCoreHierarchyFluentHelper(servicePath, "BudgetPeriodHierarchy");
    }

    @Override
    @Nonnull
    public
        BudgetPeriodCoreHierarchyByKeyFluentHelper
        getBudgetPeriodCoreHierarchyByKey( final String budgetPeriodHierarchy, final LocalDateTime validityEndDate )
    {
        return new BudgetPeriodCoreHierarchyByKeyFluentHelper(
            servicePath,
            "BudgetPeriodHierarchy",
            budgetPeriodHierarchy,
            validityEndDate);
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierarchyTextFluentHelper getAllBudgetPeriodCoreHierarchyText()
    {
        return new BudgetPeriodCoreHierarchyTextFluentHelper(servicePath, "BudgetPeriodHierarchyText");
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierarchyTextByKeyFluentHelper getBudgetPeriodCoreHierarchyTextByKey(
        final String budgetPeriodHierarchy,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new BudgetPeriodCoreHierarchyTextByKeyFluentHelper(
            servicePath,
            "BudgetPeriodHierarchyText",
            budgetPeriodHierarchy,
            validityEndDate,
            language);
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierNodeFluentHelper getAllBudgetPeriodCoreHierNode()
    {
        return new BudgetPeriodCoreHierNodeFluentHelper(servicePath, "BudgetPeriodHierarchyNode");
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierNodeByKeyFluentHelper getBudgetPeriodCoreHierNodeByKey(
        final String budgetPeriodHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate )
    {
        return new BudgetPeriodCoreHierNodeByKeyFluentHelper(
            servicePath,
            "BudgetPeriodHierarchyNode",
            budgetPeriodHierarchy,
            hierarchyNode,
            validityEndDate);
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierarchyNodeTextFluentHelper getAllBudgetPeriodCoreHierarchyNodeText()
    {
        return new BudgetPeriodCoreHierarchyNodeTextFluentHelper(servicePath, "BudgetPeriodHierarchyNodeText");
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper getBudgetPeriodCoreHierarchyNodeTextByKey(
        final String budgetPeriodHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language )
    {
        return new BudgetPeriodCoreHierarchyNodeTextByKeyFluentHelper(
            servicePath,
            "BudgetPeriodHierarchyNodeText",
            budgetPeriodHierarchy,
            hierarchyNode,
            validityEndDate,
            language);
    }

}
