/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriod;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCoreTextUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodDeleteFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.BudgetPeriodUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.budgetperiod.batch.DefaultBudgetPeriodServiceBatch;

/**
 * <p>
 * This service enables you to create, read, update, and delete the budget period master data from SAP S/4HANA Cloud
 * system.
 *
 * This service is based on the OData protocol and can be consumed in SAP Fiori apps and other user interfaces..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/3b/2bfd60176c444f8fdd2eaf3bbb0251/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUDGETPERIODCORE?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUDGETPERIODCORE</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.1.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Public Sector API Integration(SAP_COM_0761)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/6UC'>Government Budget Planning(6UC)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Budget Period</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBudgetPeriodService" )
@Deprecated
public class DefaultBudgetPeriodService implements BudgetPeriodService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BudgetPeriodService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBudgetPeriodService()
    {
        servicePath = BudgetPeriodService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBudgetPeriodService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBudgetPeriodService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBudgetPeriodService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBudgetPeriodServiceBatch batch()
    {
        return new DefaultBudgetPeriodServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BudgetPeriodFluentHelper getAllBudgetPeriod()
    {
        return new BudgetPeriodFluentHelper(servicePath, "BudgetPeriod");
    }

    @Override
    @Nonnull
    public BudgetPeriodByKeyFluentHelper getBudgetPeriodByKey( final String budgetPeriod )
    {
        return new BudgetPeriodByKeyFluentHelper(servicePath, "BudgetPeriod", budgetPeriod);
    }

    @Override
    @Nonnull
    public BudgetPeriodCreateFluentHelper createBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod )
    {
        return new BudgetPeriodCreateFluentHelper(servicePath, budgetPeriod, "BudgetPeriod");
    }

    @Override
    @Nonnull
    public BudgetPeriodUpdateFluentHelper updateBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod )
    {
        return new BudgetPeriodUpdateFluentHelper(servicePath, budgetPeriod, "BudgetPeriod");
    }

    @Override
    @Nonnull
    public BudgetPeriodDeleteFluentHelper deleteBudgetPeriod( @Nonnull final BudgetPeriod budgetPeriod )
    {
        return new BudgetPeriodDeleteFluentHelper(servicePath, budgetPeriod, "BudgetPeriod");
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreTextFluentHelper getAllBudgetPeriodCoreText()
    {
        return new BudgetPeriodCoreTextFluentHelper(servicePath, "BudgetPeriodText");
    }

    @Override
    @Nonnull
    public
        BudgetPeriodCoreTextByKeyFluentHelper
        getBudgetPeriodCoreTextByKey( final String language, final String budgetPeriod )
    {
        return new BudgetPeriodCoreTextByKeyFluentHelper(servicePath, "BudgetPeriodText", language, budgetPeriod);
    }

    @Override
    @Nonnull
    public BudgetPeriodCoreTextUpdateFluentHelper updateBudgetPeriodCoreText(
        @Nonnull final BudgetPeriodCoreText budgetPeriodCoreText )
    {
        return new BudgetPeriodCoreTextUpdateFluentHelper(servicePath, budgetPeriodCoreText, "BudgetPeriodText");
    }

}
