/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlantByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileAssignedToPlantFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetailsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.ProfileDetailsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.bufferprofile.batch.DefaultBufferProfileServiceBatch;

/**
 * <p>
 *
 * The service contains header and item entities. For read operations, filter information must be sent according to the
 * OData protocol. All filter information is utilized when retrieving buffer profile. The buffer profile assigned to
 * plant and the buffer profile details are sent in the response. If any issues arise when buffer profiles are
 * retrieved, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/8a/10dda19ed746158b6b2b2c5a020316/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUFFER_PROFILE_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUFFER_PROFILE_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Buffer Profile Integration(SAP_COM_0349)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Y2'>Demand-Driven Buffer Level Management(1Y2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBufferProfileService" )
@Deprecated
public class DefaultBufferProfileService implements BufferProfileService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BufferProfileService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBufferProfileService()
    {
        servicePath = BufferProfileService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBufferProfileService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBufferProfileService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBufferProfileService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBufferProfileServiceBatch batch()
    {
        return new DefaultBufferProfileServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public ProfileDetailsFluentHelper getAllProfileDetails()
    {
        return new ProfileDetailsFluentHelper(servicePath, "A_ProfileDetails");
    }

    @Override
    @Nonnull
    public ProfileDetailsByKeyFluentHelper getProfileDetailsByKey(
        final String plant,
        final String procurementType,
        final String variabilityCode,
        final String replenishmentLeadTimeCode,
        final String isMinOrderQtyConsidered )
    {
        return new ProfileDetailsByKeyFluentHelper(
            servicePath,
            "A_ProfileDetails",
            plant,
            procurementType,
            variabilityCode,
            replenishmentLeadTimeCode,
            isMinOrderQtyConsidered);
    }

    @Override
    @Nonnull
    public ProfileAssignedToPlantFluentHelper getAllProfileAssignedToPlant()
    {
        return new ProfileAssignedToPlantFluentHelper(servicePath, "A_ProfileAssignedToPlant");
    }

    @Override
    @Nonnull
    public ProfileAssignedToPlantByKeyFluentHelper getProfileAssignedToPlantByKey( final String plant )
    {
        return new ProfileAssignedToPlantByKeyFluentHelper(servicePath, "A_ProfileAssignedToPlant", plant);
    }

}
