/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import java.time.LocalDateTime;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStockByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ActualStockFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.AdoptFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactors;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentFactorsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustments;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DemandAdjustmentsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.DiscardFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOMByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.LongestPathInBOMFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderCreateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ProposalHeaderFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ResumeFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.SuspendFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustments;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.ZoneAdjustmentsUpdateFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.buffersizing.batch.DefaultBufferSizingServiceBatch;

/**
 * <p>
 *
 * The service contains header and item entities. For read operations, filter information must be sent according to the
 * OData protocol. All filter information is utilized when retrieving buffer sizing data, such as, buffer proposals,
 * average daily usage (ADU), decoupled lead time (DLT), demand and zone adjustments. The buffer proposal, ADU, DLT,
 * longest path in BOM, and actual stock level details are sent in the response. If any issues arise when buffer sizing
 * details are retrieved, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/61/9f71272fd044d1958f2a08474086a0/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUFFERSIZING_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUFFERSIZING_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Buffer Sizing Integration(SAP_COM_0359)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Y2'>Demand-Driven Buffer Level Management(1Y2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBufferSizingService" )
@Deprecated
public class DefaultBufferSizingService implements BufferSizingService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BufferSizingService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBufferSizingService()
    {
        servicePath = BufferSizingService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBufferSizingService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBufferSizingService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBufferSizingService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBufferSizingServiceBatch batch()
    {
        return new DefaultBufferSizingServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public DemandAdjustmentsFluentHelper getAllDemandAdjustments()
    {
        return new DemandAdjustmentsFluentHelper(servicePath, "A_DemandAdjustments");
    }

    @Override
    @Nonnull
    public DemandAdjustmentsByKeyFluentHelper getDemandAdjustmentsByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion,
        final LocalDateTime proposalDmndAdjmtFctrStartDate )
    {
        return new DemandAdjustmentsByKeyFluentHelper(
            servicePath,
            "A_DemandAdjustments",
            material,
            plant,
            mRPArea,
            proposalStartDate,
            proposalVersion,
            proposalDmndAdjmtFctrStartDate);
    }

    @Override
    @Nonnull
    public DemandAdjustmentsUpdateFluentHelper updateDemandAdjustments(
        @Nonnull final DemandAdjustments demandAdjustments )
    {
        return new DemandAdjustmentsUpdateFluentHelper(servicePath, demandAdjustments, "A_DemandAdjustments");
    }

    @Override
    @Nonnull
    public DemandAdjustmentFactorsFluentHelper getAllDemandAdjustmentFactors()
    {
        return new DemandAdjustmentFactorsFluentHelper(servicePath, "A_DemandAdjustmentFactors");
    }

    @Override
    @Nonnull
    public DemandAdjustmentFactorsByKeyFluentHelper getDemandAdjustmentFactorsByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion,
        final LocalDateTime proposalDmndAdjmtFctrStartDate )
    {
        return new DemandAdjustmentFactorsByKeyFluentHelper(
            servicePath,
            "A_DemandAdjustmentFactors",
            material,
            plant,
            mRPArea,
            proposalStartDate,
            proposalVersion,
            proposalDmndAdjmtFctrStartDate);
    }

    @Override
    @Nonnull
    public DemandAdjustmentFactorsUpdateFluentHelper updateDemandAdjustmentFactors(
        @Nonnull final DemandAdjustmentFactors demandAdjustmentFactors )
    {
        return new DemandAdjustmentFactorsUpdateFluentHelper(
            servicePath,
            demandAdjustmentFactors,
            "A_DemandAdjustmentFactors");
    }

    @Override
    @Nonnull
    public ZoneAdjustmentsFluentHelper getAllZoneAdjustments()
    {
        return new ZoneAdjustmentsFluentHelper(servicePath, "A_ZoneAdjustments");
    }

    @Override
    @Nonnull
    public ZoneAdjustmentsByKeyFluentHelper getZoneAdjustmentsByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion,
        final LocalDateTime bufPrpslZoneAdjmtFctrStartDate )
    {
        return new ZoneAdjustmentsByKeyFluentHelper(
            servicePath,
            "A_ZoneAdjustments",
            material,
            plant,
            mRPArea,
            proposalStartDate,
            proposalVersion,
            bufPrpslZoneAdjmtFctrStartDate);
    }

    @Override
    @Nonnull
    public ZoneAdjustmentsUpdateFluentHelper updateZoneAdjustments( @Nonnull final ZoneAdjustments zoneAdjustments )
    {
        return new ZoneAdjustmentsUpdateFluentHelper(servicePath, zoneAdjustments, "A_ZoneAdjustments");
    }

    @Override
    @Nonnull
    public ProposalHeaderFluentHelper getAllProposalHeader()
    {
        return new ProposalHeaderFluentHelper(servicePath, "A_ProposalHeader");
    }

    @Override
    @Nonnull
    public ProposalHeaderByKeyFluentHelper getProposalHeaderByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion )
    {
        return new ProposalHeaderByKeyFluentHelper(
            servicePath,
            "A_ProposalHeader",
            material,
            plant,
            mRPArea,
            proposalStartDate,
            proposalVersion);
    }

    @Override
    @Nonnull
    public ProposalHeaderCreateFluentHelper createProposalHeader( @Nonnull final ProposalHeader proposalHeader )
    {
        return new ProposalHeaderCreateFluentHelper(servicePath, proposalHeader, "A_ProposalHeader");
    }

    @Override
    @Nonnull
    public ActualStockFluentHelper getAllActualStock()
    {
        return new ActualStockFluentHelper(servicePath, "A_ActualStock");
    }

    @Override
    @Nonnull
    public ActualStockByKeyFluentHelper getActualStockByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime bufferLevelStartDate )
    {
        return new ActualStockByKeyFluentHelper(
            servicePath,
            "A_ActualStock",
            material,
            plant,
            mRPArea,
            bufferLevelStartDate);
    }

    @Override
    @Nonnull
    public LongestPathInBOMFluentHelper getAllLongestPathInBOM()
    {
        return new LongestPathInBOMFluentHelper(servicePath, "A_LongestPathInBOM");
    }

    @Override
    @Nonnull
    public LongestPathInBOMByKeyFluentHelper getLongestPathInBOMByKey(
        final String material,
        final String plant,
        final String mRPArea,
        final LocalDateTime proposalStartDate,
        final String proposalVersion,
        final UUID billOfMaterialUUID,
        final String parentComponent,
        final String parentPlant,
        final String billOfMaterialComponent,
        final String componentPlant )
    {
        return new LongestPathInBOMByKeyFluentHelper(
            servicePath,
            "A_LongestPathInBOM",
            material,
            plant,
            mRPArea,
            proposalStartDate,
            proposalVersion,
            billOfMaterialUUID,
            parentComponent,
            parentPlant,
            billOfMaterialComponent,
            componentPlant);
    }

    @Override
    @Nonnull
    public AdoptFluentHelper adopt(
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDateTime proposalStartDate,
        @Nonnull final String proposalVersion )
    {
        return new AdoptFluentHelper(servicePath, material, plant, mRPArea, proposalStartDate, proposalVersion);
    }

    @Override
    @Nonnull
    public DiscardFluentHelper discard(
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDateTime proposalStartDate,
        @Nonnull final String proposalVersion )
    {
        return new DiscardFluentHelper(servicePath, material, plant, mRPArea, proposalStartDate, proposalVersion);
    }

    @Override
    @Nonnull
    public ResumeFluentHelper resume(
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDateTime proposalStartDate,
        @Nonnull final String proposalVersion )
    {
        return new ResumeFluentHelper(servicePath, material, plant, mRPArea, proposalStartDate, proposalVersion);
    }

    @Override
    @Nonnull
    public SuspendFluentHelper suspend(
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDateTime proposalStartDate,
        @Nonnull final String proposalVersion,
        @Nullable final String stockLevelProposalStatus,
        @Nullable final LocalDateTime proposalRunSuspendedFromDate,
        @Nullable final LocalDateTime proposalRunSuspendedToDate )
    {
        return new SuspendFluentHelper(
            servicePath,
            material,
            plant,
            mRPArea,
            proposalStartDate,
            proposalVersion,
            stockLevelProposalStatus,
            proposalRunSuspendedFromDate,
            proposalRunSuspendedToDate);
    }

}
