/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.BusinessAreaByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.BusinessAreaFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.BusinessAreaTextByKeyFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.BusinessAreaTextFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessarea.batch.DefaultBusinessAreaServiceBatch;

/**
 * <p>
 *
 * The service enables you to retrieve business areas and their names in the respective language..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/2302.latest/EN/c6/cac6aefe1e4505bb0674fecfd5ad39/frameset.htm?profile=20036245'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_BUSINESSAREA_SRV?section=OVERVIEW'>SAP
 * Business Accelerator Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_BUSINESSAREA_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1.0.0</td>
 * </tr>
 * <tr>
 * <td align='right'>Minimum ERP Version:</td>
 * <td>2302</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Analytics Cloud for Planning Integration(SAP_COM_0087), Finance - Cloud Consolidation Data Collection
 * Integration(SAP_COM_0241)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1YB'>Import Connection setup with SAP Analytics Cloud(1YB)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/287'>Group Reporting - Data from SAP Group Reporting Data
 * Collection(287)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>BusinessArea</td>
 * </tr>
 * </table>
 *
 * @deprecated The service and all its related classes are deprecated. Please use the odata generator to generate the
 *             VDM.
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odata.services.DefaultBusinessAreaService" )
@Deprecated
public class DefaultBusinessAreaService implements BusinessAreaService
{

    @Nonnull
    private final String servicePath;

    /**
     * Creates a service using {@link BusinessAreaService#DEFAULT_SERVICE_PATH} to send the requests.
     *
     */
    public DefaultBusinessAreaService()
    {
        servicePath = BusinessAreaService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     *
     */
    private DefaultBusinessAreaService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultBusinessAreaService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultBusinessAreaService(servicePath);
    }

    @Override
    @Nonnull
    public DefaultBusinessAreaServiceBatch batch()
    {
        return new DefaultBusinessAreaServiceBatch(this, servicePath);
    }

    @Override
    @Nonnull
    public BusinessAreaFluentHelper getAllBusinessArea()
    {
        return new BusinessAreaFluentHelper(servicePath, "A_BusinessArea");
    }

    @Override
    @Nonnull
    public BusinessAreaByKeyFluentHelper getBusinessAreaByKey( final String businessArea )
    {
        return new BusinessAreaByKeyFluentHelper(servicePath, "A_BusinessArea", businessArea);
    }

    @Override
    @Nonnull
    public BusinessAreaTextFluentHelper getAllBusinessAreaText()
    {
        return new BusinessAreaTextFluentHelper(servicePath, "A_BusinessAreaText");
    }

    @Override
    @Nonnull
    public
        BusinessAreaTextByKeyFluentHelper
        getBusinessAreaTextByKey( final String businessArea, final String language )
    {
        return new BusinessAreaTextByKeyFluentHelper(servicePath, "A_BusinessAreaText", businessArea, language);
    }

}
